/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.pandomium.settings;

import java.io.File;
import org.panda_lang.pandomium.settings.PandomiumSettings;
import org.panda_lang.pandomium.settings.categories.CommandLineSettings;
import org.panda_lang.pandomium.settings.categories.DependenciesSettings;
import org.panda_lang.pandomium.settings.categories.LoaderSettings;
import org.panda_lang.pandomium.settings.categories.NativesSettings;
import org.panda_lang.pandomium.util.os.PandomiumOSType;

public class PandomiumSettingsBuilder {
    private CommandLineSettings commandLineSettings = new CommandLineSettings();
    private DependenciesSettings dependenciesSettings = new DependenciesSettings();
    private NativesSettings nativesSettings = new NativesSettings();
    private LoaderSettings loaderSettings = new LoaderSettings();

    public PandomiumSettingsBuilder proxy(String hostname, int port) {
        this.commandLineSettings.addArgument("--proxy-server=" + hostname + ":" + port);
        return this;
    }

    public PandomiumSettingsBuilder argument(String argument) {
        this.commandLineSettings.addArgument(argument);
        return this;
    }

    public PandomiumSettingsBuilder dependencyURL(PandomiumOSType os, String url) {
        switch (os) {
            case OS_WINDOWS: {
                this.dependenciesSettings.setWindowsModule(url);
                break;
            }
            case OS_MAC: {
                this.dependenciesSettings.setMacOSModule(url);
                break;
            }
            case OS_LINUX: {
                this.dependenciesSettings.setLinuxModule(url);
                break;
            }
            case UNKNOWN: {
                throw new RuntimeException("Unsupported OS type");
            }
        }
        return this;
    }

    public PandomiumSettingsBuilder nativeDirectory(String nativeDirectory) {
        File file = new File(nativeDirectory);
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Cannot create native directory");
        }
        this.nativesSettings.setNativeDirectory(file.getAbsolutePath());
        return this;
    }

    public PandomiumSettingsBuilder loadAsync(boolean async) {
        this.loaderSettings.setLoadAsync(async);
        return this;
    }

    public PandomiumSettings build() {
        return new PandomiumSettings(this.commandLineSettings, this.dependenciesSettings, this.nativesSettings, this.loaderSettings);
    }
}

