/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.certificate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x2br.security.certificate.ICPBRCertificateEquipment;
import x2br.security.certificate.ICPBRCertificatePF;
import x2br.security.certificate.ICPBRCertificatePJ;
import x2br.security.certificate.ICPBRKeyUsage;
import x2br.security.certificate.ICPBRSubjectAlternativeNames;
import x2br.security.certificate.ICPBR_DN;

public class BasicCertificate {
    private static final Logger logger = LoggerFactory.getLogger(BasicCertificate.class);
    public static final String OID_A1_CERTIFICATE = "2.16.76.1.2.1";
    public static final String OID_A2_CERTIFICATE = "2.16.76.1.2.2";
    public static final String OID_A3_CERTIFICATE = "2.16.76.1.2.3";
    public static final String OID_A4_CERTIFICATE = "2.16.76.1.2.4";
    public static final String OID_S1_CERTIFICATE = "2.16.76.1.2.101";
    public static final String OID_S2_CERTIFICATE = "2.16.76.1.2.102";
    public static final String OID_S3_CERTIFICATE = "2.16.76.1.2.103";
    public static final String OID_S4_CERTIFICATE = "2.16.76.1.2.104";
    private X509Certificate certificate = null;
    private ICPBRSubjectAlternativeNames subjectAlternativeNames = null;
    private ICPBRKeyUsage keyUsage = null;
    private ICPBR_DN certificateFrom = null;
    private ICPBR_DN certificateFor = null;

    public BasicCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public BasicCertificate(byte[] data) throws Exception {
        this.certificate = this.getCertificate(data);
    }

    public BasicCertificate(InputStream is) throws IOException, Exception {
        this.certificate = this.getCertificate(is);
    }

    private X509Certificate getCertificate(InputStream is) throws CertificateException, IOException, Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        return cert;
    }

    private String toString(byte[] data) {
        if (data == null) {
            return null;
        }
        return this.toString(new BigInteger(1, data));
    }

    private String toString(BigInteger bi) {
        if (bi == null) {
            return null;
        }
        String ret = bi.toString(16);
        if (ret.length() % 2 == 1) {
            ret = "0" + ret;
        }
        return ret.toUpperCase();
    }

    private X509Certificate getCertificate(byte[] data) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        X509Certificate cert = this.getCertificate(bis);
        bis.close();
        bis = null;
        return cert;
    }

    public X509Certificate getX509Certificate() {
        return this.certificate;
    }

    public ICPBR_DN getCertificateIssuerDN() throws IOException {
        if (this.certificateFrom == null) {
            this.certificateFrom = new ICPBR_DN(this.certificate.getIssuerDN().getName());
        }
        return this.certificateFrom;
    }

    public String getSerialNumber() {
        return this.toString(this.certificate.getSerialNumber());
    }

    public ICPBR_DN getCertificateSubjectDN() throws IOException {
        if (this.certificateFor == null) {
            this.certificateFor = new ICPBR_DN(this.certificate.getSubjectDN().getName());
        }
        return this.certificateFor;
    }

    public String getNome() {
        try {
            String nome = this.getCertificateSubjectDN().getProperty("CN");
            int pos = nome.indexOf(58);
            if (pos > 0) {
                return nome.substring(0, pos);
            }
            return nome;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Date getBeforeDate() {
        return this.certificate.getNotBefore();
    }

    public Date getAfterDate() {
        return this.certificate.getNotAfter();
    }

    public ICPBRKeyUsage getICPBRKeyUsage() {
        if (this.keyUsage == null) {
            this.keyUsage = new ICPBRKeyUsage(this.certificate);
        }
        return this.keyUsage;
    }

    public ICPBRSubjectAlternativeNames getICPBRSubjectAlternativeNames() {
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNames = new ICPBRSubjectAlternativeNames(this.certificate);
        }
        return this.subjectAlternativeNames;
    }

    public String getEmail() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return null;
        }
        return this.getICPBRSubjectAlternativeNames().getEmail();
    }

    public boolean hasCertificatePF() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return false;
        }
        return this.getICPBRSubjectAlternativeNames().isCertificatePF();
    }

    public ICPBRCertificatePF getICPBRCertificatePF() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return null;
        }
        return this.getICPBRSubjectAlternativeNames().getICPBRCertificatePF();
    }

    public boolean hasCertificatePJ() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return false;
        }
        return this.getICPBRSubjectAlternativeNames().isCertificatePJ();
    }

    public ICPBRCertificatePJ getICPBRCertificatePJ() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return null;
        }
        return this.getICPBRSubjectAlternativeNames().getICPBRCertificatePJ();
    }

    public boolean hasCertificateEquipment() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return false;
        }
        return this.getICPBRSubjectAlternativeNames().isCertificateEquipment();
    }

    public ICPBRCertificateEquipment getICPBRCertificateEquipment() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return null;
        }
        return this.getICPBRSubjectAlternativeNames().getICPBRCertificateEquipment();
    }

    public int getPathLength() {
        return this.certificate.getBasicConstraints();
    }

    public boolean isCertificadoAc() {
        return this.certificate.getBasicConstraints() >= 0;
    }

    public String getNivelCertificado() {
        try {
            DERSequence seq = (DERSequence)this.getExtensionValue(X509Extensions.CertificatePolicies.getId());
            if (seq == null) {
                return null;
            }
            for (int pos = 0; pos < seq.size(); ++pos) {
                PolicyInformation policyInformation = new PolicyInformation((ASN1Sequence)seq.getObjectAt(pos));
                String id = policyInformation.getPolicyIdentifier().getId();
                if (id == null) continue;
                if (id.startsWith(OID_A1_CERTIFICATE)) {
                    return "A1";
                }
                if (id.startsWith(OID_A2_CERTIFICATE)) {
                    return "A2";
                }
                if (id.startsWith(OID_A3_CERTIFICATE)) {
                    return "A3";
                }
                if (id.startsWith(OID_A4_CERTIFICATE)) {
                    return "A4";
                }
                if (id.startsWith(OID_S1_CERTIFICATE)) {
                    return "S1";
                }
                if (id.startsWith(OID_S2_CERTIFICATE)) {
                    return "S2";
                }
                if (id.startsWith(OID_S3_CERTIFICATE)) {
                    return "S3";
                }
                if (!id.startsWith(OID_S4_CERTIFICATE)) continue;
                return "S4";
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getAuthorityKeyIdentifier() throws IOException {
        DERSequence seq = (DERSequence)this.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
        if (seq == null || seq.size() == 0) {
            return null;
        }
        DERTaggedObject tag = (DERTaggedObject)seq.getObjectAt(0);
        DEROctetString oct = (DEROctetString)DEROctetString.getInstance(tag);
        return this.toString(oct.getOctets());
    }

    public String getSubjectKeyIdentifier() throws IOException {
        DEROctetString oct = (DEROctetString)this.getExtensionValue(X509Extensions.SubjectKeyIdentifier.getId());
        if (oct == null) {
            return null;
        }
        return this.toString(oct.getOctets());
    }

    public List<String> getCRLDistributionPoint() throws IOException {
        ArrayList<String> lcrS = new ArrayList<String>();
        DERObject derObj = this.getExtensionValue(X509Extensions.CRLDistributionPoints.getId());
        if (derObj == null) {
            return null;
        }
        CRLDistPoint crlDistPoint = CRLDistPoint.getInstance(derObj);
        DistributionPoint[] dp = crlDistPoint.getDistributionPoints();
        for (int i = 0; i < dp.length; ++i) {
            DERSequence seq = (DERSequence)new ASN1InputStream(dp[i].getDistributionPoint().getName().getDEREncoded()).readObject();
            DERTaggedObject tag = (DERTaggedObject)seq.getObjectAt(0);
            try {
                ASN1OctetString oct = DEROctetString.getInstance(tag);
                lcrS.add(new String(oct.getOctets()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lcrS;
    }

    public DERObject getExtensionValue(String oid) {
        byte[] extvalue = this.certificate.getExtensionValue(oid);
        if (extvalue == null) {
            return null;
        }
        try {
            DEROctetString oct = (DEROctetString)new ASN1InputStream(extvalue).readObject();
            return new ASN1InputStream(oct.getOctets()).readObject();
        }
        catch (IOException ex) {
            logger.info(ex.getMessage());
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            SimpleDateFormat dtValidade = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            builder.append("\n");
            builder.append("-----------------------------------------\n");
            builder.append("Certificado de..........[").append(this.getCertificateIssuerDN()).append("]\n");
            builder.append("Serial Number...........[").append(this.getSerialNumber()).append("]\n");
            builder.append("Certificado para........[").append(this.getCertificateSubjectDN()).append("]\n");
            builder.append("Nome do Certif..........[").append(this.getNome()).append("]\n");
            builder.append("Validade................[").append(dtValidade.format(this.getBeforeDate())).append(" ate ").append(dtValidade.format(this.getAfterDate())).append("]\n");
            builder.append("Email...................[").append(this.getEmail()).append("]\n");
            builder.append("-----------------------------------------\n");
            builder.append("Tem dados PF............[").append(this.hasCertificatePF()).append("]\n");
            if (this.hasCertificatePF()) {
                ICPBRCertificatePF ippBRCertificatePF = this.getICPBRCertificatePF();
                builder.append("CPF.....................[").append(ippBRCertificatePF.getCPF()).append("]\n");
                builder.append("Data Nascimento.........[").append(ippBRCertificatePF.getDataNascimento()).append("]\n");
                builder.append("PIS.....................[").append(ippBRCertificatePF.getNis()).append("]\n");
                builder.append("RG......................[").append(ippBRCertificatePF.getRg()).append("]\n");
                builder.append("Org\u00e3o RG................[").append(ippBRCertificatePF.getOrgaoExpedidorRg()).append("]\n");
                builder.append("UF RG...................[").append(ippBRCertificatePF.getUfExpedidorRg()).append("]\n");
                builder.append("CEI.....................[").append(ippBRCertificatePF.getCEI()).append("]\n");
                builder.append("Titulo..................[").append(ippBRCertificatePF.getTituloEleitor()).append("]\n");
                builder.append("Se\u00e7\u00e3o...................[").append(ippBRCertificatePF.getSecaoTituloEleitor()).append("]\n");
                builder.append("Zona....................[").append(ippBRCertificatePF.getZonaTituloEleitor()).append("]\n");
                builder.append("Municipio Titulo........[").append(ippBRCertificatePF.getMunicipioTituloEleitor()).append("]\n");
                builder.append("UF Titulo...............[").append(ippBRCertificatePF.getUfTituloEleitor()).append("]\n");
            }
            builder.append("-----------------------------------------\n");
            builder.append("Tem dados PJ............[").append(this.hasCertificatePF()).append("]\n");
            if (this.hasCertificatePJ()) {
                ICPBRCertificatePJ tdPJ = this.getICPBRCertificatePJ();
                builder.append("CNPJ....................[").append(tdPJ.getCNPJ()).append("]\n");
                builder.append("CEI.....................[").append(tdPJ.getCEI()).append("]\n");
                builder.append("NIS.....................[").append(tdPJ.getNis()).append("]\n");
                builder.append("Respons\u00e1vel.............[").append(tdPJ.getNomeResponsavel()).append("]\n");
            }
            builder.append("-----------------------------------------\n");
            builder.append("Tem dados Equip.........:").append(this.hasCertificateEquipment()).append("]\n");
            if (this.hasCertificateEquipment()) {
                ICPBRCertificateEquipment tdEq = this.getICPBRCertificateEquipment();
                builder.append("CNPJ....................[").append(tdEq.getCNPJ()).append("]\n");
                builder.append("NIS.....................[").append(tdEq.getNis()).append("]\n");
                builder.append("Nome Empresa............[").append(tdEq.getNomeEmpresarial()).append("]\n");
                builder.append("Respons\u00e1vel.............[").append(tdEq.getNomeResponsavel()).append("]\n");
            }
            builder.append("-----------------------------------------\n");
            builder.append("Eh CertificadoAC........[").append(this.isCertificadoAc()).append("]\n");
            builder.append("PathLength..............[").append(this.getPathLength()).append("]\n");
            builder.append("Tipo Certificado........[").append(this.getNivelCertificado()).append("]\n");
            builder.append("Tipo de Uso.............[").append(this.getICPBRKeyUsage()).append("]\n");
            builder.append("-----------------------------------------\n");
            builder.append("Authority KeyID.........[").append(this.getAuthorityKeyIdentifier()).append("]\n");
            builder.append("Subject KeyID...........[").append(this.getSubjectKeyIdentifier()).append("]\n");
            builder.append("CRL DistPoint...........[").append(this.getCRLDistributionPoint()).append("]\n");
        }
        catch (IOException ex) {
            logger.info(ex.getMessage());
        }
        return builder.toString();
    }
}

