/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.certificate;

import java.security.cert.X509Certificate;

public class ICPBRKeyUsage {
    private static final String[] KEY_USAGE = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};
    private final boolean[] keyUsage;

    public ICPBRKeyUsage(X509Certificate cert) {
        this.keyUsage = cert.getKeyUsage();
    }

    public boolean isDigitalSignature() {
        return this.keyUsage[0];
    }

    public boolean isNonRepudiation() {
        return this.keyUsage[1];
    }

    public boolean isKeyEncipherment() {
        return this.keyUsage[2];
    }

    public boolean isDataEncipherment() {
        return this.keyUsage[3];
    }

    public boolean isKeyAgreement() {
        return this.keyUsage[4];
    }

    public boolean isKeyCertSign() {
        return this.keyUsage[5];
    }

    public boolean isCRLSign() {
        return this.keyUsage[6];
    }

    public boolean isEncipherOnly() {
        return this.keyUsage[7];
    }

    public boolean isDecipherOnly() {
        return this.keyUsage[8];
    }

    public String toString() {
        String ret = "";
        if (this.keyUsage != null) {
            for (int i = 0; i < this.keyUsage.length; ++i) {
                if (!this.keyUsage[i]) continue;
                if (ret.length() > 0) {
                    ret = ret + ", ";
                }
                ret = ret + KEY_USAGE[i];
            }
        }
        return ret;
    }
}

