/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.certificate;

import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x2br.security.certificate.ICPBRCertificateEquipment;
import x2br.security.certificate.ICPBRCertificatePF;
import x2br.security.certificate.ICPBRCertificatePJ;
import x2br.security.certificate.extension.CertificateExtra;

public class ICPBRSubjectAlternativeNames {
    private static final Logger logger = LoggerFactory.getLogger(ICPBRSubjectAlternativeNames.class);
    private String email = null;
    private ICPBRCertificatePF icpBRCertificatePF = null;
    private ICPBRCertificatePJ icpBRCertificatePJ = null;
    private ICPBRCertificateEquipment icpBRCertificateEquipment = null;

    public ICPBRSubjectAlternativeNames(X509Certificate certificate) {
        CertificateExtra certificateExtra = new CertificateExtra(certificate);
        if (certificateExtra.isCertificatePF()) {
            this.icpBRCertificatePF = new ICPBRCertificatePF(certificateExtra.getOID_2_16_76_1_3_1(), certificateExtra.getOID_2_16_76_1_3_5(), certificateExtra.getOID_2_16_76_1_3_6(), certificateExtra.getOID_2_16_76_1_3_9());
        } else if (certificateExtra.isCertificatePJ()) {
            this.icpBRCertificatePJ = new ICPBRCertificatePJ(certificateExtra.getOID_2_16_76_1_3_2(), certificateExtra.getOID_2_16_76_1_3_3(), certificateExtra.getOID_2_16_76_1_3_4(), certificateExtra.getOID_2_16_76_1_3_7());
        } else if (certificateExtra.isCertificateEquipment()) {
            this.icpBRCertificateEquipment = new ICPBRCertificateEquipment(certificateExtra.getOID_2_16_76_1_3_2(), certificateExtra.getOID_2_16_76_1_3_3(), certificateExtra.getOID_2_16_76_1_3_4(), certificateExtra.getOID_2_16_76_1_3_8());
        }
        this.email = certificateExtra.getEmail();
    }

    public boolean isCertificatePF() {
        return this.icpBRCertificatePF != null;
    }

    public ICPBRCertificatePF getICPBRCertificatePF() {
        return this.icpBRCertificatePF;
    }

    public boolean isCertificatePJ() {
        return this.icpBRCertificatePJ != null;
    }

    public ICPBRCertificatePJ getICPBRCertificatePJ() {
        return this.icpBRCertificatePJ;
    }

    public boolean isCertificateEquipment() {
        return this.icpBRCertificateEquipment != null;
    }

    public ICPBRCertificateEquipment getICPBRCertificateEquipment() {
        return this.icpBRCertificateEquipment;
    }

    public String getEmail() {
        return this.email;
    }
}

