/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.driver.http.server;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import fi.iki.elonen.util.ServerRunner;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import x2br.security.signer.pkcs11.TokenLogin;
import x2br.security.signer.ui.model.Message;

public final class TokenDriverHttpServer
extends RouterNanoHTTPD {
    private static final Logger LOG = Logger.getLogger(TokenDriverHttpServer.class.getName());
    private static final int PORT = 9595;

    public static void main(String[] args) {
        System.out.println("***********************************");
        System.out.println("*");
        System.out.println("*");
        System.out.println("*           R   U   N  N   E   R");
        System.out.println("*");
        System.out.println("*");
        System.out.println("***********************************");
        ServerRunner.run(TokenDriverHttpServer.class);
    }

    public TokenDriverHttpServer() {
        super(9595);
        this.addMappings();
        System.out.println("\nRunning! Point your browers to http://localhost:9595/ \n");
    }

    public void exit() {
        Runtime.getRuntime().exit(0);
    }

    private static void renderGUI() {
        JFrame jFrame = new JFrame("HelloWorld Swing");
        jFrame.setDefaultCloseOperation(3);
        JLabel helloLabel = new JLabel("Hello World!");
        jFrame.getContentPane().add(helloLabel);
        jFrame.pack();
        jFrame.setVisible(true);
        ServerRunner.run(TokenDriverHttpServer.class);
    }

    @Override
    public void addMappings() {
        super.addMappings();
        this.addRoute("/etoken", ETokenHandler.class, new Object[0]);
        this.addRoute("/user", UserHandler.class, new Object[0]);
        this.addRoute("/user/:id", UserHandler.class, new Object[0]);
        this.addRoute("/general/:param1/:param2", RouterNanoHTTPD.GeneralHandler.class, new Object[0]);
        this.addRoute("/stream", StreamUrl.class, new Object[0]);
    }

    public static class UserHandler
    extends RouterNanoHTTPD.DefaultHandler {
        @Override
        public String getText() {
            return "not implemented";
        }

        public String getText(Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            String value;
            String key;
            String text = "<html><body>User handler. Method: " + session.getMethod().toString() + "<br>";
            text = text + "<h1>Uri parameters:</h1>";
            for (Map.Entry<String, String> entry : urlParams.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                text = text + "<div> Param: " + key + "&nbsp;Value: " + value + "</div>";
            }
            text = text + "<h1>Query parameters:</h1>";
            for (Map.Entry<String, String> entry : session.getParms().entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                text = text + "<div> Query Param: " + key + "&nbsp;Value: " + value + "</div>";
            }
            text = text + "</body></html>";
            return text;
        }

        @Override
        public String getMimeType() {
            return "text/html";
        }

        @Override
        public NanoHTTPD.Response.IStatus getStatus() {
            return NanoHTTPD.Response.Status.OK;
        }

        @Override
        public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            String text = this.getText(urlParams, session);
            ByteArrayInputStream inp = new ByteArrayInputStream(text.getBytes());
            int size = text.getBytes().length;
            return NanoHTTPD.newFixedLengthResponse(this.getStatus(), this.getMimeType(), inp, size);
        }
    }

    public static class ETokenHandler
    extends RouterNanoHTTPD.DefaultHandler {
        @Override
        public String getText() {
            return "not implemented";
        }

        public Message getText(Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            Message msg = new TokenLogin().toJson();
            return msg;
        }

        @Override
        public String getMimeType() {
            return "text/json";
        }

        @Override
        public NanoHTTPD.Response.IStatus getStatus() {
            return NanoHTTPD.Response.Status.OK;
        }

        @Override
        public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
            Message msg = this.getText(urlParams, session);
            String text = msg.toString();
            ByteArrayInputStream inp = new ByteArrayInputStream(text.getBytes());
            int size = text.getBytes().length;
            NanoHTTPD.Response.IStatus status = this.getStatus();
            NanoHTTPD.Response res = NanoHTTPD.newFixedLengthResponse(status, this.getMimeType(), inp, size);
            res.addHeader("Access-Control-Allow-Origin", "*");
            return res;
        }
    }

    public static class StreamUrl
    extends RouterNanoHTTPD.DefaultStreamHandler {
        @Override
        public String getMimeType() {
            return "text/plain";
        }

        @Override
        public NanoHTTPD.Response.IStatus getStatus() {
            return NanoHTTPD.Response.Status.OK;
        }

        @Override
        public InputStream getData() {
            return new ByteArrayInputStream("a stream of data ;-)".getBytes());
        }
    }
}

