/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.core;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.security.auth.callback.CallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x2br.security.signer.KeyStoreLoader;
import x2br.security.signer.KeyStoreLoaderException;
import x2br.security.signer.core.util.MessagesBundle;

public class FileSystemKeyStoreLoader
implements KeyStoreLoader {
    private static final String FILE_TYPE_PKCS12 = "PKCS12";
    private static final String FILE_TYPE_JKS = "JKS";
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();
    private static final Logger logger = LoggerFactory.getLogger(FileSystemKeyStoreLoader.class);
    private File fileKeyStore = null;

    public FileSystemKeyStoreLoader(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.file.invalid"));
        }
        this.setFileKeyStore(file);
    }

    public File getFileKeyStore() {
        return this.fileKeyStore;
    }

    public void setFileKeyStore(File fileKeyStore) {
        this.fileKeyStore = fileKeyStore;
    }

    public KeyStore getKeyStore(String pinNumber) {
        logger.info("FileSystemKeyStoreLoader.getKeyStore()");
        KeyStore result = null;
        try {
            result = this.getKeyStoreWithType(pinNumber, FILE_TYPE_PKCS12);
        }
        catch (Throwable throwable) {
            try {
                result = this.getKeyStoreWithType(pinNumber, FILE_TYPE_JKS);
            }
            catch (Throwable error) {
                throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.keyStore.unknow.format"), throwable);
            }
        }
        return result;
    }

    @Override
    public KeyStore getKeyStore() {
        logger.error("Nao implementado");
        return null;
    }

    private KeyStore getKeyStoreWithType(String pinNumber, String keyStoreType) {
        KeyStore result = null;
        try {
            result = KeyStore.getInstance(keyStoreType);
            char[] pwd = pinNumber == null ? null : pinNumber.toCharArray();
            FileInputStream is = new FileInputStream(this.fileKeyStore);
            result.load(is, pwd);
        }
        catch (Throwable error) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.keystore.from.file"), error);
        }
        return result;
    }

    @Override
    public void setCallbackHandler(CallbackHandler callback) {
    }
}

