/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.core;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import x2br.security.signer.KeyStoreLoader;
import x2br.security.signer.KeyStoreLoaderException;
import x2br.security.signer.core.DriverKeyStoreLoader;
import x2br.security.signer.core.util.MessagesBundle;

public class MSKeyStoreLoader
implements KeyStoreLoader {
    private static final Logger logger = LoggerFactory.getLogger(MSKeyStoreLoader.class);
    protected static final String MS_PROVIDER = "SunMSCAPI";
    protected static final String MS_TYPE = "Windows-MY";
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();
    private CallbackHandler callback;

    @Override
    public KeyStore getKeyStore() {
        try {
            KeyStore result = KeyStore.getInstance(MS_TYPE, MS_PROVIDER);
            result.load(null, null);
            this.fixAliases(result);
            if (!this.verifyKeyEntry(result)) {
                DriverKeyStoreLoader driverKeyStoreLoader = new DriverKeyStoreLoader();
                result = driverKeyStoreLoader.getKeyStore();
            }
            return result;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException ex) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.load.mscapi"), ex);
        }
    }

    @Override
    public void setCallbackHandler(CallbackHandler callback) {
        this.setCallback(callback);
    }

    private boolean verifyKeyEntry(KeyStore ks) {
        boolean isKeyEntry = false;
        String alias = "";
        try {
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                alias = e.nextElement();
                if (!ks.isKeyEntry(alias)) continue;
                isKeyEntry = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isKeyEntry;
    }

    private void fixAliases(KeyStore keyStore) {
        try {
            Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
            field.setAccessible(true);
            KeyStoreSpi keyStoreVeritable = (KeyStoreSpi)field.get(keyStore);
            field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
            field.setAccessible(true);
            if (field.get(keyStoreVeritable) instanceof Map) {
                return;
            }
            if ("sun.security.mscapi.KeyStore$MY".equals(keyStoreVeritable.getClass().getName())) {
                field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
                field.setAccessible(true);
                Collection entries = (Collection)field.get(keyStoreVeritable);
                for (Object entry : entries) {
                    field = entry.getClass().getDeclaredField("certChain");
                    field.setAccessible(true);
                    X509Certificate[] certificates = (X509Certificate[])field.get(entry);
                    String hashCode = Integer.toString(certificates[0].hashCode());
                    field = entry.getClass().getDeclaredField("alias");
                    field.setAccessible(true);
                    String alias = (String)field.get(entry);
                    if (alias.equals(hashCode)) continue;
                    field.set(entry, alias.concat(" - ").concat(hashCode));
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            logger.info(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public CallbackHandler getCallback() {
        return this.callback;
    }

    public void setCallback(CallbackHandler callback) {
        this.callback = callback;
    }
}

