/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.core.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import x2br.security.signer.core.util.CertificateUtilException;
import x2br.security.signer.core.util.MessagesBundle;

public final class ZipBytes {
    private static final Logger LOGGER = Logger.getLogger(ZipBytes.class.getName());
    private static final int BUFFER_SIZE = 4096;
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    public static byte[] compressing(Map<String, byte[]> files) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(out);
        try {
            for (String fileName : files.keySet()) {
                LOGGER.log(Level.INFO, coreMessagesBundle.getString("info.add.file.zip", fileName));
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.write(files.get(fileName));
                zipOut.setLevel(0);
                zipOut.closeEntry();
            }
            zipOut.close();
            out.close();
        }
        catch (IOException e) {
            new CertificateUtilException(e.getMessage(), e);
        }
        return out.toByteArray();
    }

    public static Map<String, byte[]> decompressing(byte[] file) {
        BufferedOutputStream dest = null;
        ZipEntry entry = null;
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        ByteArrayInputStream in = new ByteArrayInputStream(file);
        ZipInputStream zipStream = new ZipInputStream(in);
        try {
            while ((entry = zipStream.getNextEntry()) != null) {
                int count;
                byte[] buf = new byte[4096];
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                dest = new BufferedOutputStream(outputStream, 4096);
                while ((count = zipStream.read(buf, 0, 4096)) != -1) {
                    dest.write(buf, 0, count);
                }
                dest.flush();
                dest.close();
                files.put(entry.getName(), outputStream.toByteArray());
                zipStream.closeEntry();
            }
        }
        catch (IOException e) {
            new CertificateUtilException(e.getMessage(), e);
        }
        return files;
    }
}

