/*
 * Decompiled with CFR 0.152.
 */
package x2br.security.signer.pkcs11;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.OptionalLong;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class ConfigFactory {
    private final String libraryPath;

    public ConfigFactory(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    public Optional<InputStream> createConfig() throws IOException, PKCS11Exception {
        OptionalLong slot = this.getSlot();
        if (!slot.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.createConfig(slot.getAsLong()));
    }

    private InputStream createConfig(long slot) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("name = Pkcs11Accelerator\r\nlibrary = ");
        buffer.append(this.libraryPath);
        buffer.append("\r\nslot = ");
        buffer.append(slot);
        buffer.append("\r\n");
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }

    private OptionalLong getSlot() throws IOException, PKCS11Exception {
        PKCS11 pkcs11 = PKCS11.getInstance(this.libraryPath, "C_GetFunctionList", null, false);
        long[] slots = pkcs11.C_GetSlotList(true);
        if (slots.length > 0) {
            return OptionalLong.of(slots[0]);
        }
        return OptionalLong.empty();
    }
}

