/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexWriterV1;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.internal.storage.pack.BaseSearch;
import org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.eclipse.jgit.internal.storage.pack.DeltaCache;
import org.eclipse.jgit.internal.storage.pack.DeltaIndex;
import org.eclipse.jgit.internal.storage.pack.DeltaTask;
import org.eclipse.jgit.internal.storage.pack.DeltaWindow;
import org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.internal.storage.pack.PackWriterBitmapPreparer;
import org.eclipse.jgit.internal.storage.pack.PackWriterBitmapWalker;
import org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.internal.storage.pack.ThreadSafeDeltaCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.AsyncObjectSizeQueue;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.BitmapObject;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.ThreadSafeProgressMonitor;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.transport.ObjectCountCallback;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.TemporaryBuffer;

public class PackWriter
implements AutoCloseable {
    private static final int PACK_VERSION_GENERATED = 2;
    private static final Map<WeakReference<PackWriter>, Boolean> instances = new ConcurrentHashMap<WeakReference<PackWriter>, Boolean>();
    private static final Iterable<PackWriter> instancesIterable = new Iterable<PackWriter>(){

        @Override
        public Iterator<PackWriter> iterator() {
            return new Iterator<PackWriter>(){
                private final Iterator<WeakReference<PackWriter>> it = PackWriter.access$000().keySet().iterator();
                private PackWriter next;

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    while (this.it.hasNext()) {
                        WeakReference<PackWriter> ref = this.it.next();
                        this.next = (PackWriter)ref.get();
                        if (this.next != null) {
                            return true;
                        }
                        this.it.remove();
                    }
                    return false;
                }

                @Override
                public PackWriter next() {
                    if (this.hasNext()) {
                        PackWriter result = this.next;
                        this.next = null;
                        return result;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };
    private BlockList<ObjectToPack>[] objectsLists = new BlockList[5];
    private ObjectIdOwnerMap<ObjectToPack> objectsMap;
    private List<ObjectToPack> edgeObjects;
    private BitmapIndex.BitmapBuilder haveObjects;
    private List<CachedPack> cachedPacks;
    private Set<ObjectId> tagTargets;
    private ObjectIdSet[] excludeInPacks;
    private ObjectIdSet excludeInPackLast;
    private Deflater myDeflater;
    private final ObjectReader reader;
    private final ObjectReuseAsIs reuseSupport;
    private final PackConfig config;
    private final PackStatistics.Accumulator stats;
    private final MutableState state;
    private final WeakReference<PackWriter> selfRef;
    private PackStatistics.ObjectType.Accumulator typeStats;
    private List<ObjectToPack> sortedByName;
    private byte[] packcsum;
    private boolean deltaBaseAsOffset;
    private boolean reuseDeltas;
    private boolean reuseDeltaCommits;
    private boolean reuseValidate;
    private boolean thin;
    private boolean useCachedPacks;
    private boolean useBitmaps;
    private boolean ignoreMissingUninteresting;
    private boolean pruneCurrentObjectList;
    private boolean shallowPack;
    private boolean canBuildBitmaps;
    private boolean indexDisabled;
    private int depth;
    private Collection<? extends ObjectId> unshallowObjects;
    private PackBitmapIndexBuilder writeBitmaps;
    private CRC32 crc32;
    private ObjectCountCallback callback;

    public static Iterable<PackWriter> getInstances() {
        return instancesIterable;
    }

    public PackWriter(Repository repo) {
        this(repo, repo.newObjectReader());
    }

    public PackWriter(ObjectReader reader) {
        this(new PackConfig(), reader);
    }

    public PackWriter(Repository repo, ObjectReader reader) {
        this(new PackConfig(repo), reader);
    }

    public PackWriter(PackConfig config, ObjectReader reader) {
        this.objectsLists[1] = new BlockList();
        this.objectsLists[2] = new BlockList();
        this.objectsLists[3] = new BlockList();
        this.objectsLists[4] = new BlockList();
        this.objectsMap = new ObjectIdOwnerMap();
        this.edgeObjects = new BlockList<ObjectToPack>();
        this.cachedPacks = new ArrayList<CachedPack>(2);
        this.tagTargets = Collections.emptySet();
        this.ignoreMissingUninteresting = true;
        this.config = config;
        this.reader = reader;
        this.reuseSupport = reader instanceof ObjectReuseAsIs ? (ObjectReuseAsIs)((Object)reader) : null;
        this.deltaBaseAsOffset = config.isDeltaBaseAsOffset();
        this.reuseDeltas = config.isReuseDeltas();
        this.reuseValidate = true;
        this.stats = new PackStatistics.Accumulator();
        this.state = new MutableState();
        this.selfRef = new WeakReference<PackWriter>(this);
        instances.put(this.selfRef, Boolean.TRUE);
    }

    public PackWriter setObjectCountCallback(ObjectCountCallback callback) {
        this.callback = callback;
        return this;
    }

    public void setClientShallowCommits(Set<ObjectId> clientShallowCommits) {
        this.stats.clientShallowCommits = Collections.unmodifiableSet(new HashSet<ObjectId>(clientShallowCommits));
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void setDeltaBaseAsOffset(boolean deltaBaseAsOffset) {
        this.deltaBaseAsOffset = deltaBaseAsOffset;
    }

    public boolean isReuseDeltaCommits() {
        return this.reuseDeltaCommits;
    }

    public void setReuseDeltaCommits(boolean reuse) {
        this.reuseDeltaCommits = reuse;
    }

    public boolean isReuseValidatingObjects() {
        return this.reuseValidate;
    }

    public void setReuseValidatingObjects(boolean validate) {
        this.reuseValidate = validate;
    }

    public boolean isThin() {
        return this.thin;
    }

    public void setThin(boolean packthin) {
        this.thin = packthin;
    }

    public boolean isUseCachedPacks() {
        return this.useCachedPacks;
    }

    public void setUseCachedPacks(boolean useCached) {
        this.useCachedPacks = useCached;
    }

    public boolean isUseBitmaps() {
        return this.useBitmaps;
    }

    public void setUseBitmaps(boolean useBitmaps) {
        this.useBitmaps = useBitmaps;
    }

    public boolean isIndexDisabled() {
        return this.indexDisabled || !this.cachedPacks.isEmpty();
    }

    public void setIndexDisabled(boolean noIndex) {
        this.indexDisabled = noIndex;
    }

    public boolean isIgnoreMissingUninteresting() {
        return this.ignoreMissingUninteresting;
    }

    public void setIgnoreMissingUninteresting(boolean ignore) {
        this.ignoreMissingUninteresting = ignore;
    }

    public void setTagTargets(Set<ObjectId> objects) {
        this.tagTargets = objects;
    }

    public void setShallowPack(int depth, Collection<? extends ObjectId> unshallow) {
        this.shallowPack = true;
        this.depth = depth;
        this.unshallowObjects = unshallow;
    }

    public long getObjectCount() throws IOException {
        if (this.stats.totalObjects == 0L) {
            long objCnt = 0L;
            objCnt += (long)this.objectsLists[1].size();
            objCnt += (long)this.objectsLists[2].size();
            objCnt += (long)this.objectsLists[3].size();
            objCnt += (long)this.objectsLists[4].size();
            for (CachedPack pack : this.cachedPacks) {
                objCnt += pack.getObjectCount();
            }
            return objCnt;
        }
        return this.stats.totalObjects;
    }

    public ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> getObjectSet() throws IOException {
        if (!this.cachedPacks.isEmpty()) {
            throw new IOException(JGitText.get().cachedPacksPreventsListingObjects);
        }
        if (this.writeBitmaps != null) {
            return this.writeBitmaps.getObjectSet();
        }
        ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> r = new ObjectIdOwnerMap<ObjectIdOwnerMap.Entry>();
        for (BlockList<ObjectToPack> objList : this.objectsLists) {
            if (objList == null) continue;
            for (ObjectToPack otp : objList) {
                r.add(new ObjectIdOwnerMap.Entry(otp){});
            }
        }
        return r;
    }

    public void excludeObjects(ObjectIdSet idx) {
        if (this.excludeInPacks == null) {
            this.excludeInPacks = new ObjectIdSet[]{idx};
            this.excludeInPackLast = idx;
        } else {
            int cnt = this.excludeInPacks.length;
            ObjectIdSet[] newList = new ObjectIdSet[cnt + 1];
            System.arraycopy(this.excludeInPacks, 0, newList, 0, cnt);
            newList[cnt] = idx;
            this.excludeInPacks = newList;
        }
    }

    public void preparePack(Iterator<RevObject> objectsSource) throws IOException {
        while (objectsSource.hasNext()) {
            this.addObject(objectsSource.next());
        }
    }

    public void preparePack(ProgressMonitor countingMonitor, Set<? extends ObjectId> want, Set<? extends ObjectId> have) throws IOException {
        ObjectWalk ow = this.shallowPack ? new DepthWalk.ObjectWalk(this.reader, this.depth) : new ObjectWalk(this.reader);
        this.preparePack(countingMonitor, ow, want, have);
    }

    public void preparePack(ProgressMonitor countingMonitor, ObjectWalk walk, Set<? extends ObjectId> interestingObjects, Set<? extends ObjectId> uninterestingObjects) throws IOException {
        if (countingMonitor == null) {
            countingMonitor = NullProgressMonitor.INSTANCE;
        }
        if (this.shallowPack && !(walk instanceof DepthWalk.ObjectWalk)) {
            walk = new DepthWalk.ObjectWalk(this.reader, this.depth);
        }
        this.findObjectsToPack(countingMonitor, walk, interestingObjects, uninterestingObjects);
    }

    public boolean willInclude(AnyObjectId id) throws IOException {
        ObjectToPack obj = this.objectsMap.get(id);
        return obj != null && !obj.isEdge();
    }

    public ObjectToPack get(AnyObjectId id) {
        ObjectToPack obj = this.objectsMap.get(id);
        return obj != null && !obj.isEdge() ? obj : null;
    }

    public ObjectId computeName() {
        byte[] buf = new byte[20];
        MessageDigest md = Constants.newMessageDigest();
        for (ObjectToPack otp : this.sortByName()) {
            otp.copyRawTo(buf, 0);
            md.update(buf, 0, 20);
        }
        return ObjectId.fromRaw(md.digest());
    }

    public int getIndexVersion() {
        int indexVersion = this.config.getIndexVersion();
        if (indexVersion <= 0) {
            for (BlockList<ObjectToPack> objs : this.objectsLists) {
                indexVersion = Math.max(indexVersion, PackIndexWriter.oldestPossibleFormat(objs));
            }
        }
        return indexVersion;
    }

    public void writeIndex(OutputStream indexStream) throws IOException {
        if (this.isIndexDisabled()) {
            throw new IOException(JGitText.get().cachedPacksPreventsIndexCreation);
        }
        long writeStart = System.currentTimeMillis();
        PackIndexWriter iw = PackIndexWriter.createVersion(indexStream, this.getIndexVersion());
        iw.write(this.sortByName(), this.packcsum);
        this.stats.timeWriting += System.currentTimeMillis() - writeStart;
    }

    public void writeBitmapIndex(OutputStream bitmapIndexStream) throws IOException {
        if (this.writeBitmaps == null) {
            throw new IOException(JGitText.get().bitmapsMustBePrepared);
        }
        long writeStart = System.currentTimeMillis();
        PackBitmapIndexWriterV1 iw = new PackBitmapIndexWriterV1(bitmapIndexStream);
        iw.write(this.writeBitmaps, this.packcsum);
        this.stats.timeWriting += System.currentTimeMillis() - writeStart;
    }

    private List<ObjectToPack> sortByName() {
        if (this.sortedByName == null) {
            int cnt = 0;
            cnt += this.objectsLists[1].size();
            cnt += this.objectsLists[2].size();
            cnt += this.objectsLists[3].size();
            this.sortedByName = new BlockList<ObjectToPack>(cnt += this.objectsLists[4].size());
            this.sortedByName.addAll(this.objectsLists[1]);
            this.sortedByName.addAll(this.objectsLists[2]);
            this.sortedByName.addAll(this.objectsLists[3]);
            this.sortedByName.addAll(this.objectsLists[4]);
            Collections.sort(this.sortedByName);
        }
        return this.sortedByName;
    }

    private void beginPhase(PackingPhase phase, ProgressMonitor monitor, long cnt) {
        String task;
        this.state.phase = phase;
        switch (phase) {
            case COUNTING: {
                task = JGitText.get().countingObjects;
                break;
            }
            case GETTING_SIZES: {
                task = JGitText.get().searchForSizes;
                break;
            }
            case FINDING_SOURCES: {
                task = JGitText.get().searchForReuse;
                break;
            }
            case COMPRESSING: {
                task = JGitText.get().compressingObjects;
                break;
            }
            case WRITING: {
                task = JGitText.get().writingObjects;
                break;
            }
            case BUILDING_BITMAPS: {
                task = JGitText.get().buildingBitmaps;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalPackingPhase, new Object[]{phase}));
            }
        }
        monitor.beginTask(task, (int)cnt);
    }

    private void endPhase(ProgressMonitor monitor) {
        monitor.endTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePack(ProgressMonitor compressMonitor, ProgressMonitor writeMonitor, OutputStream packStream) throws IOException {
        long objCnt;
        boolean needSearchForReuse;
        if (compressMonitor == null) {
            compressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (writeMonitor == null) {
            writeMonitor = NullProgressMonitor.INSTANCE;
        }
        this.excludeInPacks = null;
        this.excludeInPackLast = null;
        boolean bl = needSearchForReuse = this.reuseSupport != null && (this.reuseDeltas || this.config.isReuseObjects() || !this.cachedPacks.isEmpty());
        if (compressMonitor instanceof BatchingProgressMonitor) {
            long delay = 1000L;
            if (needSearchForReuse && this.config.isDeltaCompress()) {
                delay = 500L;
            }
            ((BatchingProgressMonitor)compressMonitor).setDelayStart(delay, TimeUnit.MILLISECONDS);
        }
        if (needSearchForReuse) {
            this.searchForReuse(compressMonitor);
        }
        if (this.config.isDeltaCompress()) {
            this.searchForDeltas(compressMonitor);
        }
        this.crc32 = new CRC32();
        PackOutputStream out = new PackOutputStream(writeMonitor, this.isIndexDisabled() ? packStream : new CheckedOutputStream(packStream, this.crc32), this);
        this.stats.totalObjects = objCnt = this.getObjectCount();
        if (this.callback != null) {
            this.callback.setObjectCount(objCnt);
        }
        this.beginPhase(PackingPhase.WRITING, writeMonitor, objCnt);
        long writeStart = System.currentTimeMillis();
        try {
            out.writeFileHeader(2, objCnt);
            out.flush();
            this.writeObjects(out);
            if (!this.edgeObjects.isEmpty() || !this.cachedPacks.isEmpty()) {
                for (PackStatistics.ObjectType.Accumulator typeStat : this.stats.objectTypes) {
                    if (typeStat == null) continue;
                    this.stats.thinPackBytes += typeStat.bytes;
                }
            }
            this.stats.reusedPacks = Collections.unmodifiableList(this.cachedPacks);
            for (CachedPack pack : this.cachedPacks) {
                long deltaCnt = pack.getDeltaCount();
                this.stats.reusedObjects += pack.getObjectCount();
                this.stats.reusedDeltas += deltaCnt;
                this.stats.totalDeltas += deltaCnt;
                this.reuseSupport.copyPackAsIs(out, pack);
            }
            this.writeChecksum(out);
            out.flush();
        }
        catch (Throwable throwable) {
            this.stats.timeWriting = System.currentTimeMillis() - writeStart;
            this.stats.depth = this.depth;
            for (PackStatistics.ObjectType.Accumulator typeStat : this.stats.objectTypes) {
                if (typeStat == null) continue;
                typeStat.cntDeltas += typeStat.reusedDeltas;
                this.stats.reusedObjects += typeStat.reusedObjects;
                this.stats.reusedDeltas += typeStat.reusedDeltas;
                this.stats.totalDeltas += typeStat.cntDeltas;
            }
            throw throwable;
        }
        this.stats.timeWriting = System.currentTimeMillis() - writeStart;
        this.stats.depth = this.depth;
        for (PackStatistics.ObjectType.Accumulator typeStat : this.stats.objectTypes) {
            if (typeStat == null) continue;
            typeStat.cntDeltas += typeStat.reusedDeltas;
            this.stats.reusedObjects += typeStat.reusedObjects;
            this.stats.reusedDeltas += typeStat.reusedDeltas;
            this.stats.totalDeltas += typeStat.cntDeltas;
        }
        this.stats.totalBytes = out.length();
        this.reader.close();
        this.endPhase(writeMonitor);
    }

    public PackStatistics getStatistics() {
        return new PackStatistics(this.stats);
    }

    public State getState() {
        return this.state.snapshot();
    }

    @Override
    public void close() {
        this.reader.close();
        if (this.myDeflater != null) {
            this.myDeflater.end();
            this.myDeflater = null;
        }
        instances.remove(this.selfRef);
    }

    private void searchForReuse(ProgressMonitor monitor) throws IOException {
        long cnt = 0L;
        cnt += (long)this.objectsLists[1].size();
        cnt += (long)this.objectsLists[2].size();
        cnt += (long)this.objectsLists[3].size();
        long start = System.currentTimeMillis();
        this.beginPhase(PackingPhase.FINDING_SOURCES, monitor, cnt += (long)this.objectsLists[4].size());
        if (cnt <= 4096L) {
            BlockList<ObjectToPack> tmp = new BlockList<ObjectToPack>((int)cnt);
            tmp.addAll(this.objectsLists[4]);
            tmp.addAll(this.objectsLists[1]);
            tmp.addAll(this.objectsLists[2]);
            tmp.addAll(this.objectsLists[3]);
            this.searchForReuse(monitor, tmp);
            if (this.pruneCurrentObjectList) {
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[1]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[2]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[3]);
                PackWriter.pruneEdgesFromObjectList(this.objectsLists[4]);
            }
        } else {
            this.searchForReuse(monitor, this.objectsLists[4]);
            this.searchForReuse(monitor, this.objectsLists[1]);
            this.searchForReuse(monitor, this.objectsLists[2]);
            this.searchForReuse(monitor, this.objectsLists[3]);
        }
        this.endPhase(monitor);
        this.stats.timeSearchingForReuse = System.currentTimeMillis() - start;
        if (this.config.isReuseDeltas() && this.config.getCutDeltaChains()) {
            this.cutDeltaChains(this.objectsLists[2]);
            this.cutDeltaChains(this.objectsLists[3]);
        }
    }

    private void searchForReuse(ProgressMonitor monitor, List<ObjectToPack> list) throws IOException, MissingObjectException {
        this.pruneCurrentObjectList = false;
        this.reuseSupport.selectObjectRepresentation(this, monitor, list);
        if (this.pruneCurrentObjectList) {
            PackWriter.pruneEdgesFromObjectList(list);
        }
    }

    private void cutDeltaChains(BlockList<ObjectToPack> list) throws IOException {
        int max = this.config.getMaxDeltaDepth();
        block0: for (int idx = list.size() - 1; idx >= 0; --idx) {
            int d = 0;
            for (ObjectToPack b = list.get(idx).getDeltaBase(); b != null && d >= b.getChainLength(); b = b.getDeltaBase()) {
                b.setChainLength(++d);
                if (d < max || !b.isDeltaRepresentation()) continue;
                this.reselectNonDelta(b);
                continue block0;
            }
        }
        if (this.config.isDeltaCompress()) {
            for (ObjectToPack otp : list) {
                otp.clearChainLength();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchForDeltas(ProgressMonitor monitor) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectToPack[] list = new ObjectToPack[this.objectsLists[2].size() + this.objectsLists[3].size() + this.edgeObjects.size()];
        int cnt = 0;
        cnt = this.findObjectsNeedingDelta(list, cnt, 2);
        if ((cnt = this.findObjectsNeedingDelta(list, cnt, 3)) == 0) {
            return;
        }
        int nonEdgeCnt = cnt;
        for (ObjectToPack eo : this.edgeObjects) {
            eo.setWeight(0);
            list[cnt++] = eo;
        }
        long sizingStart = System.currentTimeMillis();
        this.beginPhase(PackingPhase.GETTING_SIZES, monitor, cnt);
        AsyncObjectSizeQueue<ObjectToPack> sizeQueue = this.reader.getObjectSize(Arrays.asList(list).subList(0, cnt), false);
        try {
            long limit = Math.min(this.config.getBigFileThreshold(), Integer.MAX_VALUE);
            while (true) {
                long sz;
                block18: {
                    try {
                        if (sizeQueue.next()) break block18;
                        break;
                    }
                    catch (MissingObjectException notFound) {
                        monitor.update(1);
                        if (this.ignoreMissingUninteresting) {
                            ObjectToPack otp = sizeQueue.getCurrent();
                            if (otp != null && otp.isEdge()) {
                                otp.setDoNotDelta();
                                continue;
                            }
                            otp = this.objectsMap.get(notFound.getObjectId());
                            if (otp != null && otp.isEdge()) {
                                otp.setDoNotDelta();
                                continue;
                            }
                        }
                        throw notFound;
                    }
                }
                ObjectToPack otp = sizeQueue.getCurrent();
                if (otp == null) {
                    otp = this.objectsMap.get(sizeQueue.getObjectId());
                }
                if (16L < (sz = sizeQueue.getSize()) && sz < limit) {
                    otp.setWeight((int)sz);
                } else {
                    otp.setDoNotDelta();
                }
                monitor.update(1);
            }
        }
        finally {
            sizeQueue.release();
        }
        this.endPhase(monitor);
        this.stats.timeSearchingForSizes = System.currentTimeMillis() - sizingStart;
        Arrays.sort(list, 0, cnt, new Comparator<ObjectToPack>(){

            @Override
            public int compare(ObjectToPack a, ObjectToPack b) {
                int cmp = (a.isDoNotDelta() ? 1 : 0) - (b.isDoNotDelta() ? 1 : 0);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = a.getType() - b.getType();
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.getPathHash() >>> 1) - (b.getPathHash() >>> 1);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.getPathHash() & 1) - (b.getPathHash() & 1);
                if (cmp != 0) {
                    return cmp;
                }
                cmp = (a.isEdge() ? 0 : 1) - (b.isEdge() ? 0 : 1);
                if (cmp != 0) {
                    return cmp;
                }
                return b.getWeight() - a.getWeight();
            }
        });
        while (0 < cnt && list[cnt - 1].isDoNotDelta()) {
            if (!list[cnt - 1].isEdge()) {
                --nonEdgeCnt;
            }
            --cnt;
        }
        if (cnt == 0) {
            return;
        }
        long searchStart = System.currentTimeMillis();
        this.searchForDeltas(monitor, list, cnt);
        this.stats.deltaSearchNonEdgeObjects = nonEdgeCnt;
        this.stats.timeCompressing = System.currentTimeMillis() - searchStart;
        for (int i = 0; i < cnt; ++i) {
            if (list[i].isEdge() || !list[i].isDeltaRepresentation()) continue;
            ++this.stats.deltasFound;
        }
    }

    private int findObjectsNeedingDelta(ObjectToPack[] list, int cnt, int type) {
        for (ObjectToPack otp : this.objectsLists[type]) {
            if (otp.isDoNotDelta() || otp.isDeltaRepresentation()) continue;
            otp.setWeight(0);
            list[cnt++] = otp;
        }
        return cnt;
    }

    private void reselectNonDelta(ObjectToPack otp) throws IOException {
        otp.clearDeltaBase();
        otp.clearReuseAsIs();
        boolean old = this.reuseDeltas;
        this.reuseDeltas = false;
        this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(otp));
        this.reuseDeltas = old;
    }

    private void searchForDeltas(ProgressMonitor monitor, ObjectToPack[] list, int cnt) throws MissingObjectException, IncorrectObjectTypeException, LargeObjectException, IOException {
        int threads = this.config.getThreads();
        if (threads == 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        if (threads <= 1 || cnt <= this.config.getDeltaSearchWindowSize()) {
            this.singleThreadDeltaSearch(monitor, list, cnt);
        } else {
            this.parallelDeltaSearch(monitor, list, cnt, threads);
        }
    }

    private void singleThreadDeltaSearch(ProgressMonitor monitor, ObjectToPack[] list, int cnt) throws IOException {
        long totalWeight = 0L;
        for (int i = 0; i < cnt; ++i) {
            ObjectToPack o = list[i];
            if (o.isEdge() || o.doNotAttemptDelta()) continue;
            totalWeight += (long)o.getWeight();
        }
        long bytesPerUnit = 1L;
        while (0x900000L <= totalWeight / bytesPerUnit) {
            bytesPerUnit <<= 10;
        }
        int cost = (int)(totalWeight / bytesPerUnit);
        if (totalWeight % bytesPerUnit != 0L) {
            ++cost;
        }
        this.beginPhase(PackingPhase.COMPRESSING, monitor, cost);
        new DeltaWindow(this.config, new DeltaCache(this.config), this.reader, monitor, bytesPerUnit, list, 0, cnt).search();
        this.endPhase(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parallelDeltaSearch(ProgressMonitor monitor, ObjectToPack[] list, int cnt, int threads) throws IOException {
        List<Throwable> errors;
        block18: {
            ThreadSafeDeltaCache dc = new ThreadSafeDeltaCache(this.config);
            ThreadSafeProgressMonitor pm = new ThreadSafeProgressMonitor(monitor);
            DeltaTask.Block taskBlock = new DeltaTask.Block(threads, this.config, this.reader, dc, pm, list, 0, cnt);
            taskBlock.partitionTasks();
            this.beginPhase(PackingPhase.COMPRESSING, monitor, taskBlock.cost());
            pm.startWorkers(taskBlock.tasks.size());
            Executor executor = this.config.getExecutor();
            errors = Collections.synchronizedList(new ArrayList(threads));
            if (executor instanceof ExecutorService) {
                PackWriter.runTasks((ExecutorService)executor, pm, taskBlock, errors);
            } else {
                if (executor == null) {
                    ExecutorService pool = Executors.newFixedThreadPool(threads);
                    try {
                        PackWriter.runTasks(pool, pm, taskBlock, errors);
                    }
                    finally {
                        pool.shutdown();
                        try {
                            while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                            }
                            break block18;
                        }
                        catch (InterruptedException e) {
                            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                        }
                    }
                }
                for (final DeltaTask task : taskBlock.tasks) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                task.call();
                            }
                            catch (Throwable failure) {
                                errors.add(failure);
                            }
                        }
                    });
                }
                try {
                    pm.waitForCompletion();
                }
                catch (InterruptedException ie) {
                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                }
            }
        }
        if (!errors.isEmpty()) {
            Throwable err = errors.get(0);
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof IOException) {
                throw (IOException)err;
            }
            IOException fail = new IOException(err.getMessage());
            fail.initCause(err);
            throw fail;
        }
        this.endPhase(monitor);
    }

    private static void runTasks(ExecutorService pool, ThreadSafeProgressMonitor pm, DeltaTask.Block tb, List<Throwable> errors) throws IOException {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(tb.tasks.size());
        for (DeltaTask deltaTask : tb.tasks) {
            futures.add(pool.submit(deltaTask));
        }
        try {
            pm.waitForCompletion();
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {
                    errors.add(executionException.getCause());
                }
            }
        }
        catch (InterruptedException ie) {
            for (Future future : futures) {
                future.cancel(true);
            }
            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
        }
    }

    private void writeObjects(PackOutputStream out) throws IOException {
        this.writeObjects(out, this.objectsLists[1]);
        this.writeObjects(out, this.objectsLists[4]);
        this.writeObjects(out, this.objectsLists[2]);
        this.writeObjects(out, this.objectsLists[3]);
    }

    private void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        this.typeStats = this.stats.objectTypes[list.get(0).getType()];
        long beginOffset = out.length();
        if (this.reuseSupport != null) {
            this.reuseSupport.writeObjects(out, list);
        } else {
            for (ObjectToPack otp : list) {
                out.writeObject(otp);
            }
        }
        this.typeStats.bytes += out.length() - beginOffset;
        this.typeStats.cntObjects = list.size();
    }

    void writeObject(PackOutputStream out, ObjectToPack otp) throws IOException {
        if (!otp.isWritten()) {
            this.writeObjectImpl(out, otp);
        }
    }

    private void writeObjectImpl(PackOutputStream out, ObjectToPack otp) throws IOException {
        if (otp.wantWrite()) {
            this.reselectNonDelta(otp);
        }
        otp.markWantWrite();
        while (otp.isReuseAsIs()) {
            this.writeBase(out, otp.getDeltaBase());
            if (otp.isWritten()) {
                return;
            }
            this.crc32.reset();
            otp.setOffset(out.length());
            try {
                this.reuseSupport.copyObjectAsIs(out, otp, this.reuseValidate);
                out.endObject();
                otp.setCRC((int)this.crc32.getValue());
                ++this.typeStats.reusedObjects;
                if (otp.isDeltaRepresentation()) {
                    ++this.typeStats.reusedDeltas;
                    this.typeStats.deltaBytes += out.length() - otp.getOffset();
                }
                return;
            }
            catch (StoredObjectRepresentationNotAvailableException gone) {
                if (otp.getOffset() == out.length()) {
                    otp.setOffset(0L);
                    otp.clearDeltaBase();
                    otp.clearReuseAsIs();
                    this.reuseSupport.selectObjectRepresentation(this, NullProgressMonitor.INSTANCE, Collections.singleton(otp));
                    continue;
                }
                CorruptObjectException coe = new CorruptObjectException(otp, "");
                coe.initCause(gone);
                throw coe;
            }
        }
        if (otp.isDeltaRepresentation()) {
            this.writeDeltaObjectDeflate(out, otp);
        } else {
            this.writeWholeObjectDeflate(out, otp);
        }
        out.endObject();
        otp.setCRC((int)this.crc32.getValue());
    }

    private void writeBase(PackOutputStream out, ObjectToPack base) throws IOException {
        if (base != null && !base.isWritten() && !base.isEdge()) {
            this.writeObjectImpl(out, base);
        }
    }

    private void writeWholeObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        Deflater deflater = this.deflater();
        ObjectLoader ldr = this.reader.open(otp, otp.getType());
        this.crc32.reset();
        otp.setOffset(out.length());
        out.writeHeader(otp, ldr.getSize());
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        ldr.copyTo(dst);
        dst.finish();
    }

    private void writeDeltaObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        byte[] zbuf;
        this.writeBase(out, otp.getDeltaBase());
        this.crc32.reset();
        otp.setOffset(out.length());
        DeltaCache.Ref ref = otp.popCachedDelta();
        if (ref != null && (zbuf = (byte[])ref.get()) != null) {
            out.writeHeader(otp, otp.getCachedSize());
            out.write(zbuf);
            return;
        }
        TemporaryBuffer.Heap delta = this.delta(otp);
        out.writeHeader(otp, delta.length());
        Deflater deflater = this.deflater();
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        delta.writeTo(dst, null);
        dst.finish();
        ++this.typeStats.cntDeltas;
        this.typeStats.deltaBytes += out.length() - otp.getOffset();
    }

    private TemporaryBuffer.Heap delta(ObjectToPack otp) throws IOException {
        DeltaIndex index = new DeltaIndex(this.buffer(otp.getDeltaBaseId()));
        byte[] res = this.buffer(otp);
        TemporaryBuffer.Heap delta = new TemporaryBuffer.Heap(res.length);
        index.encode(delta, res);
        return delta;
    }

    private byte[] buffer(AnyObjectId objId) throws IOException {
        return PackWriter.buffer(this.config, this.reader, objId);
    }

    static byte[] buffer(PackConfig config, ObjectReader or, AnyObjectId objId) throws IOException {
        return or.open(objId).getCachedBytes(config.getBigFileThreshold());
    }

    private Deflater deflater() {
        if (this.myDeflater == null) {
            this.myDeflater = new Deflater(this.config.getCompressionLevel());
        }
        return this.myDeflater;
    }

    private void writeChecksum(PackOutputStream out) throws IOException {
        this.packcsum = out.getDigest();
        out.write(this.packcsum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findObjectsToPack(ProgressMonitor countingMonitor, ObjectWalk walker, Set<? extends ObjectId> want, Set<? extends ObjectId> have) throws MissingObjectException, IOException, IncorrectObjectTypeException {
        RevCommit c;
        AsyncRevObjectQueue q;
        ArrayList<RevTag> wantTags;
        ArrayList<RevObject> haveObjs;
        ArrayList<RevObject> wantObjs;
        RevFlag added;
        RevFlag include;
        ArrayList<? extends ObjectId> all;
        long countingStart;
        block42: {
            BitmapIndex bitmapIndex;
            countingStart = System.currentTimeMillis();
            this.beginPhase(PackingPhase.COUNTING, countingMonitor, 0L);
            if (have == null) {
                have = Collections.emptySet();
            }
            this.stats.interestingObjects = Collections.unmodifiableSet(new HashSet<ObjectId>(want));
            this.stats.uninterestingObjects = Collections.unmodifiableSet(new HashSet<ObjectId>(have));
            boolean bl = this.canBuildBitmaps = this.config.isBuildBitmaps() && !this.shallowPack && have.isEmpty() && (this.excludeInPacks == null || this.excludeInPacks.length == 0);
            if (!this.shallowPack && this.useBitmaps && (bitmapIndex = this.reader.getBitmapIndex()) != null) {
                PackWriterBitmapWalker bitmapWalker = new PackWriterBitmapWalker(walker, bitmapIndex, countingMonitor);
                this.findObjectsToPackUsingBitmaps(bitmapWalker, want, have);
                this.endPhase(countingMonitor);
                this.stats.timeCounting = System.currentTimeMillis() - countingStart;
                this.stats.bitmapIndexMisses = bitmapWalker.getCountOfBitmapIndexMisses();
                return;
            }
            all = new ArrayList<ObjectId>(want.size() + have.size());
            all.addAll(want);
            all.addAll(have);
            include = walker.newFlag("include");
            added = walker.newFlag("added");
            walker.carry(include);
            int haveEst = have.size();
            if (have.isEmpty()) {
                walker.sort(RevSort.COMMIT_TIME_DESC);
            } else {
                walker.sort(RevSort.TOPO);
                if (this.thin) {
                    walker.sort(RevSort.BOUNDARY, true);
                }
            }
            wantObjs = new ArrayList<RevObject>(want.size());
            haveObjs = new ArrayList<RevObject>(haveEst);
            wantTags = new ArrayList<RevTag>(want.size());
            q = walker.parseAny(all, true);
            try {
                while (true) {
                    try {
                        while (true) {
                            RevObject o;
                            if ((o = q.next()) == null) {
                                break block42;
                            }
                            if (have.contains(o)) {
                                haveObjs.add(o);
                            }
                            if (!want.contains(o)) continue;
                            o.add(include);
                            wantObjs.add(o);
                            if (!(o instanceof RevTag)) continue;
                            wantTags.add((RevTag)o);
                        }
                    }
                    catch (MissingObjectException e) {
                        if (this.ignoreMissingUninteresting && have.contains(e.getObjectId())) continue;
                        throw e;
                    }
                    break;
                }
            }
            finally {
                q.release();
            }
        }
        if (!wantTags.isEmpty()) {
            all = new ArrayList(wantTags.size());
            for (RevTag tag : wantTags) {
                all.add(tag.getObject());
            }
            q = walker.parseAny(all, true);
            try {
                while (q.next() != null) {
                }
            }
            finally {
                q.release();
            }
        }
        if (walker instanceof DepthWalk.ObjectWalk) {
            DepthWalk.ObjectWalk depthWalk = (DepthWalk.ObjectWalk)walker;
            for (RevObject revObject : wantObjs) {
                depthWalk.markRoot(revObject);
            }
            if (this.unshallowObjects != null) {
                for (ObjectId objectId : this.unshallowObjects) {
                    depthWalk.markUnshallow(walker.parseAny(objectId));
                }
            }
        } else {
            for (RevObject obj : wantObjs) {
                walker.markStart(obj);
            }
        }
        for (RevObject obj : haveObjs) {
            walker.markUninteresting(obj);
        }
        int maxBases = this.config.getDeltaSearchWindowSize();
        HashSet<RevTree> baseTrees = new HashSet<RevTree>();
        BlockList<RevCommit> blockList = new BlockList<RevCommit>();
        HashSet<ObjectId> roots = new HashSet<ObjectId>();
        while ((c = walker.next()) != null) {
            if (this.exclude(c)) continue;
            if (c.has(RevFlag.UNINTERESTING)) {
                if (baseTrees.size() > maxBases) continue;
                baseTrees.add(c.getTree());
                continue;
            }
            blockList.add(c);
            if (c.getParentCount() == 0) {
                roots.add(c.copy());
            }
            countingMonitor.update(1);
        }
        this.stats.rootCommits = Collections.unmodifiableSet(roots);
        if (this.shallowPack) {
            for (RevCommit cmit : blockList) {
                this.addObject(cmit, 0);
            }
        } else {
            int commitCnt = 0;
            boolean putTagTargets = false;
            for (RevCommit cmit : blockList) {
                if (!cmit.has(added)) {
                    cmit.add(added);
                    this.addObject(cmit, 0);
                    ++commitCnt;
                }
                for (int i = 0; i < cmit.getParentCount(); ++i) {
                    RevCommit p = cmit.getParent(i);
                    if (p.has(added) || p.has(RevFlag.UNINTERESTING) || this.exclude(p)) continue;
                    p.add(added);
                    this.addObject(p, 0);
                    ++commitCnt;
                }
                if (putTagTargets || 4096 >= commitCnt) continue;
                for (ObjectId id : this.tagTargets) {
                    RevObject obj = walker.lookupOrNull(id);
                    if (!(obj instanceof RevCommit) || !obj.has(include) || obj.has(RevFlag.UNINTERESTING) || obj.has(added)) continue;
                    obj.add(added);
                    this.addObject(obj, 0);
                }
                putTagTargets = true;
            }
        }
        Object var17_25 = null;
        if (this.thin && !baseTrees.isEmpty()) {
            RevObject o;
            BaseSearch bases = new BaseSearch(countingMonitor, baseTrees, this.objectsMap, this.edgeObjects, this.reader);
            while ((o = walker.nextObject()) != null) {
                if (o.has(RevFlag.UNINTERESTING) || this.exclude(o)) continue;
                int pathHash = walker.getPathHashCode();
                byte[] pathBuf = walker.getPathBuffer();
                int pathLen = walker.getPathLength();
                bases.addBase(o.getType(), pathBuf, pathLen, pathHash);
                this.addObject(o, pathHash);
                countingMonitor.update(1);
            }
        } else {
            RevObject o;
            while ((o = walker.nextObject()) != null) {
                if (o.has(RevFlag.UNINTERESTING) || this.exclude(o)) continue;
                this.addObject(o, walker.getPathHashCode());
                countingMonitor.update(1);
            }
        }
        for (CachedPack pack : this.cachedPacks) {
            countingMonitor.update((int)pack.getObjectCount());
        }
        this.endPhase(countingMonitor);
        this.stats.timeCounting = System.currentTimeMillis() - countingStart;
        this.stats.bitmapIndexMisses = -1L;
    }

    private void findObjectsToPackUsingBitmaps(PackWriterBitmapWalker bitmapWalker, Set<? extends ObjectId> want, Set<? extends ObjectId> have) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        BitmapIndex.BitmapBuilder haveBitmap = bitmapWalker.findObjects(have, null, true);
        bitmapWalker.reset();
        BitmapIndex.BitmapBuilder wantBitmap = bitmapWalker.findObjects(want, haveBitmap, false);
        BitmapIndex.BitmapBuilder needBitmap = wantBitmap.andNot(haveBitmap);
        if (this.useCachedPacks && this.reuseSupport != null && !this.reuseValidate && (this.excludeInPacks == null || this.excludeInPacks.length == 0)) {
            this.cachedPacks.addAll(this.reuseSupport.getCachedPacksAndUpdate(needBitmap));
        }
        for (BitmapObject obj : needBitmap) {
            ObjectId objectId = obj.getObjectId();
            if (this.exclude(objectId)) {
                needBitmap.remove(objectId);
                continue;
            }
            this.addObject(objectId, obj.getType(), 0);
        }
        if (this.thin) {
            this.haveObjects = haveBitmap;
        }
    }

    private static void pruneEdgesFromObjectList(List<ObjectToPack> list) {
        int size = list.size();
        int dst = 0;
        for (int src = 0; src < size; ++src) {
            ObjectToPack obj = list.get(src);
            if (obj.isEdge()) continue;
            if (dst != src) {
                list.set(dst, obj);
            }
            ++dst;
        }
        while (dst < list.size()) {
            list.remove(list.size() - 1);
        }
    }

    public void addObject(RevObject object) throws IncorrectObjectTypeException {
        if (!this.exclude(object)) {
            this.addObject(object, 0);
        }
    }

    private void addObject(RevObject object, int pathHashCode) {
        this.addObject(object, object.getType(), pathHashCode);
    }

    private void addObject(AnyObjectId src, int type, int pathHashCode) {
        ObjectToPack otp = this.reuseSupport != null ? this.reuseSupport.newObjectToPack(src, type) : new ObjectToPack(src, type);
        otp.setPathHash(pathHashCode);
        this.objectsLists[type].add(otp);
        this.objectsMap.add(otp);
    }

    private boolean exclude(AnyObjectId objectId) {
        if (this.excludeInPacks == null) {
            return false;
        }
        if (this.excludeInPackLast.contains(objectId)) {
            return true;
        }
        for (ObjectIdSet idx : this.excludeInPacks) {
            if (!idx.contains(objectId)) continue;
            this.excludeInPackLast = idx;
            return true;
        }
        return false;
    }

    public void select(ObjectToPack otp, StoredObjectRepresentation next) {
        int nFmt = next.getFormat();
        if (!this.cachedPacks.isEmpty()) {
            if (otp.isEdge()) {
                return;
            }
            if (nFmt == 1 | nFmt == 0) {
                for (CachedPack pack : this.cachedPacks) {
                    if (!pack.hasObject(otp, next)) continue;
                    otp.setEdge();
                    otp.clearDeltaBase();
                    otp.clearReuseAsIs();
                    this.pruneCurrentObjectList = true;
                    return;
                }
            }
        }
        if (nFmt == 0 && this.reuseDeltas && this.reuseDeltaFor(otp)) {
            ObjectId baseId = next.getDeltaBase();
            ObjectToPack ptr = this.objectsMap.get(baseId);
            if (ptr != null && !ptr.isEdge()) {
                otp.setDeltaBase(ptr);
                otp.setReuseAsIs();
            } else if (this.thin && this.have(ptr, baseId)) {
                otp.setDeltaBase(baseId);
                otp.setReuseAsIs();
            } else {
                otp.clearDeltaBase();
                otp.clearReuseAsIs();
            }
        } else if (nFmt == 1 && this.config.isReuseObjects()) {
            int nWeight = next.getWeight();
            if (otp.isReuseAsIs() && !otp.isDeltaRepresentation() && otp.getWeight() <= nWeight) {
                return;
            }
            otp.clearDeltaBase();
            otp.setReuseAsIs();
            otp.setWeight(nWeight);
        } else {
            otp.clearDeltaBase();
            otp.clearReuseAsIs();
        }
        otp.setDeltaAttempted(this.reuseDeltas & next.wasDeltaAttempted());
        otp.select(next);
    }

    private final boolean have(ObjectToPack ptr, AnyObjectId objectId) {
        return ptr != null && ptr.isEdge() || this.haveObjects != null && this.haveObjects.contains(objectId);
    }

    public boolean prepareBitmapIndex(ProgressMonitor pm) throws IOException {
        if (!this.canBuildBitmaps || this.getObjectCount() > Integer.MAX_VALUE || !this.cachedPacks.isEmpty()) {
            return false;
        }
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        int numCommits = this.objectsLists[1].size();
        List<ObjectToPack> byName = this.sortByName();
        this.sortedByName = null;
        this.objectsLists = null;
        this.objectsMap = null;
        this.writeBitmaps = new PackBitmapIndexBuilder(byName);
        byName = null;
        PackWriterBitmapPreparer bitmapPreparer = new PackWriterBitmapPreparer(this.reader, this.writeBitmaps, pm, this.stats.interestingObjects);
        Collection<PackWriterBitmapPreparer.BitmapCommit> selectedCommits = bitmapPreparer.doCommitSelection(numCommits);
        this.beginPhase(PackingPhase.BUILDING_BITMAPS, pm, selectedCommits.size());
        PackWriterBitmapWalker walker = bitmapPreparer.newBitmapWalker();
        PackWriterBitmapPreparer.BitmapCommit last = null;
        for (PackWriterBitmapPreparer.BitmapCommit cmit : selectedCommits) {
            if (cmit.isReuseWalker()) {
                walker.reset();
            } else {
                walker = bitmapPreparer.newBitmapWalker();
            }
            BitmapIndex.BitmapBuilder bitmap = walker.findObjects(Collections.singleton(cmit), null, false);
            if (last != null && cmit.isReuseWalker() && !bitmap.contains(last)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().bitmapMissingObject, cmit.name(), last.name()));
            }
            last = cmit;
            this.writeBitmaps.addBitmap((AnyObjectId)cmit, bitmap.build(), cmit.getFlags());
            pm.update(1);
        }
        this.endPhase(pm);
        return true;
    }

    private boolean reuseDeltaFor(ObjectToPack otp) {
        int type = otp.getType();
        if ((type & 2) != 0) {
            return true;
        }
        if (type == 1) {
            return this.reuseDeltaCommits;
        }
        return type != 4;
    }

    static /* synthetic */ Map access$000() {
        return instances;
    }

    private class MutableState {
        private static final long OBJECT_TO_PACK_SIZE = 120L;
        private final long totalDeltaSearchBytes;
        private volatile PackingPhase phase = PackingPhase.COUNTING;

        MutableState() {
            if (PackWriter.this.config.isDeltaCompress()) {
                int threads = PackWriter.this.config.getThreads();
                if (threads <= 0) {
                    threads = Runtime.getRuntime().availableProcessors();
                }
                this.totalDeltaSearchBytes = (long)threads * PackWriter.this.config.getDeltaSearchMemoryLimit() + (long)PackWriter.this.config.getBigFileThreshold();
            } else {
                this.totalDeltaSearchBytes = 0L;
            }
        }

        State snapshot() {
            long objCnt = 0L;
            BlockList[] lists = PackWriter.this.objectsLists;
            if (lists != null) {
                objCnt += (long)lists[1].size();
                objCnt += (long)lists[2].size();
                objCnt += (long)lists[3].size();
                objCnt += (long)lists[4].size();
            }
            long bytesUsed = 120L * objCnt;
            PackingPhase curr = this.phase;
            if (curr == PackingPhase.COMPRESSING) {
                bytesUsed += this.totalDeltaSearchBytes;
            }
            return new State(curr, bytesUsed);
        }
    }

    public static interface ObjectIdSet {
        public boolean contains(AnyObjectId var1);
    }

    public static enum PackingPhase {
        COUNTING,
        GETTING_SIZES,
        FINDING_SOURCES,
        COMPRESSING,
        WRITING,
        BUILDING_BITMAPS;

    }

    public class State {
        private final PackingPhase phase;
        private final long bytesUsed;

        State(PackingPhase phase, long bytesUsed) {
            this.phase = phase;
            this.bytesUsed = bytesUsed;
        }

        public PackConfig getConfig() {
            return PackWriter.this.config;
        }

        public PackingPhase getPhase() {
            return this.phase;
        }

        public long estimateBytesUsed() {
            return this.bytesUsed;
        }

        public String toString() {
            return "PackWriter.State[" + (Object)((Object)this.phase) + ", memory=" + this.bytesUsed + "]";
        }
    }

    @Deprecated
    public static class Statistics {
        private PackStatistics statistics;

        public Statistics(PackStatistics stats) {
            this.statistics = stats;
        }

        public Set<ObjectId> getInterestingObjects() {
            return this.statistics.getInterestingObjects();
        }

        public Set<ObjectId> getUninterestingObjects() {
            return this.statistics.getUninterestingObjects();
        }

        public Collection<CachedPack> getReusedPacks() {
            return this.statistics.getReusedPacks();
        }

        public int getDeltaSearchNonEdgeObjects() {
            return this.statistics.getDeltaSearchNonEdgeObjects();
        }

        public int getDeltasFound() {
            return this.statistics.getDeltasFound();
        }

        public long getTotalObjects() {
            return this.statistics.getTotalObjects();
        }

        public long getBitmapIndexMisses() {
            return this.statistics.getBitmapIndexMisses();
        }

        public long getTotalDeltas() {
            return this.statistics.getTotalDeltas();
        }

        public long getReusedObjects() {
            return this.statistics.getReusedObjects();
        }

        public long getReusedDeltas() {
            return this.statistics.getReusedDeltas();
        }

        public long getTotalBytes() {
            return this.statistics.getTotalBytes();
        }

        public long getThinPackBytes() {
            return this.statistics.getThinPackBytes();
        }

        public ObjectType byObjectType(int typeCode) {
            return new ObjectType(this.statistics.byObjectType(typeCode));
        }

        public boolean isShallow() {
            return this.statistics.isShallow();
        }

        public int getDepth() {
            return this.statistics.getDepth();
        }

        public long getTimeCounting() {
            return this.statistics.getTimeCounting();
        }

        public long getTimeSearchingForReuse() {
            return this.statistics.getTimeSearchingForReuse();
        }

        public long getTimeSearchingForSizes() {
            return this.statistics.getTimeSearchingForSizes();
        }

        public long getTimeCompressing() {
            return this.statistics.getTimeCompressing();
        }

        public long getTimeWriting() {
            return this.statistics.getTimeWriting();
        }

        public long getTimeTotal() {
            return this.statistics.getTimeTotal();
        }

        public double getTransferRate() {
            return this.statistics.getTransferRate();
        }

        public String getMessage() {
            return this.statistics.getMessage();
        }

        public static class ObjectType {
            private PackStatistics.ObjectType objectType;

            public ObjectType(PackStatistics.ObjectType type) {
                this.objectType = type;
            }

            public long getObjects() {
                return this.objectType.getObjects();
            }

            public long getDeltas() {
                return this.objectType.getDeltas();
            }

            public long getReusedObjects() {
                return this.objectType.getReusedObjects();
            }

            public long getReusedDeltas() {
                return this.objectType.getReusedDeltas();
            }

            public long getBytes() {
                return this.objectType.getBytes();
            }

            public long getDeltaBytes() {
                return this.objectType.getDeltaBytes();
            }
        }
    }
}

