/*
 * Decompiled with CFR 0.152.
 */
package x2br.app.launcher;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.apache.log4j.Logger;
import panda.signer.Generator;
import panda.signer.SignChecker;
import panda.signer.Signer;
import x2br.app.application.AppUpdateManager;
import x2br.app.application.ProgramStarter;
import x2br.app.application.PropertiesHandler;
import x2br.app.ui.LoadingScreenPopUp;

public class App
extends Application {
    private static String local;
    private static String remote;
    private static ProgramStarter programStarter;
    private static boolean updateOnly;
    static final Logger logger;

    public static final void main(String[] args) {
        programStarter = new ProgramStarter();
        App.argsHandler(args);
        PropertiesHandler ph = new PropertiesHandler();
        local = ph.getFolder();
        try {
            remote = ph.getGit();
            App.launch((String[])args);
        }
        catch (Exception e) {
            programStarter.startProgramm();
        }
    }

    public final void start(Stage primaryStage) throws Exception {
        this.takeDown(updateOnly);
    }

    private void takeDown(boolean updateOnly) {
        LoadingScreenPopUp lsPopUp = new LoadingScreenPopUp();
        lsPopUp.show();
        Thread t = new Thread(() -> {
            AppUpdateManager installer = new AppUpdateManager(local, remote);
            installer.installOrUpdate();
            Platform.runLater(() -> {
                lsPopUp.hide();
                SignChecker signChecker = new SignChecker();
                boolean verify = true;
                System.out.println("verify result > true");
                if (!updateOnly) {
                    programStarter.startProgramm();
                }
            });
        });
        t.start();
    }

    private static void argsHandler(String[] args) {
        if (args.length > 0) {
            switch (args[0]) {
                case "updateonly": {
                    System.out.println("Only update the program");
                    updateOnly = true;
                    break;
                }
                case "skipUpdate": {
                    System.out.println("skip update and start program");
                    programStarter.startProgramm();
                    System.exit(0);
                    break;
                }
                case "generateKeys": {
                    App.generateKeys(args);
                    System.exit(0);
                    break;
                }
                case "sign": {
                    App.sign(args);
                    System.exit(0);
                    break;
                }
                case "testSign": {
                    App.testSigning();
                    System.exit(0);
                    break;
                }
                default: {
                    System.out.println("Argumento inv\u00e1lido!");
                    logger.error("Argumento inv\u00e1lido: " + args[0]);
                    System.exit(0);
                }
            }
        }
    }

    private static void generateKeys(String[] args) {
        System.out.println("generate keypair");
        Generator generator = new Generator();
        if (args.length == 2) {
            generator.generateKeypair(args[1]);
        } else {
            generator.generateKeypair();
        }
    }

    private static void sign(String[] args) {
        System.out.println("sign files");
        Signer signer = new Signer();
        if (args.length == 2) {
            signer.createSignFile(args[1], "../app/");
        } else {
            System.out.println("Please specify the path to your private key!");
        }
    }

    private static void testSigning() {
        SignChecker signChecker = new SignChecker();
        boolean valid = signChecker.verify("./pub", "../app/");
        if (valid) {
            System.out.println("Files are valid");
        } else {
            System.out.println("! Files are corrupt !");
        }
    }

    static {
        updateOnly = false;
        logger = Logger.getLogger(App.class);
    }
}

