/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.cache.TempJarCache;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontSet;
import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class UbuntuFontLoader
implements FontSet {
    private static final IntObjectHashMap fontMap = new IntObjectHashMap();
    private static final String jarSubDir = "atomic/";
    private static final String jarName = "jogl-fonts-p0.jar";
    private static final String relFontPath = "fonts/ubuntu/";
    private static final String absFontPath = "jogamp/graph/font/fonts/ubuntu/";
    private static final FontSet fontLoader = new UbuntuFontLoader();
    static final String[] availableFontFileNames = new String[]{"Ubuntu-R.ttf", "Ubuntu-RI.ttf", "Ubuntu-B.ttf", "Ubuntu-BI.ttf", "Ubuntu-L.ttf", "Ubuntu-LI.ttf", "Ubuntu-M.ttf", "Ubuntu-MI.ttf"};
    private static boolean attemptedJARLoading = false;
    private static boolean useTempJarCache = false;

    public static final FontSet get() {
        return fontLoader;
    }

    private UbuntuFontLoader() {
    }

    static boolean is(int n, int n2) {
        return 0 != (n & n2);
    }

    @Override
    public Font getDefault() throws IOException {
        return this.get(0, 0);
    }

    @Override
    public Font get(int n, int n2) throws IOException {
        Font font = (Font)fontMap.get(n << 8 | n2);
        if (font != null) {
            return font;
        }
        switch (n) {
            case 0: 
            case 3: 
            case 4: {
                if (UbuntuFontLoader.is(n2, 4)) {
                    if (UbuntuFontLoader.is(n2, 8)) {
                        font = this.abspath(availableFontFileNames[3], n, n2);
                        break;
                    }
                    font = this.abspath(availableFontFileNames[2], n, n2);
                    break;
                }
                if (UbuntuFontLoader.is(n2, 8)) {
                    font = this.abspath(availableFontFileNames[1], n, n2);
                    break;
                }
                font = this.abspath(availableFontFileNames[0], n, n2);
                break;
            }
            case 1: {
                if (UbuntuFontLoader.is(n2, 8)) {
                    font = this.abspath(availableFontFileNames[5], n, n2);
                    break;
                }
                font = this.abspath(availableFontFileNames[4], n, n2);
                break;
            }
            case 2: {
                font = UbuntuFontLoader.is(n2, 8) ? this.abspath(availableFontFileNames[6], n, n2) : this.abspath(availableFontFileNames[7], n, n2);
            }
        }
        return font;
    }

    private synchronized Font abspath(String string, int n, int n2) throws IOException {
        String string2 = "Problem loading font " + string + ", stream " + relFontPath + string;
        final Exception[] exceptionArray = new Exception[]{null};
        try {
            Font font = this.abspathImpl(string, n, n2);
            if (null != font) {
                return font;
            }
            if (!attemptedJARLoading) {
                attemptedJARLoading = true;
                Platform.initSingleton();
                if (TempJarCache.isInitialized()) {
                    final URI uRI = JarUtil.getRelativeOf(UbuntuFontLoader.class, jarSubDir, jarName);
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                TempJarCache.addResources(UbuntuFontLoader.class, uRI);
                            }
                            catch (Exception exception) {
                                exceptionArray[0] = exception;
                            }
                            return null;
                        }
                    });
                    if (null == exceptionArray[0]) {
                        useTempJarCache = true;
                        Font font2 = this.abspathImpl(string, n, n2);
                        if (null != font2) {
                            return font2;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new IOException(string2, exception);
        }
        if (null != exceptionArray[0]) {
            throw new IOException(string2, exceptionArray[0]);
        }
        throw new IOException(string2);
    }

    private Font abspathImpl(final String string, int n, int n2) throws IOException {
        URLConnection uRLConnection;
        Exception[] exceptionArray;
        if (useTempJarCache) {
            exceptionArray = new Exception[]{null};
            final URLConnection[] uRLConnectionArray = new URLConnection[]{null};
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        URI uRI = TempJarCache.getResource(UbuntuFontLoader.absFontPath + string);
                        uRLConnectionArray[0] = null != uRI ? uRI.toURL().openConnection() : null;
                    }
                    catch (Exception exception) {
                        exceptionArray[0] = exception;
                    }
                    return null;
                }
            });
            if (null != exceptionArray[0]) {
                throw new IOException(exceptionArray[0]);
            }
            uRLConnection = uRLConnectionArray[0];
        } else {
            uRLConnection = IOUtil.getResource(UbuntuFontLoader.class, relFontPath + string);
        }
        if (null != uRLConnection && null != (exceptionArray = FontFactory.get(uRLConnection))) {
            fontMap.put(n << 8 | n2, exceptionArray);
            return exceptionArray;
        }
        return null;
    }
}

