/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ToolkitLock;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTJNILibLoader;

public class JAWTUtil {
    public static final boolean DEBUG;
    private static final boolean SKIP_AWT_HIDPI;
    public static final int JAWT_MACOSX_USE_CALAYER = Integer.MIN_VALUE;
    public static final VersionNumber JAWT_MacOSXCALayerMinVersion;
    public static final VersionNumber JAWT_MacOSXCALayerRequiredForJavaVersion;
    private static final boolean headlessMode;
    private static final JAWT jawtLockObject;
    private static final Method isQueueFlusherThread;
    private static final boolean j2dExist;
    private static final Method sunToolkitAWTLockMethod;
    private static final Method sunToolkitAWTUnlockMethod;
    private static final boolean hasSunToolkitAWTLock;
    private static final RecursiveLock jawtLock;
    private static final ToolkitLock jawtToolkitLock;
    private static final Method getScaleFactorMethod;
    public static final int JAWT_OSX_CALAYER_QUIRK_SIZE = 1;
    public static final int JAWT_OSX_CALAYER_QUIRK_POSITION = 2;
    public static final int JAWT_OSX_CALAYER_QUIRK_LAYOUT = 4;

    public static boolean isOffscreenLayerSupported() {
        return PlatformPropsImpl.OS_TYPE == Platform.OSType.MACOS && PlatformPropsImpl.OS_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerMinVersion) >= 0;
    }

    public static boolean isOffscreenLayerRequired() {
        return PlatformPropsImpl.OS_TYPE == Platform.OSType.MACOS && PlatformPropsImpl.JAVA_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerRequiredForJavaVersion) >= 0;
    }

    public static int getOSXCALayerQuirks() {
        int n = 0;
        if (PlatformPropsImpl.OS_TYPE == Platform.OSType.MACOS && PlatformPropsImpl.OS_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerMinVersion) >= 0) {
            n |= 1;
            int n2 = PlatformPropsImpl.JAVA_VERSION_NUMBER.compareTo(PlatformPropsImpl.Version17);
            n = n2 < 0 || n2 == 0 && PlatformPropsImpl.JAVA_VERSION_UPDATE < 40 ? (n |= 2) : (n |= 4);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JAWT getJAWT(boolean bl) {
        boolean bl2;
        boolean bl3;
        JAWT jAWT = JAWT.create();
        int n = 65540;
        if (JAWTUtil.isOffscreenLayerRequired()) {
            if (PlatformPropsImpl.OS_TYPE != Platform.OSType.MACOS) throw new InternalError("offscreen required, but n/a for: " + (Object)((Object)PlatformPropsImpl.OS_TYPE));
            if (PlatformPropsImpl.OS_VERSION_NUMBER.compareTo(JAWT_MacOSXCALayerMinVersion) < 0) throw new RuntimeException("OSX: Invalid version of Java (" + PlatformPropsImpl.JAVA_VERSION_NUMBER + ") / OS X (" + PlatformPropsImpl.OS_VERSION_NUMBER + ")");
            n |= Integer.MIN_VALUE;
            bl3 = true;
            bl2 = false;
        } else if (bl && JAWTUtil.isOffscreenLayerSupported()) {
            if (PlatformPropsImpl.OS_TYPE != Platform.OSType.MACOS) throw new InternalError("offscreen requested and supported, but n/a for: " + (Object)((Object)PlatformPropsImpl.OS_TYPE));
            n |= Integer.MIN_VALUE;
            bl3 = true;
            bl2 = true;
        } else {
            bl3 = false;
            bl2 = true;
        }
        if (DEBUG) {
            System.err.println("JAWTUtil.getJAWT(tryOffscreenLayer " + bl3 + ", tryOnscreen " + bl2 + ")");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl3) {
            stringBuilder.append("Offscreen 0x").append(Integer.toHexString(n));
            if (JAWT.getJAWT(jAWT, n)) {
                return jAWT;
            }
        }
        if (!bl2) throw new RuntimeException("Unable to initialize JAWT, trials: " + stringBuilder.toString());
        if (bl3) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("Onscreen 0x").append(Integer.toHexString(65540));
        if (!JAWT.getJAWT(jAWT, 65540)) throw new RuntimeException("Unable to initialize JAWT, trials: " + stringBuilder.toString());
        return jAWT;
    }

    public static boolean isJAWTUsingOffscreenLayer(JAWT jAWT) {
        return 0 != (jAWT.getCachedVersion() & Integer.MIN_VALUE);
    }

    public static void initSingleton() {
    }

    public static void shutdown() {
    }

    public static boolean hasJava2D() {
        return j2dExist;
    }

    public static boolean isJava2DQueueFlusherThread() {
        boolean bl = false;
        if (j2dExist) {
            try {
                bl = (Boolean)isQueueFlusherThread.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean isHeadlessMode() {
        return headlessMode;
    }

    public static void lockToolkit() throws NativeWindowException {
        jawtLock.lock();
        if (1 == jawtLock.getHoldCount() && !headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            if (hasSunToolkitAWTLock) {
                try {
                    sunToolkitAWTLockMethod.invoke(null, (Object[])null);
                }
                catch (Exception exception) {
                    throw new NativeWindowException("SunToolkit.awtLock failed", exception);
                }
            } else {
                jawtLockObject.Lock();
            }
        }
        if (ToolkitLock.TRACE_LOCK) {
            System.err.println("JAWTUtil-ToolkitLock.lock(): " + jawtLock);
        }
    }

    public static void unlockToolkit() {
        jawtLock.validateLocked();
        if (ToolkitLock.TRACE_LOCK) {
            System.err.println("JAWTUtil-ToolkitLock.unlock(): " + jawtLock);
        }
        if (1 == jawtLock.getHoldCount() && !headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            if (hasSunToolkitAWTLock) {
                try {
                    sunToolkitAWTUnlockMethod.invoke(null, (Object[])null);
                }
                catch (Exception exception) {
                    throw new NativeWindowException("SunToolkit.awtUnlock failed", exception);
                }
            } else {
                jawtLockObject.Unlock();
            }
        }
        jawtLock.unlock();
    }

    public static final void validateLocked() throws RuntimeException {
        jawtLock.validateLocked();
    }

    public static ToolkitLock getJAWTToolkitLock() {
        return jawtToolkitLock;
    }

    public static final int getPixelScale(GraphicsDevice graphicsDevice) {
        if (!SKIP_AWT_HIDPI && null != getScaleFactorMethod) {
            try {
                Object object = getScaleFactorMethod.invoke((Object)graphicsDevice, new Object[0]);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 1;
    }

    public static final int getPixelScale(GraphicsConfiguration graphicsConfiguration) {
        GraphicsDevice graphicsDevice = null != graphicsConfiguration ? graphicsConfiguration.getDevice() : null;
        int n = null == graphicsDevice ? 0 : JAWTUtil.getPixelScale(graphicsDevice);
        if (DEBUG) {
            System.err.println("JAWTUtil.updatePixelScale: Fetched " + n);
        }
        return n;
    }

    static {
        Serializable serializable;
        DEBUG = Debug.debug("JAWT");
        JAWT_MacOSXCALayerMinVersion = new VersionNumber(10, 6, 4);
        JAWT_MacOSXCALayerRequiredForJavaVersion = Platform.Version17;
        SKIP_AWT_HIDPI = PropertyAccess.isPropertyDefined("nativewindow.awt.nohidpi", true);
        if (DEBUG) {
            System.err.println("JAWTUtil initialization (JAWT/JNI/...); SKIP_AWT_HIDPI " + SKIP_AWT_HIDPI);
        }
        if (headlessMode = GraphicsEnvironment.isHeadless()) {
            jawtLockObject = null;
            isQueueFlusherThread = null;
            j2dExist = false;
            sunToolkitAWTLockMethod = null;
            sunToolkitAWTUnlockMethod = null;
            hasSunToolkitAWTLock = false;
            getScaleFactorMethod = null;
        } else {
            JAWTJNILibLoader.initSingleton();
            if (!NWJNILibLoader.loadNativeWindow("awt")) {
                throw new NativeWindowException("NativeWindow AWT native library load error.");
            }
            jawtLockObject = JAWTUtil.getJAWT(false);
            boolean bl = false;
            serializable = null;
            Method method = null;
            try {
                serializable = Class.forName("jogamp.opengl.awt.Java2D");
                method = ((Class)serializable).getMethod("isQueueFlusherThread", null);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            isQueueFlusherThread = method;
            j2dExist = bl;
            PrivilegedDataBlob1 privilegedDataBlob1 = (PrivilegedDataBlob1)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Object object;
                    PrivilegedDataBlob1 privilegedDataBlob1 = new PrivilegedDataBlob1();
                    try {
                        object = Class.forName("sun.awt.SunToolkit");
                        privilegedDataBlob1.sunToolkitAWTLockMethod = ((Class)object).getDeclaredMethod("awtLock", new Class[0]);
                        privilegedDataBlob1.sunToolkitAWTLockMethod.setAccessible(true);
                        privilegedDataBlob1.sunToolkitAWTUnlockMethod = ((Class)object).getDeclaredMethod("awtUnlock", new Class[0]);
                        privilegedDataBlob1.sunToolkitAWTUnlockMethod.setAccessible(true);
                        privilegedDataBlob1.ok = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                        privilegedDataBlob1.getScaleFactorMethod = object.getClass().getDeclaredMethod("getScaleFactor", new Class[0]);
                        privilegedDataBlob1.getScaleFactorMethod.setAccessible(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return privilegedDataBlob1;
                }
            });
            sunToolkitAWTLockMethod = privilegedDataBlob1.sunToolkitAWTLockMethod;
            sunToolkitAWTUnlockMethod = privilegedDataBlob1.sunToolkitAWTUnlockMethod;
            getScaleFactorMethod = privilegedDataBlob1.getScaleFactorMethod;
            boolean bl2 = false;
            if (privilegedDataBlob1.ok) {
                try {
                    sunToolkitAWTLockMethod.invoke(null, (Object[])null);
                    sunToolkitAWTUnlockMethod.invoke(null, (Object[])null);
                    bl2 = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            hasSunToolkitAWTLock = bl2;
        }
        jawtLock = LockFactory.createRecursiveLock();
        jawtToolkitLock = new ToolkitLock(){

            @Override
            public final void lock() {
                JAWTUtil.lockToolkit();
            }

            @Override
            public final void unlock() {
                JAWTUtil.unlockToolkit();
            }

            @Override
            public final void validateLocked() throws RuntimeException {
                JAWTUtil.validateLocked();
            }

            @Override
            public final void dispose() {
            }

            public String toString() {
                return "JAWTToolkitLock[obj 0x" + Integer.toHexString(this.hashCode()) + ", isOwner " + jawtLock.isOwner(Thread.currentThread()) + ", " + jawtLock + "]";
            }
        };
        Map map = null;
        try {
            if (EventQueue.isDispatchThread()) {
                map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            } else {
                serializable = new ArrayList(1);
                EventQueue.invokeAndWait(new Runnable((ArrayList)serializable){
                    final /* synthetic */ ArrayList val$desktophintsBucket;
                    {
                        this.val$desktophintsBucket = arrayList;
                    }

                    @Override
                    public void run() {
                        Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                        if (null != map) {
                            this.val$desktophintsBucket.add(map);
                        }
                    }
                });
                map = ((ArrayList)serializable).size() > 0 ? (Map)((ArrayList)serializable).get(0) : null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("JAWTUtil: Has sun.awt.SunToolkit.awtLock/awtUnlock " + hasSunToolkitAWTLock);
            System.err.println("JAWTUtil: Has Java2D " + j2dExist);
            System.err.println("JAWTUtil: Is headless " + headlessMode);
            int n = null != map ? map.size() : 0;
            System.err.println("JAWTUtil: AWT Desktop hints " + n);
            System.err.println("JAWTUtil: OffscreenLayer Supported: " + JAWTUtil.isOffscreenLayerSupported() + " - Required " + JAWTUtil.isOffscreenLayerRequired());
        }
    }

    private static class PrivilegedDataBlob1 {
        Method sunToolkitAWTLockMethod;
        Method sunToolkitAWTUnlockMethod;
        Method getScaleFactorMethod;
        boolean ok = false;

        PrivilegedDataBlob1() {
        }
    }
}

