/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDescriptionRuntime;
import jogamp.nativewindow.windows.BITMAPINFOHEADER;
import jogamp.nativewindow.windows.RGBQUAD;

public class BITMAPINFO {
    StructAccessor accessor;
    private static final int mdIdx = MachineDescriptionRuntime.getStatic().ordinal();
    private static final int[] BITMAPINFO_size = new int[]{44, 44, 44, 44, 44, 44, 44};
    private static final int[] bmiHeader_offset = new int[]{0, 0, 0, 0, 0, 0, 0};
    private static final int[] bmiHeader_size = new int[]{40, 40, 40, 40, 40, 40, 40};
    private static final int[] bmiColors_offset = new int[]{40, 40, 40, 40, 40, 40, 40};
    private static final int[] bmiColors_size = new int[]{4, 4, 4, 4, 4, 4, 4};

    public static int size() {
        return BITMAPINFO_size[mdIdx];
    }

    public static BITMAPINFO create() {
        return BITMAPINFO.create(Buffers.newDirectByteBuffer(BITMAPINFO.size()));
    }

    public static BITMAPINFO create(ByteBuffer byteBuffer) {
        return new BITMAPINFO(byteBuffer);
    }

    BITMAPINFO(ByteBuffer byteBuffer) {
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public BITMAPINFOHEADER getBmiHeader() {
        return BITMAPINFOHEADER.create(this.accessor.slice(bmiHeader_offset[mdIdx], bmiHeader_size[mdIdx]));
    }

    public BITMAPINFO setBmiColors(RGBQUAD rGBQUAD) {
        int n = RGBQUAD.size();
        ByteBuffer byteBuffer = this.getBuffer();
        if (n > bmiColors_size[mdIdx]) {
            throw new IndexOutOfBoundsException("elemSize " + n + " > size " + bmiColors_size[mdIdx]);
        }
        int n2 = bmiColors_offset[mdIdx];
        int n3 = n2 + n;
        if (n3 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n3 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n2 + ", elemSize " + n);
        }
        ByteBuffer byteBuffer2 = rGBQUAD.getBuffer();
        for (int i = 0; i < n; ++i) {
            if (n2 >= n3) {
                throw new IndexOutOfBoundsException("elem-byte[0][" + i + "]: bOffset " + n2 + " >= bLimes " + n3 + ", elemSize " + n);
            }
            byteBuffer.put(n2++, byteBuffer2.get(i));
        }
        return this;
    }

    public RGBQUAD getBmiColors() {
        return RGBQUAD.create(this.accessor.slice(bmiColors_offset[mdIdx], RGBQUAD.size()));
    }
}

