/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.util.LongObjectHashMap;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.ToolkitProperties;
import jogamp.nativewindow.x11.X11Lib;

public class X11Util
implements ToolkitProperties {
    public static final boolean DEBUG = Debug.debug("X11Util");
    public static final boolean ATI_HAS_XCLOSEDISPLAY_BUG = !Debug.isPropertyDefined("nativewindow.debug.X11Util.ATI_HAS_NO_XCLOSEDISPLAY_BUG", true);
    public static final boolean HAS_XCLOSEDISPLAY_BUG = Debug.isPropertyDefined("nativewindow.debug.X11Util.HAS_XCLOSEDISPLAY_BUG", true);
    public static final boolean ATI_HAS_MULTITHREADING_BUG = !Debug.isPropertyDefined("nativewindow.debug.X11Util.ATI_HAS_NO_MULTITHREADING_BUG", true);
    public static final boolean XSYNC_ENABLED = Debug.isPropertyDefined("nativewindow.debug.X11Util.XSync", true);
    public static final boolean XERROR_STACKDUMP = DEBUG || Debug.isPropertyDefined("nativewindow.debug.X11Util.XErrorStackDump", true);
    private static final boolean TRACE_DISPLAY_LIFECYCLE = Debug.isPropertyDefined("nativewindow.debug.X11Util.TraceDisplayLifecycle", true);
    private static String nullDisplayName = null;
    private static volatile boolean isInit = false;
    private static boolean markAllDisplaysUnclosable = false;
    private static boolean hasThreadingIssues = false;
    private static final Object setX11ErrorHandlerLock = new Object();
    private static final String X11_EXTENSION_ATIFGLRXDRI = "ATIFGLRXDRI";
    private static final String X11_EXTENSION_ATIFGLEXTENSION = "ATIFGLEXTENSION";
    private static Object globalLock = new Object();
    private static LongObjectHashMap openDisplayMap = new LongObjectHashMap();
    private static List<NamedDisplay> openDisplayList = new ArrayList<NamedDisplay>();
    private static List<NamedDisplay> reusableDisplayList = new ArrayList<NamedDisplay>();
    private static List<NamedDisplay> pendingDisplayList = new ArrayList<NamedDisplay>();
    private static final HashMap<String, Boolean> displayXineramaEnabledMap = new HashMap();
    static volatile boolean XineramaFetched = false;
    static long XineramaLibHandle = 0L;
    static long XineramaQueryFunc = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initSingleton() {
        if (isInit) return;
        Class<X11Util> clazz = X11Util.class;
        synchronized (X11Util.class) {
            boolean bl;
            boolean bl2;
            if (isInit) return;
            isInit = true;
            if (DEBUG) {
                System.out.println("X11Util.initSingleton()");
            }
            if (!NWJNILibLoader.loadNativeWindow("x11")) {
                throw new NativeWindowException("NativeWindow X11 native library load error.");
            }
            boolean bl3 = X11Util.initialize0(XERROR_STACKDUMP);
            long l = X11Lib.XOpenDisplay(PropertyAccess.getProperty("nativewindow.x11.display.default", true));
            if (0L != l) {
                if (XSYNC_ENABLED) {
                    X11Lib.XSynchronize(l, true);
                }
                try {
                    nullDisplayName = X11Lib.XDisplayString(l);
                    bl2 = X11Lib.QueryExtension(l, X11_EXTENSION_ATIFGLRXDRI);
                    bl = X11Lib.QueryExtension(l, X11_EXTENSION_ATIFGLEXTENSION);
                }
                finally {
                    X11Lib.XCloseDisplay(l);
                }
            } else {
                nullDisplayName = "nil";
                bl2 = false;
                bl = false;
            }
            boolean bl4 = bl2 || bl;
            boolean bl5 = hasThreadingIssues = ATI_HAS_MULTITHREADING_BUG && bl4;
            if (!markAllDisplaysUnclosable) {
                boolean bl6 = markAllDisplaysUnclosable = ATI_HAS_XCLOSEDISPLAY_BUG && bl4 || HAS_XCLOSEDISPLAY_BUG;
            }
            if (!DEBUG) return;
            System.err.println("X11Util.initSingleton(): OK " + bl3 + "]" + ",\n\t X11 Display(NULL) <" + nullDisplayName + ">" + ",\n\t XSynchronize Enabled: " + XSYNC_ENABLED + ",\n\t X11_EXTENSION_ATIFGLRXDRI " + bl2 + ",\n\t X11_EXTENSION_ATIFGLEXTENSION " + bl + ",\n\t requiresToolkitLock " + X11Util.requiresToolkitLock() + ",\n\t hasThreadingIssues " + X11Util.hasThreadingIssues() + ",\n\t markAllDisplaysUnclosable " + X11Util.getMarkAllDisplaysUnclosable());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void shutdown() {
        if (!isInit) return;
        Class<X11Util> clazz = X11Util.class;
        synchronized (X11Util.class) {
            if (!isInit) return;
            boolean bl = NativeWindowFactory.isJVMShuttingDown();
            if (DEBUG || (openDisplayMap.size() > 0 || reusableDisplayList.size() > 0 || pendingDisplayList.size() > 0) && (reusableDisplayList.size() != pendingDisplayList.size() || !markAllDisplaysUnclosable)) {
                System.err.println("X11Util.Display: Shutdown (JVM shutdown: " + bl + ", open (no close attempt): " + openDisplayMap.size() + "/" + openDisplayList.size() + ", reusable (open, marked uncloseable): " + reusableDisplayList.size() + ", pending (open in creation order): " + pendingDisplayList.size() + ")");
                if (DEBUG) {
                    Thread.dumpStack();
                }
                if (openDisplayList.size() > 0) {
                    X11Util.dumpOpenDisplayConnections();
                }
                if (DEBUG && (reusableDisplayList.size() > 0 || pendingDisplayList.size() > 0)) {
                    X11Util.dumpPendingDisplayConnections();
                }
            }
            if (!bl) return;
            Object object = globalLock;
            synchronized (object) {
                isInit = false;
                X11Util.closePendingDisplayConnections();
                openDisplayList.clear();
                reusableDisplayList.clear();
                pendingDisplayList.clear();
                openDisplayMap.clear();
                displayXineramaEnabledMap.clear();
                X11Util.shutdown0();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static final boolean requiresToolkitLock() {
        return true;
    }

    public static final boolean hasThreadingIssues() {
        return hasThreadingIssues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setX11ErrorHandler(boolean bl, boolean bl2) {
        Object object = setX11ErrorHandlerLock;
        synchronized (object) {
            X11Util.setX11ErrorHandler0(bl, bl2);
        }
    }

    public static String getNullDisplayName() {
        return nullDisplayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAllDisplaysUnclosable() {
        Object object = globalLock;
        synchronized (object) {
            int n;
            markAllDisplaysUnclosable = true;
            for (n = 0; n < openDisplayList.size(); ++n) {
                openDisplayList.get(n).setUncloseable(true);
            }
            for (n = 0; n < reusableDisplayList.size(); ++n) {
                reusableDisplayList.get(n).setUncloseable(true);
            }
            for (n = 0; n < pendingDisplayList.size(); ++n) {
                pendingDisplayList.get(n).setUncloseable(true);
            }
        }
    }

    public static boolean getMarkAllDisplaysUnclosable() {
        return markAllDisplaysUnclosable;
    }

    private X11Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int closePendingDisplayConnections() {
        int n = 0;
        Object object = globalLock;
        synchronized (object) {
            if (X11Util.getMarkAllDisplaysUnclosable()) {
                for (int i = 0; i < pendingDisplayList.size(); ++i) {
                    NamedDisplay namedDisplay = pendingDisplayList.get(i);
                    if (DEBUG) {
                        boolean bl = !openDisplayMap.containsKey(namedDisplay.getHandle());
                        System.err.println("X11Util.closePendingDisplayConnections(): Closing [" + i + "]: " + namedDisplay + " - closeAttempted " + bl);
                    }
                    X11Util.XCloseDisplay(namedDisplay.getHandle());
                    ++n;
                }
                if (DEBUG) {
                    System.err.println("X11Util.closePendingDisplayConnections(): Closed " + n + " pending display connections");
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOpenDisplayConnectionNumber() {
        Object object = globalLock;
        synchronized (object) {
            return openDisplayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpOpenDisplayConnections() {
        Object object = globalLock;
        synchronized (object) {
            System.err.println("X11Util: Open X11 Display Connections: " + openDisplayList.size());
            for (int i = 0; i < openDisplayList.size(); ++i) {
                Throwable throwable;
                NamedDisplay namedDisplay = openDisplayList.get(i);
                System.err.println("X11Util: Open[" + i + "]: " + namedDisplay);
                if (null == namedDisplay || null == (throwable = namedDisplay.getCreationStack())) continue;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getReusableDisplayConnectionNumber() {
        Object object = globalLock;
        synchronized (object) {
            return reusableDisplayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPendingDisplayConnectionNumber() {
        Object object = globalLock;
        synchronized (object) {
            return pendingDisplayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpPendingDisplayConnections() {
        Object object = globalLock;
        synchronized (object) {
            Throwable throwable;
            NamedDisplay namedDisplay;
            int n;
            System.err.println("X11Util: Reusable X11 Display Connections: " + reusableDisplayList.size());
            for (n = 0; n < reusableDisplayList.size(); ++n) {
                namedDisplay = reusableDisplayList.get(n);
                System.err.println("X11Util: Reusable[" + n + "]: " + namedDisplay);
                if (null == namedDisplay || null == (throwable = namedDisplay.getCreationStack())) continue;
                throwable.printStackTrace();
            }
            System.err.println("X11Util: Pending X11 Display Connections (creation order): " + pendingDisplayList.size());
            for (n = 0; n < pendingDisplayList.size(); ++n) {
                namedDisplay = pendingDisplayList.get(n);
                System.err.println("X11Util: Pending[" + n + "]: " + namedDisplay);
                if (null == namedDisplay || null == (throwable = namedDisplay.getCreationStack())) continue;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean markDisplayUncloseable(long l) {
        NamedDisplay namedDisplay;
        Object object = globalLock;
        synchronized (object) {
            namedDisplay = (NamedDisplay)openDisplayMap.get(l);
        }
        if (null != namedDisplay) {
            namedDisplay.setUncloseable(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long openDisplay(String string) {
        long l = 0L;
        NamedDisplay namedDisplay = null;
        string = X11Util.validateDisplayName(string);
        boolean bl = false;
        Object object = globalLock;
        synchronized (object) {
            for (int i = 0; i < reusableDisplayList.size(); ++i) {
                if (!reusableDisplayList.get(i).getName().equals(string)) continue;
                namedDisplay = reusableDisplayList.remove(i);
                l = namedDisplay.getHandle();
                bl = true;
                break;
            }
            if (0L == l) {
                l = X11Util.XOpenDisplay(string);
                if (0L == l) {
                    throw new NativeWindowException("X11Util.Display: Unable to create a display(" + string + ") connection. Thread " + Thread.currentThread().getName());
                }
                namedDisplay = new NamedDisplay(string, l);
                pendingDisplayList.add(namedDisplay);
            }
            namedDisplay.addRef();
            openDisplayMap.put(l, namedDisplay);
            openDisplayList.add(namedDisplay);
            if (markAllDisplaysUnclosable) {
                namedDisplay.setUncloseable(true);
            }
        }
        if (DEBUG) {
            System.err.println("X11Util.Display: openDisplay [reuse " + bl + "] " + namedDisplay + ". Thread " + Thread.currentThread().getName());
        }
        return namedDisplay.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDisplay(long l) {
        Object object = globalLock;
        synchronized (object) {
            NamedDisplay namedDisplay = (NamedDisplay)openDisplayMap.remove(l);
            if (null == namedDisplay) {
                X11Util.dumpPendingDisplayConnections();
                throw new RuntimeException("X11Util.Display: Display(0x" + Long.toHexString(l) + ") with given handle is not mapped. Thread " + Thread.currentThread().getName());
            }
            if (namedDisplay.getHandle() != l) {
                X11Util.dumpPendingDisplayConnections();
                throw new RuntimeException("X11Util.Display: Display(0x" + Long.toHexString(l) + ") Mapping error: " + namedDisplay + ". Thread " + Thread.currentThread().getName());
            }
            namedDisplay.removeRef();
            if (!openDisplayList.remove(namedDisplay)) {
                throw new RuntimeException("Internal: " + namedDisplay);
            }
            if (markAllDisplaysUnclosable) {
                namedDisplay.setUncloseable(true);
            }
            if (!namedDisplay.isUncloseable()) {
                X11Util.XCloseDisplay(namedDisplay.getHandle());
                pendingDisplayList.remove(namedDisplay);
            } else {
                X11Lib.XSync(namedDisplay.getHandle(), true);
                reusableDisplayList.add(namedDisplay);
            }
            if (DEBUG) {
                System.err.println("X11Util.Display: Closed (real: " + !namedDisplay.isUncloseable() + ") " + namedDisplay + ". Thread " + Thread.currentThread().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedDisplay getNamedDisplay(long l) {
        Object object = globalLock;
        synchronized (object) {
            return (NamedDisplay)openDisplayMap.get(l);
        }
    }

    public static String validateDisplayName(String string) {
        return null == string || "decon".equals(string) ? X11Util.getNullDisplayName() : string;
    }

    public static String validateDisplayName(String string, long l) {
        if ((null == string || "decon".equals(string)) && 0L != l) {
            string = X11Lib.XDisplayString(l);
        }
        return X11Util.validateDisplayName(string);
    }

    public static long XOpenDisplay(String string) {
        long l = X11Lib.XOpenDisplay(string);
        if (XSYNC_ENABLED && 0L != l) {
            X11Lib.XSynchronize(l, true);
        }
        if (TRACE_DISPLAY_LIFECYCLE) {
            System.err.println(Thread.currentThread() + " - X11Util.XOpenDisplay(" + string + ") 0x" + Long.toHexString(l));
        }
        return l;
    }

    public static int XCloseDisplay(long l) {
        if (TRACE_DISPLAY_LIFECYCLE) {
            System.err.println(Thread.currentThread() + " - X11Util.XCloseDisplay() 0x" + Long.toHexString(l));
        }
        int n = -1;
        try {
            n = X11Lib.XCloseDisplay(l);
        }
        catch (Exception exception) {
            System.err.println("X11Util: Caught exception:");
            exception.printStackTrace();
        }
        return n;
    }

    public static boolean XineramaIsEnabled(X11GraphicsDevice x11GraphicsDevice) {
        if (null == x11GraphicsDevice) {
            throw new IllegalArgumentException("X11 Display device is NULL");
        }
        x11GraphicsDevice.lock();
        try {
            boolean bl = X11Util.XineramaIsEnabled(x11GraphicsDevice.getHandle());
            return bl;
        }
        finally {
            x11GraphicsDevice.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean XineramaIsEnabled(long l) {
        boolean bl;
        if (0L == l) {
            throw new IllegalArgumentException("X11 Display handle is NULL");
        }
        String string = X11Lib.XDisplayString(l);
        HashMap<String, Boolean> hashMap = displayXineramaEnabledMap;
        // MONITORENTER : hashMap
        HashMap<String, Boolean> hashMap2 = displayXineramaEnabledMap.get(string);
        if (null != hashMap2) {
            // MONITOREXIT : hashMap
            return (Boolean)((Object)hashMap2);
        }
        // MONITOREXIT : hashMap
        if (!XineramaFetched) {
            hashMap2 = X11Util.class;
            // MONITORENTER : jogamp.nativewindow.x11.X11Util.class
            if (!XineramaFetched) {
                XineramaLibHandle = X11Lib.XineramaGetLibHandle();
                if (0L != XineramaLibHandle) {
                    XineramaQueryFunc = X11Lib.XineramaGetQueryFunc(XineramaLibHandle);
                }
                XineramaFetched = true;
            }
            // MONITOREXIT : hashMap2
        }
        if (0L != XineramaQueryFunc) {
            bl = X11Lib.XineramaIsEnabled(XineramaQueryFunc, l);
        } else {
            if (DEBUG) {
                System.err.println("XineramaIsEnabled: Couldn't bind to Xinerama - lib 0x" + Long.toHexString(XineramaLibHandle) + "query 0x" + Long.toHexString(XineramaQueryFunc));
            }
            bl = false;
        }
        hashMap2 = displayXineramaEnabledMap;
        // MONITORENTER : hashMap2
        if (DEBUG) {
            System.err.println("XineramaIsEnabled Cache: Display " + string + " (0x" + Long.toHexString(l) + ") -> " + bl);
        }
        displayXineramaEnabledMap.put(string, bl);
        // MONITOREXIT : hashMap2
        return bl;
    }

    private static final String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    private static final void dumpStack() {
        Thread.dumpStack();
    }

    private static native boolean initialize0(boolean var0);

    private static native void shutdown0();

    private static native void setX11ErrorHandler0(boolean var0, boolean var1);

    public static class NamedDisplay {
        final String name;
        final long handle;
        final int hash32;
        int refCount;
        boolean unCloseable;
        Throwable creationStack;

        protected NamedDisplay(String string, long l) {
            this.name = string;
            this.handle = l;
            this.refCount = 0;
            this.unCloseable = false;
            int n = 31 + (int)l;
            this.hash32 = n = (n << 5) - n + (int)(l >>> 32);
            this.creationStack = DEBUG ? new Throwable("NamedDisplay Created at:") : null;
        }

        public final int hashCode() {
            return this.hash32;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof NamedDisplay) {
                return this.handle == ((NamedDisplay)object).handle;
            }
            return false;
        }

        public final void addRef() {
            ++this.refCount;
        }

        public final void removeRef() {
            --this.refCount;
        }

        public final String getName() {
            return this.name;
        }

        public final long getHandle() {
            return this.handle;
        }

        public final int getRefCount() {
            return this.refCount;
        }

        public final void setUncloseable(boolean bl) {
            this.unCloseable = bl;
        }

        public final boolean isUncloseable() {
            return this.unCloseable;
        }

        public final Throwable getCreationStack() {
            return this.creationStack;
        }

        public String toString() {
            return "NamedX11Display[" + this.name + ", 0x" + Long.toHexString(this.handle) + ", refCount " + this.refCount + ", unCloseable " + this.unCloseable + "]";
        }
    }
}

