/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.PropertyAccess;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLFBODrawable;
import javax.media.opengl.GLRunnable;
import jogamp.opengl.Debug;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLRunnableTask;

public class GLDrawableHelper {
    private static final boolean PERF_STATS;
    protected static final boolean DEBUG;
    private final Object listenersLock = new Object();
    private final ArrayList<GLEventListener> listeners = new ArrayList();
    private final HashSet<GLEventListener> listenersToBeInit = new HashSet();
    private final Object glRunnablesLock = new Object();
    private ArrayList<GLRunnableTask> glRunnables = new ArrayList();
    private volatile int glRunnableCount = 0;
    private boolean autoSwapBufferMode;
    private volatile Thread exclusiveContextThread;
    private volatile int exclusiveContextSwitch;
    private GLAnimatorControl animatorCtrl;
    private static Runnable nop;
    private GLContext sharedContext;
    private GLAutoDrawable sharedAutoDrawable;
    private static final int MAX_RELEASE_ITER = 512;
    private static final ThreadLocal<WeakReference<Runnable>> perThreadInitAction;

    public GLDrawableHelper() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.clear();
            this.listenersToBeInit.clear();
        }
        this.autoSwapBufferMode = true;
        this.exclusiveContextThread = null;
        this.exclusiveContextSwitch = 0;
        object = this.glRunnablesLock;
        synchronized (object) {
            this.glRunnableCount = 0;
            this.glRunnables.clear();
        }
        this.animatorCtrl = null;
        this.sharedContext = null;
        this.sharedAutoDrawable = null;
    }

    public final void setSharedContext(GLContext gLContext, GLContext gLContext2) throws IllegalStateException {
        if (null == gLContext2) {
            throw new IllegalStateException("Null shared GLContext");
        }
        if (gLContext == gLContext2) {
            throw new IllegalStateException("Shared GLContext same as local");
        }
        if (null != this.sharedContext) {
            throw new IllegalStateException("Shared GLContext already set");
        }
        if (null != this.sharedAutoDrawable) {
            throw new IllegalStateException("Shared GLAutoDrawable already set");
        }
        this.sharedContext = gLContext2;
    }

    public final void setSharedAutoDrawable(GLAutoDrawable gLAutoDrawable, GLAutoDrawable gLAutoDrawable2) throws IllegalStateException {
        if (null == gLAutoDrawable2) {
            throw new IllegalStateException("Null shared GLAutoDrawable");
        }
        if (gLAutoDrawable == gLAutoDrawable2) {
            throw new IllegalStateException("Shared GLAutoDrawable same as this");
        }
        if (null != this.sharedContext) {
            throw new IllegalStateException("Shared GLContext already set");
        }
        if (null != this.sharedAutoDrawable) {
            throw new IllegalStateException("Shared GLAutoDrawable already set");
        }
        this.sharedAutoDrawable = gLAutoDrawable2;
    }

    public boolean isSharedGLContextPending(GLContext[] gLContextArray) {
        GLContext gLContext;
        boolean bl = null != this.sharedAutoDrawable ? null == (gLContext = this.sharedAutoDrawable.getContext()) || !gLContext.isCreated() || !this.sharedAutoDrawable.areAllGLEventListenerInitialized() : null != (gLContext = this.sharedContext) && !gLContext.isCreated();
        gLContextArray[0] = gLContext;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GLAnimatorControl: " + this.animatorCtrl + ", ");
        Object object = this.listenersLock;
        synchronized (object) {
            stringBuilder.append("GLEventListeners num " + this.listeners.size() + " [");
            for (int i = 0; i < this.listeners.size(); ++i) {
                GLEventListener gLEventListener = this.listeners.get(i);
                stringBuilder.append(gLEventListener);
                stringBuilder.append("[init ");
                stringBuilder.append(!this.listenersToBeInit.contains(gLEventListener));
                stringBuilder.append("], ");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final void forceNativeRelease(GLContext gLContext) {
        int n = 0;
        do {
            gLContext.release();
            ++n;
            if (!DEBUG) continue;
            System.err.println("GLDrawableHelper.forceNativeRelease() #" + n + " -- currentThread " + Thread.currentThread() + " -> " + GLContext.getCurrent());
        } while (512 > n && gLContext.isCurrent());
        if (gLContext.isCurrent()) {
            throw new GLException("Context still current after 512 releases: " + gLContext);
        }
    }

    public static final void switchContext(GLDrawable gLDrawable, GLContext gLContext, boolean bl, GLContext gLContext2, int n) {
        if (null != gLContext) {
            if (bl) {
                gLContext.destroy();
            } else {
                gLContext.setGLDrawable(null, true);
            }
        }
        if (null != gLContext2) {
            gLContext2.setContextCreationFlags(n);
            gLContext2.setGLDrawable(gLDrawable, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GLDrawableImpl recreateGLDrawable(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        ProxySurface proxySurface;
        if (!gLDrawableImpl.isRealized()) {
            return gLDrawableImpl;
        }
        GLContext gLContext2 = GLContext.getCurrent();
        GLDrawableFactory gLDrawableFactory = gLDrawableImpl.getFactory();
        NativeSurface nativeSurface = gLDrawableImpl.getNativeSurface();
        ProxySurface proxySurface2 = proxySurface = nativeSurface instanceof ProxySurface ? (ProxySurface)nativeSurface : null;
        if (null != gLContext) {
            if (gLContext2 != gLContext) {
                gLContext.makeCurrent();
            }
            gLContext.setGLDrawable(null, true);
        }
        if (null != proxySurface) {
            proxySurface.enableUpstreamSurfaceHookLifecycle(false);
        }
        try {
            gLDrawableImpl.setRealized(false);
            gLDrawableImpl = (GLDrawableImpl)gLDrawableFactory.createGLDrawable(nativeSurface);
            gLDrawableImpl.setRealized(true);
        }
        finally {
            if (null != proxySurface) {
                proxySurface.enableUpstreamSurfaceHookLifecycle(true);
            }
        }
        if (null != gLContext) {
            gLContext.setGLDrawable(gLDrawableImpl, true);
        }
        if (null != gLContext2) {
            gLContext2.makeCurrent();
        }
        return gLDrawableImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final GLDrawableImpl resizeOffscreenDrawable(GLDrawableImpl gLDrawableImpl, GLContext gLContext, int n, int n2) throws NativeWindowException, GLException {
        NativeSurface nativeSurface = gLDrawableImpl.getNativeSurface();
        int n3 = nativeSurface.lockSurface();
        if (1 >= n3) {
            throw new NativeWindowException("Could not lock surface of drawable: " + gLDrawableImpl);
        }
        boolean bl = true;
        try {
            if (!gLDrawableImpl.isRealized()) {
                GLDrawableImpl gLDrawableImpl2 = gLDrawableImpl;
                return gLDrawableImpl2;
            }
            if (gLDrawableImpl.getChosenGLCapabilities().isOnscreen()) {
                throw new NativeWindowException("Drawable is not offscreen: " + gLDrawableImpl);
            }
            if (DEBUG && (0 >= n || 0 >= n2)) {
                System.err.println("WARNING: Odd size detected: " + n + "x" + n2 + ", using safe size 1x1. Drawable " + gLDrawableImpl);
                Thread.dumpStack();
            }
            if (0 >= n) {
                n = 1;
                bl = false;
            }
            if (0 >= n2) {
                n2 = 1;
                bl = false;
            }
            if (nativeSurface instanceof ProxySurface) {
                ProxySurface proxySurface = (ProxySurface)nativeSurface;
                UpstreamSurfaceHook upstreamSurfaceHook = proxySurface.getUpstreamSurfaceHook();
                if (upstreamSurfaceHook instanceof UpstreamSurfaceHook.MutableSize) {
                    ((UpstreamSurfaceHook.MutableSize)upstreamSurfaceHook).setSurfaceSize(n, n2);
                } else if (DEBUG) {
                    System.err.println("GLDrawableHelper.resizeOffscreenDrawable: Drawable's offscreen ProxySurface n.a. UpstreamSurfaceHook.MutableSize, but " + upstreamSurfaceHook.getClass().getName() + ": " + upstreamSurfaceHook);
                }
            } else if (DEBUG) {
                System.err.println("GLDrawableHelper.resizeOffscreenDrawable: Drawable's offscreen surface n.a. ProxySurface, but " + nativeSurface.getClass().getName() + ": " + nativeSurface);
            }
            if (gLDrawableImpl instanceof GLFBODrawable) {
                if (null != gLContext && gLContext.isCreated()) {
                    ((GLFBODrawable)((Object)gLDrawableImpl)).resetSize(gLContext.getGL());
                }
            } else {
                gLDrawableImpl = GLDrawableHelper.recreateGLDrawable(gLDrawableImpl, gLContext);
            }
        }
        finally {
            nativeSurface.unlockSurface();
        }
        if (bl && (gLDrawableImpl.getSurfaceWidth() != n || gLDrawableImpl.getSurfaceHeight() != n2)) {
            throw new InternalError("Incomplete resize operation: expected " + n + "x" + n2 + ", has: " + gLDrawableImpl);
        }
        return gLDrawableImpl;
    }

    public final void addGLEventListener(GLEventListener gLEventListener) {
        this.addGLEventListener(-1, gLEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGLEventListener(int n, GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.listeners.size();
            }
            this.listenersToBeInit.add(gLEventListener);
            this.listeners.add(n, gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener removeGLEventListener(GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listenersToBeInit.remove(gLEventListener);
            return this.listeners.remove(gLEventListener) ? gLEventListener : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener removeGLEventListener(int n) throws IndexOutOfBoundsException {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.listeners.size() - 1;
            }
            GLEventListener gLEventListener = this.listeners.remove(n);
            this.listenersToBeInit.remove(gLEventListener);
            return gLEventListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getGLEventListenerCount() {
        Object object = this.listenersLock;
        synchronized (object) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener getGLEventListener(int n) throws IndexOutOfBoundsException {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.listeners.size() - 1;
            }
            return this.listeners.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean areAllGLEventListenerInitialized() {
        Object object = this.listenersLock;
        synchronized (object) {
            return 0 == this.listenersToBeInit.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getGLEventListenerInitState(GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            return !this.listenersToBeInit.contains(gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setGLEventListenerInitState(GLEventListener gLEventListener, boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (bl) {
                this.listenersToBeInit.remove(gLEventListener);
            } else {
                this.listenersToBeInit.add(gLEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener disposeGLEventListener(GLAutoDrawable gLAutoDrawable, GLEventListener gLEventListener, boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (bl) {
                if (this.listeners.remove(gLEventListener)) {
                    if (!this.listenersToBeInit.remove(gLEventListener)) {
                        gLEventListener.dispose(gLAutoDrawable);
                    }
                    return gLEventListener;
                }
            } else if (this.listeners.contains(gLEventListener) && !this.listenersToBeInit.contains(gLEventListener)) {
                gLEventListener.dispose(gLAutoDrawable);
                this.listenersToBeInit.add(gLEventListener);
                return gLEventListener;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int disposeAllGLEventListener(GLAutoDrawable gLAutoDrawable, boolean bl) throws GLException {
        Throwable throwable = null;
        int n = 0;
        Object object = this.listenersLock;
        synchronized (object) {
            if (bl) {
                for (int i = this.listeners.size(); 0 < i && 0 < this.listeners.size(); --i) {
                    GLEventListener gLEventListener = this.listeners.remove(0);
                    if (this.listenersToBeInit.remove(gLEventListener)) continue;
                    try {
                        gLEventListener.dispose(gLAutoDrawable);
                    }
                    catch (Throwable throwable2) {
                        if (null == throwable) {
                            throwable = throwable2;
                        }
                        GLException.dumpThrowable("subsequent", throwable2);
                    }
                    ++n;
                }
            } else {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    GLEventListener gLEventListener = this.listeners.get(i);
                    if (this.listenersToBeInit.contains(gLEventListener)) continue;
                    try {
                        gLEventListener.dispose(gLAutoDrawable);
                    }
                    catch (Throwable throwable3) {
                        if (null == throwable) {
                            throwable = throwable3;
                        }
                        GLException.dumpThrowable("subsequent", throwable3);
                    }
                    this.listenersToBeInit.add(gLEventListener);
                    ++n;
                }
            }
        }
        if (null != throwable) {
            this.flushGLRunnables();
            throw GLException.newGLException(throwable);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLEventListener disposeGLEventListener(final GLAutoDrawable gLAutoDrawable, GLDrawable gLDrawable, GLContext gLContext, final GLEventListener gLEventListener, final boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listenersToBeInit.contains(gLEventListener)) {
                if (bl) {
                    this.listenersToBeInit.remove(gLEventListener);
                    return this.listeners.remove(gLEventListener) ? gLEventListener : null;
                }
                return null;
            }
        }
        boolean bl2 = this.isAnimatorAnimatingOnOtherThread() && this.animatorCtrl.pause();
        final GLEventListener[] gLEventListenerArray = new GLEventListener[]{null};
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                gLEventListenerArray[0] = GLDrawableHelper.this.disposeGLEventListener(gLAutoDrawable, gLEventListener, bl);
            }
        };
        this.invokeGL(gLDrawable, gLContext, runnable, nop);
        if (bl2) {
            this.animatorCtrl.resume();
        }
        return gLEventListenerArray[0];
    }

    public final void disposeAllGLEventListener(final GLAutoDrawable gLAutoDrawable, GLDrawable gLDrawable, GLContext gLContext, final boolean bl) {
        boolean bl2 = this.isAnimatorAnimatingOnOtherThread() && this.animatorCtrl.pause();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GLDrawableHelper.this.disposeAllGLEventListener(gLAutoDrawable, bl);
            }
        };
        this.invokeGL(gLDrawable, gLContext, runnable, nop);
        if (bl2) {
            this.animatorCtrl.resume();
        }
    }

    private final void init(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        gLEventListener.init(gLAutoDrawable);
        if (bl) {
            this.reshape(gLEventListener, gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight(), bl2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(GLAutoDrawable gLAutoDrawable, boolean bl) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            int n = arrayList.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    GLEventListener gLEventListener = arrayList.get(i);
                    this.listenersToBeInit.remove(gLEventListener);
                    this.init(gLEventListener, gLAutoDrawable, bl, 0 == i);
                }
            } else {
                gLAutoDrawable.getGL().glViewport(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
            }
        }
    }

    public final void display(GLAutoDrawable gLAutoDrawable) {
        this.displayImpl(gLAutoDrawable);
        if (this.glRunnableCount > 0 && !this.execGLRunnables(gLAutoDrawable)) {
            this.displayImpl(gLAutoDrawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void displayImpl(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                GLEventListener gLEventListener = arrayList.get(i);
                if (this.listenersToBeInit.remove(gLEventListener)) {
                    this.init(gLEventListener, gLAutoDrawable, true, this.listenersToBeInit.size() + 1 == n);
                }
                gLEventListener.display(gLAutoDrawable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runForAllGLEventListener(GLAutoDrawable gLAutoDrawable, GLEventListenerAction gLEventListenerAction) {
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList<GLEventListener> arrayList = this.listeners;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                GLEventListener gLEventListener = arrayList.get(i);
                if (this.listenersToBeInit.remove(gLEventListener)) {
                    this.init(gLEventListener, gLAutoDrawable, true, this.listenersToBeInit.size() + 1 == n);
                }
                gLEventListenerAction.run(gLAutoDrawable, gLEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reshape(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        Object object;
        if (bl2) {
            object = this.listenersLock;
            synchronized (object) {
                if (this.listenersToBeInit.remove(gLEventListener)) {
                    gLEventListener.init(gLAutoDrawable);
                }
            }
        }
        if (bl) {
            object = gLAutoDrawable.getGL();
            int n5 = object.glGetError();
            if (0 != n5) {
                System.err.println("Info: GLDrawableHelper.reshape: pre-exisiting GL error 0x" + Integer.toHexString(n5));
                if (DEBUG) {
                    Thread.dumpStack();
                }
            }
            gLAutoDrawable.getGL().glViewport(n, n2, n3, n4);
        }
        gLEventListener.reshape(gLAutoDrawable, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        Object object = this.listenersLock;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.reshape(this.listeners.get(i), gLAutoDrawable, n, n2, n3, n4, 0 == i, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean execGLRunnables(GLAutoDrawable gLAutoDrawable) {
        ArrayList<GLRunnableTask> arrayList;
        Object object = this.glRunnablesLock;
        synchronized (object) {
            if (this.glRunnables.size() <= 0) {
                return true;
            }
            this.glRunnableCount = 0;
            arrayList = this.glRunnables;
            this.glRunnables = new ArrayList();
        }
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            bl = arrayList.get(i).run(gLAutoDrawable) && bl;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushGLRunnables() {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            this.glRunnableCount = 0;
            while (this.glRunnables.size() > 0) {
                this.glRunnables.remove(0).flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            if (this.animatorCtrl != gLAnimatorControl && null != gLAnimatorControl && null != this.animatorCtrl) {
                throw new GLException("Trying to register GLAnimatorControl " + gLAnimatorControl + ", where " + this.animatorCtrl + " is already registered. Unregister first.");
            }
            this.animatorCtrl = gLAnimatorControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLAnimatorControl getAnimator() {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            return this.animatorCtrl;
        }
    }

    public final boolean isAnimatorStartedOnOtherThread() {
        return null != this.animatorCtrl ? this.animatorCtrl.isStarted() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    public final boolean isAnimatorStarted() {
        return null != this.animatorCtrl ? this.animatorCtrl.isStarted() : false;
    }

    public final boolean isAnimatorAnimatingOnOtherThread() {
        return null != this.animatorCtrl ? this.animatorCtrl.isAnimating() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    public final boolean isAnimatorAnimating() {
        return null != this.animatorCtrl ? this.animatorCtrl.isAnimating() : false;
    }

    public static final boolean isLockedByOtherThread(GLAutoDrawable gLAutoDrawable) {
        Thread thread = Thread.currentThread();
        Thread thread2 = gLAutoDrawable.getUpstreamLock().getOwner();
        if (null != thread2 && thread != thread2) {
            return true;
        }
        NativeSurface nativeSurface = gLAutoDrawable.getNativeSurface();
        Thread thread3 = null != nativeSurface ? nativeSurface.getSurfaceLockOwner() : null;
        return null != thread3 && thread != thread3;
    }

    public static final boolean isLockedByThisThread(GLAutoDrawable gLAutoDrawable) {
        Thread thread;
        Thread thread2 = Thread.currentThread();
        if (thread2 == (thread = gLAutoDrawable.getUpstreamLock().getOwner())) {
            return true;
        }
        NativeSurface nativeSurface = gLAutoDrawable.getNativeSurface();
        Thread thread3 = null != nativeSurface ? nativeSurface.getSurfaceLockOwner() : null;
        return thread2 == thread3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean invoke(GLAutoDrawable gLAutoDrawable, boolean bl, GLRunnable gLRunnable) throws IllegalStateException {
        if (null == gLRunnable || null == gLAutoDrawable || bl && (!gLAutoDrawable.isRealized() || null == gLAutoDrawable.getContext())) {
            return false;
        }
        GLRunnableTask gLRunnableTask = null;
        Object object = new Object();
        Throwable throwable = null;
        Object object2 = object;
        synchronized (object2) {
            boolean bl2;
            Object object3 = this.glRunnablesLock;
            synchronized (object3) {
                boolean bl3 = gLAutoDrawable.isThreadGLCapable();
                bl2 = this.isAnimatorAnimatingOnOtherThread();
                if (bl2) {
                    if (bl && GLDrawableHelper.isLockedByThisThread(gLAutoDrawable)) {
                        if (!bl3) throw new IllegalStateException("Deferred, wait, isLocked on current and not GL-Thread: thread " + Thread.currentThread());
                        bl2 = false;
                        bl = false;
                    }
                } else {
                    if (!bl3 && GLDrawableHelper.isLockedByThisThread(gLAutoDrawable)) {
                        throw new IllegalStateException("Not deferred, isLocked on current and not GL-Thread: thread " + Thread.currentThread());
                    }
                    bl = false;
                }
                gLRunnableTask = new GLRunnableTask(gLRunnable, bl ? object : null, bl);
                ++this.glRunnableCount;
                this.glRunnables.add(gLRunnableTask);
            }
            if (!bl2) {
                gLAutoDrawable.display();
            } else {
                if (!bl) return true;
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = gLRunnableTask.getThrowable();
                }
                if (null == throwable) return true;
                throw new RuntimeException(throwable);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean invoke(GLAutoDrawable gLAutoDrawable, boolean bl, List<GLRunnable> list) throws IllegalStateException {
        if (null == list || list.size() == 0 || null == gLAutoDrawable || bl && (!gLAutoDrawable.isRealized() || null == gLAutoDrawable.getContext())) {
            return false;
        }
        int n = list.size();
        GLRunnableTask gLRunnableTask = null;
        Object object = new Object();
        Throwable throwable = null;
        Object object2 = object;
        synchronized (object2) {
            boolean bl2;
            Object object3 = this.glRunnablesLock;
            synchronized (object3) {
                boolean bl3 = gLAutoDrawable.isThreadGLCapable();
                bl2 = this.isAnimatorAnimatingOnOtherThread();
                if (bl2) {
                    if (bl && GLDrawableHelper.isLockedByThisThread(gLAutoDrawable)) {
                        if (!bl3) throw new IllegalStateException("Deferred, wait, isLocked on current and not GL-Thread: thread " + Thread.currentThread());
                        bl2 = false;
                        bl = false;
                    }
                } else {
                    if (!bl3 && GLDrawableHelper.isLockedByThisThread(gLAutoDrawable)) {
                        throw new IllegalStateException("Not deferred, isLocked on current and not GL-Thread: thread " + Thread.currentThread());
                    }
                    bl = false;
                }
                for (int i = 0; i < n - 1; ++i) {
                    ++this.glRunnableCount;
                    this.glRunnables.add(new GLRunnableTask(list.get(i), null, false));
                }
                gLRunnableTask = new GLRunnableTask(list.get(n - 1), bl ? object : null, bl);
                ++this.glRunnableCount;
                this.glRunnables.add(gLRunnableTask);
            }
            if (!bl2) {
                gLAutoDrawable.display();
            } else {
                if (!bl) return true;
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = gLRunnableTask.getThrowable();
                }
                if (null == throwable) return true;
                throw new RuntimeException(throwable);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(GLRunnable gLRunnable) {
        if (null == gLRunnable) {
            return;
        }
        Object object = this.glRunnablesLock;
        synchronized (object) {
            ++this.glRunnableCount;
            this.glRunnables.add(new GLRunnableTask(gLRunnable, null, false));
        }
    }

    public final void setAutoSwapBufferMode(boolean bl) {
        this.autoSwapBufferMode = bl;
    }

    public final boolean getAutoSwapBufferMode() {
        return this.autoSwapBufferMode;
    }

    private final String getExclusiveContextSwitchString() {
        return 0 == this.exclusiveContextSwitch ? "nop" : (0 > this.exclusiveContextSwitch ? "released" : "claimed");
    }

    public final Thread setExclusiveContextThread(Thread thread, GLContext gLContext) throws GLException {
        if (DEBUG) {
            System.err.println("GLDrawableHelper.setExclusiveContextThread(): START switch " + this.getExclusiveContextSwitchString() + ", thread " + this.exclusiveContextThread + " -> " + thread + " -- currentThread " + Thread.currentThread());
        }
        Thread thread2 = this.exclusiveContextThread;
        if (this.exclusiveContextThread == thread) {
            this.exclusiveContextSwitch = 0;
        } else if (null == thread) {
            this.exclusiveContextSwitch = -1;
        } else {
            this.exclusiveContextSwitch = 1;
            if (null != this.exclusiveContextThread) {
                throw new GLException("Release current exclusive Context Thread " + this.exclusiveContextThread + " first");
            }
            if (null != gLContext && gLContext.isCurrent()) {
                try {
                    GLDrawableHelper.forceNativeRelease(gLContext);
                }
                catch (Throwable throwable) {
                    this.flushGLRunnables();
                    throw GLException.newGLException(throwable);
                }
            }
            this.exclusiveContextThread = thread;
        }
        if (DEBUG) {
            System.err.println("GLDrawableHelper.setExclusiveContextThread(): END switch " + this.getExclusiveContextSwitchString() + ", thread " + this.exclusiveContextThread + " -- currentThread " + Thread.currentThread());
        }
        return thread2;
    }

    public final Thread getExclusiveContextThread() {
        return this.exclusiveContextThread;
    }

    private static final Runnable getLastInitAction() {
        WeakReference<Runnable> weakReference = perThreadInitAction.get();
        if (null != weakReference) {
            Runnable runnable = (Runnable)weakReference.get();
            if (null == runnable) {
                perThreadInitAction.set(null);
            }
            return runnable;
        }
        return null;
    }

    private static final void setLastInitAction(Runnable runnable) {
        perThreadInitAction.set(new WeakReference<Runnable>(runnable));
    }

    public final void invokeGL(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        if (null == gLContext) {
            if (DEBUG) {
                GLException.dumpThrowable("informal", new GLException("Info: GLDrawableHelper " + this + ".invokeGL(): NULL GLContext"));
            }
            return;
        }
        if (PERF_STATS) {
            this.invokeGLImplStats(gLDrawable, gLContext, runnable, runnable2);
        } else {
            this.invokeGLImpl(gLDrawable, gLContext, runnable, runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disposeGL(GLAutoDrawable gLAutoDrawable, GLContext gLContext, boolean bl) throws GLException {
        GLContext gLContext2 = GLContext.getCurrent();
        Runnable runnable = null;
        if (gLContext2 != null) {
            if (gLContext2 == gLContext) {
                gLContext2 = null;
            } else {
                runnable = GLDrawableHelper.getLastInitAction();
                gLContext2.release();
            }
        }
        GLException gLException = null;
        Throwable throwable = null;
        try {
            int n = gLContext.makeCurrent();
            if (0 != n) {
                if (2 == n) {
                    throw new GLException(GLDrawableHelper.getThreadName() + " GLDrawableHelper " + this + ".invokeGL(): Dispose case (no init action given): Native context was not created (new ctx): " + gLContext);
                }
                if (this.listeners.size() > 0 && null != gLAutoDrawable) {
                    try {
                        this.disposeAllGLEventListener(gLAutoDrawable, false);
                    }
                    catch (GLException gLException2) {
                        gLException = gLException2;
                    }
                }
            }
        }
        finally {
            try {
                if (bl) {
                    gLContext.destroy();
                } else {
                    GLDrawableHelper.forceNativeRelease(gLContext);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            this.flushGLRunnables();
            if (gLContext2 != null) {
                int n = gLContext2.makeCurrent();
                if (null != runnable && n == 2) {
                    runnable.run();
                }
            }
            if (null != gLException) {
                if (null != throwable) {
                    GLException.dumpThrowable("subsequent", throwable);
                }
                throw gLException;
            }
            if (null != throwable) {
                throw GLException.newGLException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void invokeGLImpl(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        Throwable throwable;
        Throwable throwable2;
        block33: {
            int n;
            boolean bl;
            int n2;
            Thread thread = Thread.currentThread();
            throwable2 = null;
            throwable = null;
            if (null != this.exclusiveContextThread) {
                if (thread != this.exclusiveContextThread) return;
                n2 = 0 > this.exclusiveContextSwitch ? 1 : 0;
                bl = n2 == 0;
                this.exclusiveContextSwitch = 0;
            } else {
                n2 = 0;
                bl = false;
            }
            int n3 = 0;
            GLContext gLContext2 = GLContext.getCurrent();
            Runnable runnable3 = null;
            if (gLContext2 != null) {
                if (gLContext2 == gLContext) {
                    n3 = 1;
                    gLContext2 = null;
                } else {
                    runnable3 = GLDrawableHelper.getLastInitAction();
                    gLContext2.release();
                }
            }
            try {
                if (0 == n3) {
                    n3 = gLContext.makeCurrent();
                    n = !bl ? 1 : 0;
                } else {
                    n = n2;
                }
                if (0 != n3) {
                    try {
                        GLDrawableHelper.setLastInitAction(runnable2);
                        if (2 == n3) {
                            if (DEBUG) {
                                System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                            }
                            runnable2.run();
                        }
                        runnable.run();
                        if (this.autoSwapBufferMode) {
                            gLDrawable.swapBuffers();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                    }
                    finally {
                        if (n2 != 0) {
                            this.exclusiveContextThread = null;
                            if (DEBUG) {
                                System.err.println("GLDrawableHelper.invokeGL() - Release ExclusiveContextThread -- currentThread " + Thread.currentThread());
                            }
                        }
                        if (n != 0) {
                            try {
                                gLContext.release();
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                            }
                        }
                    }
                }
                if (gLContext2 == null) break block33;
            }
            catch (Throwable throwable5) {
                if (gLContext2 != null) {
                    int n4 = gLContext2.makeCurrent();
                    if (null != runnable3 && n4 == 2) {
                        runnable3.run();
                    }
                }
                if (null != throwable2) {
                    this.flushGLRunnables();
                    if (null == throwable) throw GLException.newGLException(throwable2);
                    GLException.dumpThrowable("subsequent", throwable);
                    throw GLException.newGLException(throwable2);
                }
                if (null == throwable) throw throwable5;
                this.flushGLRunnables();
                throw GLException.newGLException(throwable);
            }
            n = gLContext2.makeCurrent();
            if (null != runnable3 && n == 2) {
                runnable3.run();
            }
        }
        if (null != throwable2) {
            this.flushGLRunnables();
            if (null == throwable) throw GLException.newGLException(throwable2);
            GLException.dumpThrowable("subsequent", throwable);
            throw GLException.newGLException(throwable2);
        }
        if (null == throwable) return;
        this.flushGLRunnables();
        throw GLException.newGLException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void invokeGLImplStats(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        int n;
        boolean bl;
        boolean bl2;
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        Runnable runnable3;
        GLContext gLContext2;
        Throwable throwable;
        Throwable throwable2;
        block33: {
            boolean bl3;
            int n2;
            Thread thread = Thread.currentThread();
            throwable2 = null;
            throwable = null;
            if (null != this.exclusiveContextThread) {
                if (thread != this.exclusiveContextThread) return;
                n2 = 0 > this.exclusiveContextSwitch ? 1 : 0;
                bl3 = n2 == 0;
            } else {
                n2 = 0;
                bl3 = false;
            }
            int n3 = 0;
            gLContext2 = GLContext.getCurrent();
            runnable3 = null;
            if (gLContext2 != null) {
                if (gLContext2 == gLContext) {
                    n3 = 1;
                    gLContext2 = null;
                } else {
                    runnable3 = GLDrawableHelper.getLastInitAction();
                    gLContext2.release();
                }
            }
            l5 = System.currentTimeMillis();
            l4 = 0L;
            l3 = 0L;
            l2 = 0L;
            l = 0L;
            bl2 = false;
            bl = false;
            try {
                if (0 == n3) {
                    n3 = gLContext.makeCurrent();
                    n = !bl3 ? 1 : 0;
                    bl2 = true;
                } else {
                    n = n2;
                }
                if (0 == n3) break block33;
                try {
                    GLDrawableHelper.setLastInitAction(runnable2);
                    if (2 == n3) {
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                        }
                        runnable2.run();
                    }
                    l3 = System.currentTimeMillis();
                    l4 = l3 - l5;
                    runnable.run();
                    l2 = System.currentTimeMillis();
                    l3 = l2 - l3;
                    if (this.autoSwapBufferMode) {
                        gLDrawable.swapBuffers();
                        l = System.currentTimeMillis();
                        l2 = l - l2;
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                }
                finally {
                    if (n2 != 0) {
                        this.exclusiveContextSwitch = 0;
                        this.exclusiveContextThread = null;
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper.invokeGL() - Release ExclusiveContextThread -- currentThread " + Thread.currentThread());
                        }
                    }
                    if (n != 0) {
                        try {
                            gLContext.release();
                            bl = true;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                l = System.currentTimeMillis() - l;
                if (gLContext2 != null) {
                    int n4 = gLContext2.makeCurrent();
                    if (null != runnable3 && n4 == 2) {
                        runnable3.run();
                    }
                }
                if (null != throwable2) {
                    this.flushGLRunnables();
                    if (null == throwable) throw GLException.newGLException(throwable2);
                    GLException.dumpThrowable("subsequent", throwable);
                    throw GLException.newGLException(throwable2);
                }
                if (null == throwable) throw throwable5;
                this.flushGLRunnables();
                throw GLException.newGLException(throwable);
            }
        }
        l = System.currentTimeMillis() - l;
        if (gLContext2 != null) {
            n = gLContext2.makeCurrent();
            if (null != runnable3 && n == 2) {
                runnable3.run();
            }
        }
        if (null != throwable2) {
            this.flushGLRunnables();
            if (null == throwable) throw GLException.newGLException(throwable2);
            GLException.dumpThrowable("subsequent", throwable);
            throw GLException.newGLException(throwable2);
        }
        if (null != throwable) {
            this.flushGLRunnables();
            throw GLException.newGLException(throwable);
        }
        long l6 = System.currentTimeMillis() - l5;
        System.err.println("td0 " + l6 + "ms, fps " + 1.0 / ((double)l6 / 1000.0) + ", td-makeCurrent: " + l4 + "ms, td-render " + l3 + "ms, td-swap " + l2 + "ms, td-release " + l + "ms, ctx claimed: " + bl2 + ", ctx release: " + bl + ", ctx destroyed " + false);
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    static {
        Debug.initSingleton();
        PERF_STATS = PropertyAccess.isPropertyDefined("jogl.debug.GLDrawable.PerfStats", true);
        DEBUG = GLDrawableImpl.DEBUG;
        nop = new Runnable(){

            @Override
            public void run() {
            }
        };
        perThreadInitAction = new ThreadLocal();
    }

    public static interface GLEventListenerAction {
        public void run(GLAutoDrawable var1, GLEventListener var2);
    }
}

