/*
 * Decompiled with CFR 0.152.
 */
package mprj.webdesktop;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefAppHandlerAdapter;

public class CefBrowserSample
extends JFrame {
    private final JTextField address;
    private final CefBrowser cefBrowser;

    private CefBrowserSample(String startURL, boolean useOSR, boolean isTransparent) {
        CefApp.addAppHandler(new CefAppHandlerAdapter(null){

            @Override
            public void stateHasChanged(CefApp.CefAppState state) {
                if (state == CefApp.CefAppState.TERMINATED) {
                    System.exit(0);
                }
            }
        });
        CefSettings settings = new CefSettings();
        settings.windowless_rendering_enabled = useOSR;
        CefApp cefApp = CefApp.getInstance(settings);
        CefClient cefClient = cefApp.createClient();
        this.cefBrowser = cefClient.createBrowser(startURL, useOSR, isTransparent);
        Component browserUI = this.cefBrowser.getUIComponent();
        this.address = new JTextField(startURL, 100);
        this.address.addActionListener(e -> this.cefBrowser.loadURL(this.address.getText()));
        this.getContentPane().add((Component)this.address, "North");
        this.getContentPane().add(browserUI, "Center");
        this.pack();
        this.setSize(800, 600);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CefApp.getInstance().dispose();
                CefBrowserSample.this.dispose();
            }
        });
    }

    public static void main(String[] args) {
        new CefBrowserSample("http://www.google.com", OS.isLinux(), false);
    }
}

