/*
 * Decompiled with CFR 0.152.
 */
package mprj.webdesktop.tests;

import java.util.Optional;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class AlertDialogExample
extends Application {
    private TextField textFld;
    private Text actionStatus;
    private static final String titleTxt = "JavaFX Dialogs Example";

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle(titleTxt);
        Label label = new Label("Alert Dialogs");
        label.setTextFill((Paint)Color.DARKBLUE);
        label.setFont(Font.font((String)"Calibri", (FontWeight)FontWeight.BOLD, (double)36.0));
        HBox labelHb = new HBox();
        labelHb.setAlignment(Pos.CENTER);
        labelHb.getChildren().add((Object)label);
        Label txtLbl = new Label("A Text field:");
        txtLbl.setFont(Font.font((String)"Calibri", (FontWeight)FontWeight.NORMAL, (double)20.0));
        this.textFld = new TextField();
        this.textFld.setMinHeight(30.0);
        this.textFld.setPromptText("Enter some text and save.");
        this.textFld.setPrefColumnCount(15);
        HBox hbox = new HBox();
        hbox.setSpacing(10.0);
        hbox.getChildren().addAll((Object[])new Node[]{txtLbl, this.textFld});
        Button infobtn = new Button("Info");
        infobtn.setOnAction((EventHandler)new InfoButtonListener());
        Button savebtn = new Button("Save");
        savebtn.setOnAction((EventHandler)new SaveButtonListener());
        Button clearbtn = new Button("Clear");
        clearbtn.setOnAction((EventHandler)new ClearButtonListener());
        HBox buttonHb = new HBox(10.0);
        buttonHb.setAlignment(Pos.CENTER);
        buttonHb.getChildren().addAll((Object[])new Node[]{infobtn, savebtn, clearbtn});
        this.actionStatus = new Text();
        this.actionStatus.setFont(Font.font((String)"Calibri", (FontWeight)FontWeight.NORMAL, (double)20.0));
        this.actionStatus.setFill((Paint)Color.FIREBRICK);
        VBox vbox = new VBox(30.0);
        vbox.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        vbox.getChildren().addAll((Object[])new Node[]{labelHb, hbox, buttonHb, this.actionStatus});
        Scene scene = new Scene((Parent)vbox, 500.0, 300.0);
        primaryStage.setScene(scene);
        primaryStage.show();
        this.actionStatus.setText("An example of Alert Dialogs. Enter some text and save.");
        infobtn.requestFocus();
    }

    private class ClearButtonListener
    implements EventHandler<ActionEvent> {
        private ClearButtonListener() {
        }

        public void handle(ActionEvent e) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle(AlertDialogExample.titleTxt);
            String s = "Confirm to clear text in text field ! ";
            alert.setContentText(s);
            Optional result = alert.showAndWait();
            if (result.isPresent() && result.get() == ButtonType.OK) {
                AlertDialogExample.this.textFld.setText("");
                AlertDialogExample.this.actionStatus.setText("An example of Alert Dialogs. Enter some text and save.");
                AlertDialogExample.this.textFld.requestFocus();
            }
        }
    }

    private class SaveButtonListener
    implements EventHandler<ActionEvent> {
        private SaveButtonListener() {
        }

        public void handle(ActionEvent e) {
            String txt = AlertDialogExample.this.textFld.getText().trim();
            String msg = "Text saved: ";
            boolean valid = true;
            if (txt.isEmpty() || txt.length() < 5) {
                valid = false;
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle(AlertDialogExample.titleTxt);
                String s = "Text should be at least 5 characters long. Enter valid text and save. ";
                alert.setContentText(s);
                alert.showAndWait();
                msg = "Invalid text entered: ";
            }
            AlertDialogExample.this.actionStatus.setText(msg + txt);
            if (!valid) {
                AlertDialogExample.this.textFld.requestFocus();
            }
        }
    }

    private class InfoButtonListener
    implements EventHandler<ActionEvent> {
        private InfoButtonListener() {
        }

        public void handle(ActionEvent e) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle(AlertDialogExample.titleTxt);
            alert.setHeaderText("Information Alert");
            String s = "This is an example of JavaFX 8 Dialogs. This is an Alert Dialog of Alert type - INFORMATION. \n \nOther Alert types are: CONFIRMATION, ERROR, NONE and WARNING.";
            alert.setContentText(s);
            alert.show();
        }
    }
}

