/*
 * Decompiled with CFR 0.152.
 */
package mprj.webdesktop.tests;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class ChoiceDialogExample
extends Application {
    private ChoiceDialog<String> dialog;
    private Text actionStatus;
    private final String[] arrayData = new String[]{"First", "Second", "Third", "Fourth"};
    private List<String> dialogData;
    private static final String titleTxt = "JavaFX Dialogs Example";

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle(titleTxt);
        Label label = new Label("Choice Dialog");
        label.setTextFill((Paint)Color.DARKBLUE);
        label.setFont(Font.font((String)"Calibri", (FontWeight)FontWeight.BOLD, (double)36.0));
        HBox labelHb = new HBox();
        labelHb.setAlignment(Pos.CENTER);
        labelHb.getChildren().add((Object)label);
        Button choicebtn = new Button("Get Choice");
        choicebtn.setOnAction((EventHandler)new ChoiceButtonListener());
        HBox buttonHb = new HBox(10.0);
        buttonHb.setAlignment(Pos.CENTER);
        buttonHb.getChildren().addAll((Object[])new Node[]{choicebtn});
        this.actionStatus = new Text();
        this.actionStatus.setFont(Font.font((String)"Calibri", (FontWeight)FontWeight.NORMAL, (double)20.0));
        this.actionStatus.setFill((Paint)Color.FIREBRICK);
        VBox vbox = new VBox(30.0);
        vbox.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        vbox.getChildren().addAll((Object[])new Node[]{labelHb, buttonHb, this.actionStatus});
        Scene scene = new Scene((Parent)vbox, 500.0, 250.0);
        primaryStage.setScene(scene);
        primaryStage.show();
        this.dialogData = Arrays.asList(this.arrayData);
        this.displayChoiceDialog();
    }

    private void displayChoiceDialog() {
        this.dialog = new ChoiceDialog((Object)this.dialogData.get(0), this.dialogData);
        this.dialog.setTitle(titleTxt);
        this.dialog.setHeaderText("Select your choice");
        Optional result = this.dialog.showAndWait();
        String selected = "cancelled.";
        if (result.isPresent()) {
            selected = (String)result.get();
        }
        this.actionStatus.setText("Selection: " + selected);
    }

    private class ChoiceButtonListener
    implements EventHandler<ActionEvent> {
        private ChoiceButtonListener() {
        }

        public void handle(ActionEvent e) {
            ChoiceDialogExample.this.actionStatus.setText("");
            ChoiceDialogExample.this.displayChoiceDialog();
        }
    }
}

