/*
 * Decompiled with CFR 0.152.
 */
package mprj.webdesktop.tests;

import java.util.Optional;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Callback;

public class DialogExample
extends Application {
    private Text actionStatus;
    private static final String titleTxt = "JavaFX Dialogs Example";

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle(titleTxt);
        Label label = new Label("A Dialog");
        label.setTextFill((Paint)Color.DARKBLUE);
        label.setFont(Font.font((String)"Calibri", (FontWeight)FontWeight.BOLD, (double)36.0));
        HBox labelHb = new HBox();
        labelHb.setAlignment(Pos.CENTER);
        labelHb.getChildren().add((Object)label);
        Button btn = new Button("Click to Show Dialog");
        btn.setOnAction((EventHandler)new DialogButtonListener());
        HBox buttonHb = new HBox(10.0);
        buttonHb.setAlignment(Pos.CENTER);
        buttonHb.getChildren().addAll((Object[])new Node[]{btn});
        this.actionStatus = new Text();
        this.actionStatus.setFont(Font.font((String)"Calibri", (FontWeight)FontWeight.NORMAL, (double)20.0));
        this.actionStatus.setFill((Paint)Color.FIREBRICK);
        VBox vbox = new VBox(30.0);
        vbox.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        vbox.getChildren().addAll((Object[])new Node[]{labelHb, buttonHb, this.actionStatus});
        Scene scene = new Scene((Parent)vbox, 500.0, 250.0);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    private void displayDialog() {
        this.actionStatus.setText("");
        Dialog dialog = new Dialog();
        dialog.setTitle(titleTxt);
        dialog.setHeaderText("This is a dialog. Enter info and \npress Okay (or click title bar 'X' for cancel).");
        dialog.setResizable(true);
        Label label1 = new Label("Name: ");
        Label label2 = new Label("Phone: ");
        final TextField text1 = new TextField();
        final TextField text2 = new TextField();
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 35.0, 20.0, 35.0));
        grid.add((Node)label1, 1, 1);
        grid.add((Node)text1, 2, 1);
        grid.add((Node)label2, 1, 2);
        grid.add((Node)text2, 2, 2);
        dialog.getDialogPane().setContent((Node)grid);
        final ButtonType buttonTypeOk = new ButtonType("Okay", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().add((Object)buttonTypeOk);
        dialog.setResultConverter((Callback)new Callback<ButtonType, PhoneBook>(){

            public PhoneBook call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return new PhoneBook(text1.getText(), text2.getText());
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            this.actionStatus.setText("Result: " + result.get());
        }
    }

    private class PhoneBook {
        private String name;
        private String phone;

        PhoneBook(String s1, String s2) {
            this.name = s1;
            this.phone = s2;
        }

        public String toString() {
            return this.name + ", " + this.phone;
        }
    }

    private class DialogButtonListener
    implements EventHandler<ActionEvent> {
        private DialogButtonListener() {
        }

        public void handle(ActionEvent e) {
            DialogExample.this.displayDialog();
        }
    }
}

