/*
 * Decompiled with CFR 0.152.
 */
package mprj.webdesktop.tests;

import java.util.Optional;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class TextDialogExample
extends Application {
    private TextInputDialog dialog;
    private Text actionStatus;
    private final String defaultVal = "Default text";
    private static final String titleTxt = "JavaFX Dialogs Example";

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        primaryStage.setTitle(titleTxt);
        Label label = new Label("Text Input Dialog");
        label.setTextFill((Paint)Color.DARKBLUE);
        label.setFont(Font.font((String)"Calibri", (FontWeight)FontWeight.BOLD, (double)36.0));
        HBox labelHb = new HBox();
        labelHb.setAlignment(Pos.CENTER);
        labelHb.getChildren().add((Object)label);
        Button textbtn = new Button("Get Text");
        textbtn.setOnAction((EventHandler)new TextButtonListener());
        HBox buttonHb = new HBox(10.0);
        buttonHb.setAlignment(Pos.CENTER);
        buttonHb.getChildren().addAll((Object[])new Node[]{textbtn});
        this.actionStatus = new Text();
        this.actionStatus.setFont(Font.font((String)"Calibri", (FontWeight)FontWeight.NORMAL, (double)20.0));
        this.actionStatus.setFill((Paint)Color.FIREBRICK);
        VBox vbox = new VBox(30.0);
        vbox.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        vbox.getChildren().addAll((Object[])new Node[]{labelHb, buttonHb, this.actionStatus});
        Scene scene = new Scene((Parent)vbox, 500.0, 250.0);
        primaryStage.setScene(scene);
        primaryStage.show();
        this.displayTextDialog();
    }

    private void displayTextDialog() {
        this.dialog = new TextInputDialog("Default text");
        this.dialog.setTitle(titleTxt);
        this.dialog.setHeaderText("Enter some text, or use default value.");
        Optional result = this.dialog.showAndWait();
        String entered = "none.";
        if (result.isPresent()) {
            entered = (String)result.get();
        }
        this.actionStatus.setText("Text entered: " + entered);
    }

    private class TextButtonListener
    implements EventHandler<ActionEvent> {
        private TextButtonListener() {
        }

        public void handle(ActionEvent e) {
            TextDialogExample.this.actionStatus.setText("");
            TextDialogExample.this.displayTextDialog();
        }
    }
}

