/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserFactory;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.callback.CefDragData;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefRequestCallback;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceHandler;
import org.cef.handler.CefWindowHandler;
import org.cef.misc.BoolRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.cef.network.CefURLRequest;

public class CefClient
extends CefClientHandler
implements CefContextMenuHandler,
CefDialogHandler,
CefDisplayHandler,
CefDownloadHandler,
CefDragHandler,
CefFocusHandler,
CefJSDialogHandler,
CefKeyboardHandler,
CefLifeSpanHandler,
CefLoadHandler,
CefRenderHandler,
CefRequestHandler,
CefWindowHandler {
    public HashMap<Integer, CefBrowser> browser_ = new HashMap();
    public CefContextMenuHandler contextMenuHandler_ = null;
    public CefDialogHandler dialogHandler_ = null;
    public CefDisplayHandler displayHandler_ = null;
    public CefDownloadHandler downloadHandler_ = null;
    public CefDragHandler dragHandler_ = null;
    public CefFocusHandler focusHandler_ = null;
    public CefJSDialogHandler jsDialogHandler_ = null;
    public CefKeyboardHandler keyboardHandler_ = null;
    public CefLifeSpanHandler lifeSpanHandler_ = null;
    public CefLoadHandler loadHandler_ = null;
    public CefRequestHandler requestHandler_ = null;
    public boolean isDisposed_ = false;
    public volatile CefBrowser focusedBrowser_ = null;

    CefClient() throws UnsatisfiedLinkError {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (CefClient.this.focusedBrowser_ != null) {
                    Component component = CefClient.this.focusedBrowser_.getUIComponent();
                    Object object = propertyChangeEvent.getOldValue();
                    if (CefClient.this.isPartOf(object, component)) {
                        CefClient.this.focusedBrowser_.setFocus(false);
                        CefClient.this.focusedBrowser_ = null;
                    }
                }
            }
        });
    }

    public boolean isPartOf(Object object, Component component) {
        Component[] componentArray;
        Component[] componentArray2;
        int n;
        int n2;
        if (object == component) {
            return true;
        }
        if (object instanceof Container && (n2 = 0) < (n = (componentArray2 = (componentArray = ((Container)object).getComponents())).length)) {
            Component component2 = componentArray2[n2];
            return this.isPartOf(component2, component);
        }
        return false;
    }

    @Override
    public void dispose() {
        this.isDisposed_ = true;
        this.cleanupBrowser(-1);
    }

    public CefBrowser createBrowser(String string, boolean bl, boolean bl2) {
        return this.createBrowser(string, bl, bl2, null);
    }

    public CefBrowser createBrowser(String string, boolean bl, boolean bl2, CefRequestContext cefRequestContext) {
        if (this.isDisposed_) {
            throw new IllegalStateException("Can't create browser. CefClient is disposed");
        }
        return CefBrowserFactory.create(this, string, bl, bl2, cefRequestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CefBrowser getBrowser(int n) {
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            return this.browser_.get(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getAllBrowser() {
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            return this.browser_.values().toArray();
        }
    }

    @Override
    public CefContextMenuHandler getContextMenuHandler() {
        return this;
    }

    @Override
    public CefDialogHandler getDialogHandler() {
        return this;
    }

    @Override
    public CefDisplayHandler getDisplayHandler() {
        return this;
    }

    @Override
    public CefDownloadHandler getDownloadHandler() {
        return this;
    }

    @Override
    public CefDragHandler getDragHandler() {
        return this;
    }

    @Override
    public CefFocusHandler getFocusHandler() {
        return this;
    }

    @Override
    public CefJSDialogHandler getJSDialogHandler() {
        return this;
    }

    @Override
    public CefKeyboardHandler getKeyboardHandler() {
        return this;
    }

    @Override
    public CefLifeSpanHandler getLifeSpanHandler() {
        return this;
    }

    @Override
    public CefLoadHandler getLoadHandler() {
        return this;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    public CefRequestHandler getRequestHandler() {
        return this;
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return this;
    }

    public CefClient addContextMenuHandler(CefContextMenuHandler cefContextMenuHandler) {
        if (this.contextMenuHandler_ == null) {
            this.contextMenuHandler_ = cefContextMenuHandler;
        }
        return this;
    }

    public void removeContextMenuHandler() {
        this.contextMenuHandler_ = null;
    }

    @Override
    public void onBeforeContextMenu(CefBrowser cefBrowser, CefFrame cefFrame, CefContextMenuParams cefContextMenuParams, CefMenuModel cefMenuModel) {
        if (this.contextMenuHandler_ != null && cefBrowser != null) {
            this.contextMenuHandler_.onBeforeContextMenu(cefBrowser, cefFrame, cefContextMenuParams, cefMenuModel);
        }
    }

    @Override
    public boolean onContextMenuCommand(CefBrowser cefBrowser, CefFrame cefFrame, CefContextMenuParams cefContextMenuParams, int n, int n2) {
        if (this.contextMenuHandler_ != null && cefBrowser != null) {
            return this.contextMenuHandler_.onContextMenuCommand(cefBrowser, cefFrame, cefContextMenuParams, n, n2);
        }
        return false;
    }

    @Override
    public void onContextMenuDismissed(CefBrowser cefBrowser, CefFrame cefFrame) {
        if (this.contextMenuHandler_ != null && cefBrowser != null) {
            this.contextMenuHandler_.onContextMenuDismissed(cefBrowser, cefFrame);
        }
    }

    public CefClient addDialogHandler(CefDialogHandler cefDialogHandler) {
        if (this.dialogHandler_ == null) {
            this.dialogHandler_ = cefDialogHandler;
        }
        return this;
    }

    public void removeDialogHandler() {
        this.dialogHandler_ = null;
    }

    @Override
    public boolean onFileDialog(CefBrowser cefBrowser, CefDialogHandler.FileDialogMode fileDialogMode, String string, String string2, Vector<String> vector, int n, CefFileDialogCallback cefFileDialogCallback) {
        if (this.dialogHandler_ != null && cefBrowser != null) {
            return this.dialogHandler_.onFileDialog(cefBrowser, fileDialogMode, string, string2, vector, n, cefFileDialogCallback);
        }
        return false;
    }

    public CefClient addDisplayHandler(CefDisplayHandler cefDisplayHandler) {
        if (this.displayHandler_ == null) {
            this.displayHandler_ = cefDisplayHandler;
        }
        return this;
    }

    public void removeDisplayHandler() {
        this.displayHandler_ = null;
    }

    @Override
    public void onAddressChange(CefBrowser cefBrowser, CefFrame cefFrame, String string) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            this.displayHandler_.onAddressChange(cefBrowser, cefFrame, string);
        }
    }

    @Override
    public void onTitleChange(CefBrowser cefBrowser, String string) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            this.displayHandler_.onTitleChange(cefBrowser, string);
        }
    }

    @Override
    public boolean onTooltip(CefBrowser cefBrowser, String string) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            return this.displayHandler_.onTooltip(cefBrowser, string);
        }
        return false;
    }

    @Override
    public void onStatusMessage(CefBrowser cefBrowser, String string) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            this.displayHandler_.onStatusMessage(cefBrowser, string);
        }
    }

    @Override
    public boolean onConsoleMessage(CefBrowser cefBrowser, CefSettings.LogSeverity logSeverity, String string, String string2, int n) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            return this.displayHandler_.onConsoleMessage(cefBrowser, logSeverity, string, string2, n);
        }
        return false;
    }

    public CefClient addDownloadHandler(CefDownloadHandler cefDownloadHandler) {
        if (this.downloadHandler_ == null) {
            this.downloadHandler_ = cefDownloadHandler;
        }
        return this;
    }

    public void removeDownloadHandler() {
        this.downloadHandler_ = null;
    }

    @Override
    public void onBeforeDownload(CefBrowser cefBrowser, CefDownloadItem cefDownloadItem, String string, CefBeforeDownloadCallback cefBeforeDownloadCallback) {
        if (this.downloadHandler_ != null && cefBrowser != null) {
            this.downloadHandler_.onBeforeDownload(cefBrowser, cefDownloadItem, string, cefBeforeDownloadCallback);
        }
    }

    @Override
    public void onDownloadUpdated(CefBrowser cefBrowser, CefDownloadItem cefDownloadItem, CefDownloadItemCallback cefDownloadItemCallback) {
        if (this.downloadHandler_ != null && cefBrowser != null) {
            this.downloadHandler_.onDownloadUpdated(cefBrowser, cefDownloadItem, cefDownloadItemCallback);
        }
    }

    public CefClient addDragHandler(CefDragHandler cefDragHandler) {
        if (this.dragHandler_ == null) {
            this.dragHandler_ = cefDragHandler;
        }
        return this;
    }

    public void removeDragHandler() {
        this.dragHandler_ = null;
    }

    @Override
    public boolean onDragEnter(CefBrowser cefBrowser, CefDragData cefDragData, int n) {
        if (this.dragHandler_ != null && cefBrowser != null) {
            return this.dragHandler_.onDragEnter(cefBrowser, cefDragData, n);
        }
        return false;
    }

    public CefClient addFocusHandler(CefFocusHandler cefFocusHandler) {
        if (this.focusHandler_ == null) {
            this.focusHandler_ = cefFocusHandler;
        }
        return this;
    }

    public void removeFocusHandler() {
        this.focusHandler_ = null;
    }

    @Override
    public void onTakeFocus(CefBrowser cefBrowser, boolean bl) {
        Container container;
        if (cefBrowser == null) {
            return;
        }
        cefBrowser.setFocus(false);
        if (container != null) {
            FocusTraversalPolicy focusTraversalPolicy = null;
            for (container = cefBrowser.getUIComponent().getParent(); container != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) == null; container = container.getParent()) {
            }
            if (focusTraversalPolicy != null) {
                Component component;
                Component component2 = component = bl ? focusTraversalPolicy.getComponentAfter(container, cefBrowser.getUIComponent()) : focusTraversalPolicy.getComponentBefore(container, cefBrowser.getUIComponent());
                if (component == null) {
                    focusTraversalPolicy.getDefaultComponent(container).requestFocus();
                } else {
                    component.requestFocus();
                }
            }
        }
        this.focusedBrowser_ = null;
        if (this.focusHandler_ != null) {
            this.focusHandler_.onTakeFocus(cefBrowser, bl);
        }
    }

    @Override
    public boolean onSetFocus(final CefBrowser cefBrowser, CefFocusHandler.FocusSource focusSource) {
        if (cefBrowser == null) {
            return false;
        }
        boolean bl = false;
        if (this.focusHandler_ != null) {
            bl = this.focusHandler_.onSetFocus(cefBrowser, focusSource);
        }
        if (!bl) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Component component = cefBrowser.getUIComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        return bl;
    }

    @Override
    public void onGotFocus(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return;
        }
        this.focusedBrowser_ = cefBrowser;
        cefBrowser.setFocus(true);
        if (this.focusHandler_ != null) {
            this.focusHandler_.onGotFocus(cefBrowser);
        }
    }

    public CefClient addJSDialogHandler(CefJSDialogHandler cefJSDialogHandler) {
        if (this.jsDialogHandler_ == null) {
            this.jsDialogHandler_ = cefJSDialogHandler;
        }
        return this;
    }

    public void removeJSDialogHandler() {
        this.jsDialogHandler_ = null;
    }

    @Override
    public boolean onJSDialog(CefBrowser cefBrowser, String string, CefJSDialogHandler.JSDialogType jSDialogType, String string2, String string3, CefJSDialogCallback cefJSDialogCallback, BoolRef boolRef) {
        if (this.jsDialogHandler_ != null && cefBrowser != null) {
            return this.jsDialogHandler_.onJSDialog(cefBrowser, string, jSDialogType, string2, string3, cefJSDialogCallback, boolRef);
        }
        return false;
    }

    @Override
    public boolean onBeforeUnloadDialog(CefBrowser cefBrowser, String string, boolean bl, CefJSDialogCallback cefJSDialogCallback) {
        if (this.jsDialogHandler_ != null && cefBrowser != null) {
            return this.jsDialogHandler_.onBeforeUnloadDialog(cefBrowser, string, bl, cefJSDialogCallback);
        }
        return false;
    }

    @Override
    public void onResetDialogState(CefBrowser cefBrowser) {
        if (this.jsDialogHandler_ != null && cefBrowser != null) {
            this.jsDialogHandler_.onResetDialogState(cefBrowser);
        }
    }

    @Override
    public void onDialogClosed(CefBrowser cefBrowser) {
        if (this.jsDialogHandler_ != null && cefBrowser != null) {
            this.jsDialogHandler_.onDialogClosed(cefBrowser);
        }
    }

    public CefClient addKeyboardHandler(CefKeyboardHandler cefKeyboardHandler) {
        if (this.keyboardHandler_ == null) {
            this.keyboardHandler_ = cefKeyboardHandler;
        }
        return this;
    }

    public void removeKeyboardHandler() {
        this.keyboardHandler_ = null;
    }

    @Override
    public boolean onPreKeyEvent(CefBrowser cefBrowser, CefKeyboardHandler.CefKeyEvent cefKeyEvent, BoolRef boolRef) {
        if (this.keyboardHandler_ != null && cefBrowser != null) {
            return this.keyboardHandler_.onPreKeyEvent(cefBrowser, cefKeyEvent, boolRef);
        }
        return false;
    }

    @Override
    public boolean onKeyEvent(CefBrowser cefBrowser, CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
        if (this.keyboardHandler_ != null && cefBrowser != null) {
            return this.keyboardHandler_.onKeyEvent(cefBrowser, cefKeyEvent);
        }
        return false;
    }

    public CefClient addLifeSpanHandler(CefLifeSpanHandler cefLifeSpanHandler) {
        if (this.lifeSpanHandler_ == null) {
            this.lifeSpanHandler_ = cefLifeSpanHandler;
        }
        return this;
    }

    public void removeLifeSpanHandler() {
        this.lifeSpanHandler_ = null;
    }

    @Override
    public boolean onBeforePopup(CefBrowser cefBrowser, CefFrame cefFrame, String string, String string2) {
        if (this.isDisposed_) {
            return true;
        }
        if (this.lifeSpanHandler_ != null && cefBrowser != null) {
            return this.lifeSpanHandler_.onBeforePopup(cefBrowser, cefFrame, string, string2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterCreated(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return;
        }
        Integer n = cefBrowser.getIdentifier();
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            this.browser_.put(n, cefBrowser);
        }
        if (this.lifeSpanHandler_ != null) {
            this.lifeSpanHandler_.onAfterCreated(cefBrowser);
        }
    }

    @Override
    public boolean doClose(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return false;
        }
        if (this.lifeSpanHandler_ != null) {
            return this.lifeSpanHandler_.doClose(cefBrowser);
        }
        return cefBrowser.doClose();
    }

    @Override
    public void onBeforeClose(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return;
        }
        if (this.lifeSpanHandler_ != null) {
            this.lifeSpanHandler_.onBeforeClose(cefBrowser);
        }
        cefBrowser.onBeforeClose();
        this.cleanupBrowser(cefBrowser.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupBrowser(int n) {
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            if (n >= 0) {
                this.browser_.remove(n);
            } else if (!this.browser_.isEmpty()) {
                Collection<CefBrowser> collection = this.browser_.values();
                for (CefBrowser cefBrowser : collection) {
                    cefBrowser.close(true);
                }
                return;
            }
            if (this.browser_.isEmpty() && this.isDisposed_) {
                this.removeContextMenuHandler(this);
                this.removeDialogHandler(this);
                this.removeDisplayHandler(this);
                this.removeDownloadHandler(this);
                this.removeDragHandler(this);
                this.removeFocusHandler(this);
                this.removeJSDialogHandler(this);
                this.removeKeyboardHandler(this);
                this.removeLifeSpanHandler(this);
                this.removeLoadHandler(this);
                this.removeRenderHandler(this);
                this.removeRequestHandler(this);
                this.removeWindowHandler(this);
                super.dispose();
                CefApp.getInstance().clientWasDisposed(this);
            }
        }
    }

    public CefClient addLoadHandler(CefLoadHandler cefLoadHandler) {
        if (this.loadHandler_ == null) {
            this.loadHandler_ = cefLoadHandler;
        }
        return this;
    }

    public void removeLoadHandler() {
        this.loadHandler_ = null;
    }

    @Override
    public void onLoadingStateChange(CefBrowser cefBrowser, boolean bl, boolean bl2, boolean bl3) {
        if (this.loadHandler_ != null && cefBrowser != null) {
            this.loadHandler_.onLoadingStateChange(cefBrowser, bl, bl2, bl3);
        }
    }

    @Override
    public void onLoadStart(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest.TransitionType transitionType) {
        if (this.loadHandler_ != null && cefBrowser != null) {
            this.loadHandler_.onLoadStart(cefBrowser, cefFrame, transitionType);
        }
    }

    @Override
    public void onLoadEnd(CefBrowser cefBrowser, CefFrame cefFrame, int n) {
        if (this.loadHandler_ != null && cefBrowser != null) {
            this.loadHandler_.onLoadEnd(cefBrowser, cefFrame, n);
        }
    }

    @Override
    public void onLoadError(CefBrowser cefBrowser, CefFrame cefFrame, CefLoadHandler.ErrorCode errorCode, String string, String string2) {
        if (this.loadHandler_ != null && cefBrowser != null) {
            this.loadHandler_.onLoadError(cefBrowser, cefFrame, errorCode, string, string2);
        }
    }

    @Override
    public synchronized void addMessageRouter(CefMessageRouter cefMessageRouter) {
        super.addMessageRouter(cefMessageRouter);
    }

    @Override
    public synchronized void removeMessageRouter(CefMessageRouter cefMessageRouter) {
        super.removeMessageRouter(cefMessageRouter);
    }

    @Override
    public Rectangle getViewRect(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            return cefRenderHandler.getViewRect(cefBrowser);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public Point getScreenPoint(CefBrowser cefBrowser, Point point) {
        if (cefBrowser == null) {
            return new Point(0, 0);
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            return cefRenderHandler.getScreenPoint(cefBrowser, point);
        }
        return new Point(0, 0);
    }

    @Override
    public void onPopupShow(CefBrowser cefBrowser, boolean bl) {
        if (cefBrowser == null) {
            return;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            cefRenderHandler.onPopupShow(cefBrowser, bl);
        }
    }

    @Override
    public void onPopupSize(CefBrowser cefBrowser, Rectangle rectangle) {
        if (cefBrowser == null) {
            return;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            cefRenderHandler.onPopupSize(cefBrowser, rectangle);
        }
    }

    @Override
    public void onPaint(CefBrowser cefBrowser, boolean bl, Rectangle[] rectangleArray, ByteBuffer byteBuffer, int n, int n2) {
        if (cefBrowser == null) {
            return;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            cefRenderHandler.onPaint(cefBrowser, bl, rectangleArray, byteBuffer, n, n2);
        }
    }

    @Override
    public void onCursorChange(CefBrowser cefBrowser, int n) {
        if (cefBrowser == null) {
            return;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            cefRenderHandler.onCursorChange(cefBrowser, n);
        }
    }

    @Override
    public boolean startDragging(CefBrowser cefBrowser, CefDragData cefDragData, int n, int n2, int n3) {
        if (cefBrowser == null) {
            return false;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            return cefRenderHandler.startDragging(cefBrowser, cefDragData, n, n2, n3);
        }
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser cefBrowser, int n) {
        if (cefBrowser == null) {
            return;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            cefRenderHandler.updateDragCursor(cefBrowser, n);
        }
    }

    public CefClient addRequestHandler(CefRequestHandler cefRequestHandler) {
        if (this.requestHandler_ == null) {
            this.requestHandler_ = cefRequestHandler;
        }
        return this;
    }

    public void removeRequestHandler() {
        this.requestHandler_ = null;
    }

    @Override
    public boolean onBeforeBrowse(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest cefRequest, boolean bl, boolean bl2) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            return this.requestHandler_.onBeforeBrowse(cefBrowser, cefFrame, cefRequest, bl, bl2);
        }
        return false;
    }

    @Override
    public boolean onBeforeResourceLoad(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest cefRequest) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            return this.requestHandler_.onBeforeResourceLoad(cefBrowser, cefFrame, cefRequest);
        }
        return false;
    }

    @Override
    public CefResourceHandler getResourceHandler(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest cefRequest) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            return this.requestHandler_.getResourceHandler(cefBrowser, cefFrame, cefRequest);
        }
        return null;
    }

    @Override
    public void onResourceRedirect(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest cefRequest, CefResponse cefResponse, StringRef stringRef) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            this.requestHandler_.onResourceRedirect(cefBrowser, cefFrame, cefRequest, cefResponse, stringRef);
        }
    }

    @Override
    public boolean onResourceResponse(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest cefRequest, CefResponse cefResponse) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            return this.requestHandler_.onResourceResponse(cefBrowser, cefFrame, cefRequest, cefResponse);
        }
        return false;
    }

    @Override
    public void onResourceLoadComplete(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest cefRequest, CefResponse cefResponse, CefURLRequest.Status status, long l) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            this.requestHandler_.onResourceLoadComplete(cefBrowser, cefFrame, cefRequest, cefResponse, status, l);
        }
    }

    @Override
    public boolean getAuthCredentials(CefBrowser cefBrowser, CefFrame cefFrame, boolean bl, String string, int n, String string2, String string3, CefAuthCallback cefAuthCallback) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            return this.requestHandler_.getAuthCredentials(cefBrowser, cefFrame, bl, string, n, string2, string3, cefAuthCallback);
        }
        return false;
    }

    @Override
    public boolean onQuotaRequest(CefBrowser cefBrowser, String string, long l, CefRequestCallback cefRequestCallback) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            return this.requestHandler_.onQuotaRequest(cefBrowser, string, l, cefRequestCallback);
        }
        return false;
    }

    @Override
    public void onProtocolExecution(CefBrowser cefBrowser, String string, BoolRef boolRef) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            this.requestHandler_.onProtocolExecution(cefBrowser, string, boolRef);
        }
    }

    @Override
    public boolean onCertificateError(CefBrowser cefBrowser, CefLoadHandler.ErrorCode errorCode, String string, CefRequestCallback cefRequestCallback) {
        if (this.requestHandler_ != null) {
            return this.requestHandler_.onCertificateError(cefBrowser, errorCode, string, cefRequestCallback);
        }
        return false;
    }

    @Override
    public void onPluginCrashed(CefBrowser cefBrowser, String string) {
        if (this.requestHandler_ != null) {
            this.requestHandler_.onPluginCrashed(cefBrowser, string);
        }
    }

    @Override
    public void onRenderProcessTerminated(CefBrowser cefBrowser, CefRequestHandler.TerminationStatus terminationStatus) {
        if (this.requestHandler_ != null) {
            this.requestHandler_.onRenderProcessTerminated(cefBrowser, terminationStatus);
        }
    }

    @Override
    public Rectangle getRect(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        CefWindowHandler cefWindowHandler = cefBrowser.getWindowHandler();
        if (cefWindowHandler != null) {
            return cefWindowHandler.getRect(cefBrowser);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public void onMouseEvent(CefBrowser cefBrowser, int n, int n2, int n3, int n4, int n5) {
        if (cefBrowser == null) {
            return;
        }
        CefWindowHandler cefWindowHandler = cefBrowser.getWindowHandler();
        if (cefWindowHandler != null) {
            cefWindowHandler.onMouseEvent(cefBrowser, n, n2, n3, n4, n5);
        }
    }
}

