/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture;

import java.util.ArrayList;
import java.util.List;
import org.panda_lang.panda.framework.PandaFramework;
import org.panda_lang.panda.framework.design.architecture.Application;
import org.panda_lang.panda.framework.design.architecture.Script;
import org.panda_lang.panda.framework.design.architecture.dynamic.block.main.MainScope;
import org.panda_lang.panda.framework.language.runtime.PandaExecutableProcess;
import org.panda_lang.panda.utilities.commons.objects.TimeUtils;

public class PandaApplication
implements Application {
    protected final List<Script> scripts = new ArrayList<Script>();
    protected String workingDirectory;
    protected String[] arguments;

    @Override
    public void launch() {
        for (Script script : this.scripts) {
            List<MainScope> mains = script.select(MainScope.class);
            if (mains.size() == 1) {
                MainScope main = mains.get(0);
                PandaExecutableProcess process = new PandaExecutableProcess(this, main, this.arguments);
                PandaFramework.getLogger().info("[PandaApp] Launching application...");
                long initTime = System.nanoTime();
                process.execute();
                long uptime = System.nanoTime() - initTime;
                PandaFramework.getLogger().info("[PandaApp] Done (" + TimeUtils.toMilliseconds(uptime) + ")");
                return;
            }
            if (mains.size() <= 1) continue;
            throw new RuntimeException("Duplicated main statement");
        }
        throw new RuntimeException("Main statement not found");
    }

    public void addScript(Script script) {
        this.scripts.add(script);
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void setApplicationArguments(String ... arguments) {
        this.arguments = arguments;
    }

    @Override
    public List<Script> getScripts() {
        return this.scripts;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }
}

