/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.design.architecture.prototype;

import java.util.Collection;
import org.panda_lang.panda.framework.design.architecture.module.ModuleLoader;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;

public class PandaClassPrototypeUtils {
    public static boolean hasCommonClasses(Collection<Class<?>> fromClasses, Collection<Class<?>> toClasses) {
        for (Class<?> a : fromClasses) {
            for (Class<?> b : toClasses) {
                if (a == b) {
                    return true;
                }
                if (!PandaClassPrototypeUtils.isAssociatedWith(a, b)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCommonPrototypes(Collection<ClassPrototype> fromPrototypes, Collection<ClassPrototype> toPrototypes) {
        for (ClassPrototype a : fromPrototypes) {
            for (ClassPrototype b : toPrototypes) {
                if (a.equals(b)) {
                    return true;
                }
                if (!PandaClassPrototypeUtils.isAssociatedWith(a.getAssociated(), b.getAssociated())) continue;
                return true;
            }
        }
        return false;
    }

    public static ClassPrototype[] toTypes(ModuleLoader loader, Class<?> ... types) {
        ClassPrototype[] prototypes = new ClassPrototype[types.length];
        for (int i = 0; i < types.length; ++i) {
            prototypes[i] = loader.forClass(types[i]);
        }
        return prototypes;
    }

    public static boolean isAssociatedWith(Class<?> a, Class<?> b) {
        return a != null && b != null && (a == b || b.isAssignableFrom(a));
    }
}

