/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.architecture.dynamic;

import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.architecture.dynamic.ScopeInstance;
import org.panda_lang.panda.framework.design.architecture.statement.Scope;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.language.runtime.PandaRuntimeException;

public abstract class AbstractScopeInstance<T extends Scope>
implements ScopeInstance {
    protected final T scope;
    protected final Value[] localMemory;

    protected AbstractScopeInstance(T scope, int localMemory) {
        this.scope = scope;
        this.localMemory = new Value[localMemory];
    }

    protected AbstractScopeInstance(T scope) {
        this(scope, scope.getVariables().size());
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.localMemory.length) {
            throw new PandaRuntimeException("Invalid variable index: " + index + "; Amount of localMemory: " + this.getAmountOfVariables());
        }
    }

    @Override
    public synchronized void set(int pointer, @Nullable Value value) {
        this.checkIndex(pointer);
        this.localMemory[pointer] = value;
    }

    @Override
    @Nullable
    public synchronized Value get(int pointer) {
        this.checkIndex(pointer);
        return this.localMemory[pointer];
    }

    @Override
    public int getAmountOfVariables() {
        return this.localMemory.length;
    }

    public T getScope() {
        return this.scope;
    }
}

