/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.architecture.Environment;
import org.panda_lang.panda.framework.design.interpreter.Interpretation;
import org.panda_lang.panda.framework.design.interpreter.Interpreter;
import org.panda_lang.panda.framework.design.interpreter.InterpreterFailure;
import org.panda_lang.panda.framework.design.interpreter.messenger.Messenger;
import org.panda_lang.panda.framework.language.Language;
import org.panda_lang.panda.framework.language.interpreter.messenger.PandaMessenger;
import org.panda_lang.panda.framework.language.interpreter.messenger.defaults.DefaultOutputListener;
import org.panda_lang.panda.framework.language.interpreter.messenger.translators.InterpreterFailureTranslator;
import org.panda_lang.panda.framework.language.interpreter.messenger.translators.PandaLexerFailureTranslator;

public class PandaInterpretation
implements Interpretation {
    private final Environment environment;
    private final Interpreter interpreter;
    private final Language language;
    private final Messenger messenger;
    private final Collection<InterpreterFailure> failures;

    public PandaInterpretation(Environment environment, Interpreter interpreter, Language language) {
        this.environment = environment;
        this.interpreter = interpreter;
        this.language = language;
        this.failures = new ArrayList<InterpreterFailure>(1);
        this.messenger = new PandaMessenger();
        this.messenger.addMessageTranslator(new PandaLexerFailureTranslator());
        this.messenger.addMessageTranslator(new InterpreterFailureTranslator(this));
        this.messenger.setOutputListener(new DefaultOutputListener());
    }

    @Override
    public Interpretation execute(Runnable runnable) {
        if (!this.isHealthy()) {
            return this;
        }
        try {
            runnable.run();
        }
        catch (Exception exception) {
            this.getMessenger().send(exception);
        }
        return this;
    }

    @Override
    @Nullable
    public <T> T execute(Supplier<T> callback) {
        try {
            return this.isHealthy() ? (T)callback.get() : null;
        }
        catch (Exception exception) {
            this.getMessenger().send(exception);
            return null;
        }
    }

    @Override
    public Collection<InterpreterFailure> getFailures() {
        return this.failures;
    }

    @Override
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }
}

