/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.lexer;

import java.util.ArrayList;
import java.util.Collection;
import org.panda_lang.panda.framework.design.interpreter.lexer.Lexer;
import org.panda_lang.panda.framework.design.interpreter.source.Source;
import org.panda_lang.panda.framework.design.interpreter.token.Syntax;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.lexer.PandaLexerException;
import org.panda_lang.panda.framework.language.interpreter.lexer.PandaLexerSequencer;
import org.panda_lang.panda.framework.language.interpreter.lexer.PandaLexerTokenExtractor;
import org.panda_lang.panda.framework.language.interpreter.token.PandaTokenRepresentation;
import org.panda_lang.panda.framework.language.interpreter.token.PandaTokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.auxiliary.Indentation;
import org.panda_lang.panda.utilities.commons.objects.CharacterUtils;
import org.panda_lang.panda.utilities.commons.objects.StringUtils;

public class PandaLexer
implements Lexer {
    private final String title;
    private final String source;
    private final Collection<TokenRepresentation> tokenRepresentations;
    private final Collection<Token> tokenizedLine;
    private final Syntax syntax;
    private final StringBuilder tokenBuilder;
    private final PandaLexerTokenExtractor lexerTokenExtractor;
    private final PandaLexerSequencer lexerSequencer;
    private boolean includeIndentation;
    private boolean respectWhitespaces;
    private String linePreview;
    private String tokenPreview;
    private boolean previousSpecial;
    private int line;

    public PandaLexer(Syntax syntax, Source source) {
        String content = source.getContent();
        if (content == null) {
            throw new IllegalArgumentException("Source cannot be null");
        }
        if (content.isEmpty()) {
            throw new IllegalArgumentException("Source is empty");
        }
        this.syntax = syntax;
        this.source = content + System.lineSeparator();
        this.title = source.getTitle();
        this.tokenRepresentations = new ArrayList<TokenRepresentation>();
        this.tokenizedLine = new ArrayList<Token>();
        this.lexerTokenExtractor = new PandaLexerTokenExtractor(this);
        this.lexerSequencer = new PandaLexerSequencer(this, syntax.getSequences());
        this.tokenBuilder = new StringBuilder();
        this.includeIndentation = false;
        this.respectWhitespaces = true;
        this.tokenPreview = "";
        this.linePreview = "";
        this.previousSpecial = false;
        this.line = 0;
    }

    @Override
    public TokenizedSource convert() {
        char[] sourceCharArray;
        for (char c : sourceCharArray = this.source.toCharArray()) {
            this.next(c);
            this.checkLine();
        }
        TokenRepresentation[] representations = new TokenRepresentation[this.tokenRepresentations.size()];
        representations = this.tokenRepresentations.toArray(representations);
        return new PandaTokenizedSource(representations);
    }

    private void next(char c) {
        this.linePreview = this.linePreview + c;
        this.tokenPreview = this.tokenBuilder.toString();
        if (this.lexerSequencer.checkBefore(this.tokenBuilder, c)) {
            return;
        }
        if (this.respectWhitespaces && CharacterUtils.isWhitespace(c)) {
            boolean extracted = this.lexerTokenExtractor.extract(this.tokenBuilder);
            if (!extracted) {
                throw new PandaLexerException("Unknown token", this.tokenPreview, this.linePreview, this.title, this.line);
            }
            return;
        }
        this.check(c);
        this.tokenBuilder.append(c);
        this.lexerSequencer.checkAfter(this.tokenBuilder);
    }

    private void check(char c) {
        boolean special = CharacterUtils.belongsTo(c, this.syntax.getSpecialCharacters());
        if (this.previousSpecial && !special) {
            this.lexerTokenExtractor.extract(this.tokenBuilder);
        } else if (!this.previousSpecial && special) {
            this.lexerTokenExtractor.extract(this.tokenBuilder);
        }
        this.previousSpecial = special;
    }

    private void checkLine() {
        PandaTokenRepresentation representation;
        if (!this.linePreview.endsWith(System.lineSeparator())) {
            return;
        }
        if (this.includeIndentation) {
            String paragraph = StringUtils.extractParagraph(this.linePreview);
            Indentation indentation = Indentation.valueOf(paragraph);
            representation = new PandaTokenRepresentation(indentation, this.line);
            this.tokenRepresentations.add(representation);
        }
        for (Token token : this.tokenizedLine) {
            representation = new PandaTokenRepresentation(token, this.line);
            this.tokenRepresentations.add(representation);
        }
        this.tokenizedLine.clear();
        this.linePreview = "";
        ++this.line;
    }

    public void includeIndentation(boolean flag) {
        this.includeIndentation = flag;
    }

    public void respectWhitespaces(boolean flag) {
        this.respectWhitespaces = flag;
    }

    protected int getLine() {
        return this.line;
    }

    protected StringBuilder getTokenBuilder() {
        return this.tokenBuilder;
    }

    protected Syntax getSyntax() {
        return this.syntax;
    }

    protected Collection<Token> getTokenizedLine() {
        return this.tokenizedLine;
    }

    protected Collection<TokenRepresentation> getTokenRepresentations() {
        return this.tokenRepresentations;
    }

    public String getSource() {
        return this.source;
    }
}

