/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.lexer;

import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.interpreter.token.Syntax;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenType;
import org.panda_lang.panda.framework.language.interpreter.lexer.PandaLexer;
import org.panda_lang.panda.framework.language.interpreter.token.PandaToken;
import org.panda_lang.panda.utilities.commons.objects.StringUtils;

public class PandaLexerTokenExtractor {
    private final PandaLexer lexer;
    private final Syntax syntax;

    public PandaLexerTokenExtractor(PandaLexer lexer) {
        this.lexer = lexer;
        this.syntax = lexer.getSyntax();
    }

    protected boolean extract(StringBuilder tokenBuilder) {
        String tokenPreview = tokenBuilder.toString();
        while (tokenPreview.length() != 0) {
            if ((tokenPreview = tokenPreview.trim()).isEmpty()) {
                return true;
            }
            Token token = this.extractToken(tokenPreview, this.syntax.getSeparators(), this.syntax.getOperators(), this.syntax.getKeywords(), this.syntax.getLiterals());
            if (token == null) {
                if (StringUtils.containsCharacter(tokenPreview, this.syntax.getSpecialCharacters())) {
                    return false;
                }
                token = new PandaToken(TokenType.UNKNOWN, tokenPreview);
            }
            this.lexer.getTokenizedLine().add(token);
            tokenBuilder.delete(0, token.getTokenValue().length());
            tokenPreview = tokenBuilder.toString();
        }
        return true;
    }

    @SafeVarargs
    @Nullable
    protected final Token extractToken(String tokenPreview, Collection<? extends Token> ... tokensCollections) {
        for (Collection<? extends Token> tokensCollection : tokensCollections) {
            for (Token token : tokensCollection) {
                if (!tokenPreview.startsWith(token.getTokenValue()) || (token.getType() == TokenType.KEYWORD || token.getType() == TokenType.LITERAL) && tokenPreview.length() > token.getTokenValue().length()) continue;
                return token;
            }
        }
        return null;
    }
}

