/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.parser;

import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserFailure;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.SourceStream;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaSourceStream;

public class PandaParserFailure
extends ParserFailure {
    private final ParserData data;
    private final String message;
    private final String details;
    private final int currentLine;
    private final String element;

    public PandaParserFailure(String message, ParserData data) {
        this(message, null, data);
    }

    public PandaParserFailure(String message, String details, ParserData data) {
        this(PandaParserFailure.builder().message(message).details(details).data(data));
    }

    private PandaParserFailure(PandaParserFailureBuilder builder) {
        super(builder.message);
        this.message = builder.message;
        this.details = builder.details;
        this.data = builder.data.fork();
        SourceStream source = builder.source != null ? builder.source : this.data.getComponent(UniversalComponents.SOURCE_STREAM);
        source.restoreCachedSource();
        this.currentLine = source.getCurrentLine();
        this.element = source.readLineResidue().toString();
    }

    @Override
    public ParserData getData() {
        return this.data;
    }

    @Override
    public String getElement() {
        return this.element;
    }

    @Override
    public String getSource() {
        return this.data.getComponent(UniversalComponents.SOURCE).selectLine(this.getLine()).toString();
    }

    @Override
    public String getLocation() {
        return this.data.getComponent(UniversalComponents.SCRIPT).getScriptName();
    }

    @Override
    public int getLine() {
        return this.currentLine;
    }

    @Override
    public String getDetails() {
        return this.details;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static PandaParserFailureBuilder builder() {
        return new PandaParserFailureBuilder();
    }

    public static class PandaParserFailureBuilder {
        private String message;
        private String details;
        private ParserData data;
        private SourceStream source;

        public PandaParserFailureBuilder message(String message) {
            this.message = message;
            return this;
        }

        public PandaParserFailureBuilder details(String details) {
            this.details = details;
            return this;
        }

        public PandaParserFailureBuilder data(ParserData data) {
            this.data = data;
            return this;
        }

        public PandaParserFailureBuilder source(TokenizedSource source) {
            this.source = new PandaSourceStream(source);
            return this;
        }

        public PandaParserFailureBuilder source(SourceStream source) {
            this.source = source;
            return this;
        }

        public PandaParserFailure build() {
            return new PandaParserFailure(this);
        }
    }
}

