/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.parser.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserHandler;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserPipeline;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.SourceStream;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.TokenReader;
import org.panda_lang.panda.framework.language.interpreter.parser.pipeline.ParserRepresentationComparator;

public class PandaParserPipeline
implements ParserPipeline {
    private final ParserPipeline parentPipeline;
    private final List<ParserRepresentation> representations;
    private final Comparator<ParserRepresentation> comparator;
    private long handleTime;
    private int count;

    public PandaParserPipeline() {
        this(null);
    }

    public PandaParserPipeline(ParserPipeline parentPipeline) {
        this.parentPipeline = parentPipeline;
        this.representations = new ArrayList<ParserRepresentation>();
        this.comparator = new ParserRepresentationComparator();
    }

    @Override
    public UnifiedParser handle(SourceStream stream) {
        UnifiedParser parser;
        if (this.count > 100) {
            this.count = 0;
            this.sort();
        }
        if (this.parentPipeline != null && (parser = this.handle(stream, this.parentPipeline.getRepresentations())) != null) {
            return parser;
        }
        return this.handle(stream, this.representations);
    }

    @Nullable
    private UnifiedParser handle(SourceStream stream, Collection<ParserRepresentation> representations) {
        long currentTime = System.nanoTime();
        for (ParserRepresentation representation : representations) {
            TokenReader tokenReader;
            ParserHandler parserHandler = representation.getHandler();
            if (!parserHandler.handle(tokenReader = stream.toTokenReader())) continue;
            representation.increaseUsages();
            ++this.count;
            this.handleTime += System.nanoTime() - currentTime;
            return representation.getParser();
        }
        this.handleTime += System.nanoTime() - currentTime;
        return null;
    }

    protected void sort() {
        this.representations.sort(this.comparator);
    }

    @Override
    public long getHandleTime() {
        return this.handleTime;
    }

    @Override
    public void registerParserRepresentation(ParserRepresentation parserRepresentation) {
        this.representations.add(parserRepresentation);
        this.sort();
    }

    public List<ParserRepresentation> getRepresentations() {
        return this.representations;
    }
}

