/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.abyss;

import java.util.List;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.TokenReader;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPatternUnit;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPatternUtils;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor.AbyssExtractor;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaTokenReader;

public class AbyssPattern {
    private final AbyssPatternUnit[] units;
    private final Token fissureToken;
    private final int amountOfHollows;
    private final int maxNestingLevel;
    private final boolean keepingOpposites;
    private final boolean lastIndexAlgorithm;

    public AbyssPattern(AbyssPatternUnit[] units, Token fissureToken, int maxNestingLevel, boolean keepOpposites, boolean lastIndexAlgorithm) {
        this.units = units;
        this.fissureToken = fissureToken;
        this.maxNestingLevel = maxNestingLevel;
        this.keepingOpposites = keepOpposites;
        this.lastIndexAlgorithm = lastIndexAlgorithm;
        this.amountOfHollows = AbyssPatternUtils.countGaps(units);
    }

    public List<TokenizedSource> match(TokenizedSource source) {
        return this.match(new PandaTokenReader(source));
    }

    public List<TokenizedSource> match(TokenReader tokenReader) {
        int index = tokenReader.getIndex();
        AbyssExtractor extractor = this.extractor();
        List<TokenizedSource> result = extractor.extract(tokenReader);
        tokenReader.setIndex(index);
        return result;
    }

    public AbyssExtractor extractor() {
        return new AbyssExtractor(this);
    }

    public boolean endsWithGap() {
        return this.units[this.units.length - 1].isAbyss();
    }

    public boolean hasLastIndexAlgorithmEnabled() {
        return this.lastIndexAlgorithm;
    }

    public boolean hasKeepingOppositesEnabled() {
        return this.keepingOpposites;
    }

    public int getMaxNestingLevel() {
        return this.maxNestingLevel;
    }

    public int getAmountOfHollows() {
        return this.amountOfHollows;
    }

    public Token getFissureToken() {
        return this.fissureToken;
    }

    public AbyssPatternUnit[] getUnits() {
        return this.units;
    }
}

