/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils;

import java.util.ArrayList;
import java.util.List;
import org.panda_lang.panda.framework.design.interpreter.token.Syntax;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenType;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPatternTokens;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPatternUnit;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternCompiler;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.separator.Separators;

public class AbyssPatternBuilder {
    private final List<AbyssPatternUnit> units = new ArrayList<AbyssPatternUnit>();
    private Token fissureToken = Separators.SEMICOLON;
    private int maxNestingLevel;
    private boolean keepOpposites = true;
    private boolean lastIndexAlgorithm;

    public AbyssPatternBuilder maxNestingLevel(int maxNestingLevel) {
        this.maxNestingLevel = maxNestingLevel;
        return this;
    }

    public AbyssPatternBuilder keepOpposites(boolean keepOpposites) {
        this.keepOpposites = keepOpposites;
        return this;
    }

    public AbyssPatternBuilder lastIndexAlgorithm(boolean lastIndexAlgorithm) {
        this.lastIndexAlgorithm = lastIndexAlgorithm;
        return this;
    }

    public AbyssPatternBuilder fissureToken(Token fissureToken) {
        this.fissureToken = fissureToken;
        return this;
    }

    public AbyssPatternBuilder unit(Token token) {
        return this.unit(token.getType(), token.getTokenValue(), false);
    }

    public AbyssPatternBuilder unit(Token token, boolean optional) {
        return this.unit(token.getType(), token.getTokenValue(), optional);
    }

    public AbyssPatternBuilder unit(TokenType type, String token) {
        return this.unit(type, token, false);
    }

    public AbyssPatternBuilder unit(TokenType type, String token, boolean optional) {
        AbyssPatternUnit unit = new AbyssPatternUnit(type, token, optional);
        this.units.add(unit);
        return this;
    }

    public AbyssPatternBuilder simpleHollow() {
        this.units.add(AbyssPatternTokens.SIMPLE_ABYSS);
        return this;
    }

    public AbyssPatternBuilder hollow() {
        this.units.add(AbyssPatternTokens.ABYSS);
        return this;
    }

    public AbyssPatternBuilder compile(Syntax syntax, String expression) {
        AbyssPatternCompiler compiler = new AbyssPatternCompiler(this, syntax);
        compiler.compile(expression);
        return this;
    }

    public AbyssPattern build() {
        AbyssPatternUnit[] unitsArray = new AbyssPatternUnit[this.units.size()];
        this.units.toArray(unitsArray);
        return new AbyssPattern(unitsArray, this.fissureToken, this.maxNestingLevel, this.keepOpposites, this.lastIndexAlgorithm);
    }
}

