/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements;

import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternNode;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternUnit;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.elements.LexicalPatternWildcard;
import org.panda_lang.panda.utilities.commons.objects.CharacterUtils;

public interface LexicalPatternElement {
    public void setOptional(boolean var1);

    public void setIdentifier(String var1);

    public void setIsolationType(Isolation var1);

    public boolean isOptional();

    public boolean hasIdentifier();

    public Isolation getIsolationType();

    public String getIdentifier();

    default public boolean isVariant() {
        return this.isNode() && this.toNode().isVariant();
    }

    default public boolean isWildcard() {
        return this instanceof LexicalPatternWildcard;
    }

    default public boolean isNode() {
        return this instanceof LexicalPatternNode;
    }

    default public boolean isUnit() {
        return this instanceof LexicalPatternUnit;
    }

    default public LexicalPatternWildcard toWildcard() {
        return (LexicalPatternWildcard)this;
    }

    default public LexicalPatternNode toNode() {
        return (LexicalPatternNode)this;
    }

    default public LexicalPatternUnit toUnit() {
        return (LexicalPatternUnit)this;
    }

    public static enum Isolation {
        NONE(false, false),
        START(true, false),
        END(false, true),
        BOTH(true, true);

        private final boolean start;
        private final boolean end;

        private Isolation(boolean start, boolean end) {
            this.start = start;
            this.end = end;
        }

        public boolean isAny() {
            return this.isStart() || this.isEnd();
        }

        public boolean isStart() {
            return this.start;
        }

        public boolean isEnd() {
            return this.end;
        }

        public static Isolation merge(Isolation a, Isolation b) {
            return Isolation.of(a.isStart() || b.isStart(), a.isEnd() || b.isEnd());
        }

        public static Isolation of(String string) {
            return Isolation.of(string.charAt(0), string.charAt(string.length() - 1));
        }

        public static Isolation of(char start, char end) {
            return Isolation.of(CharacterUtils.isWhitespace(start), CharacterUtils.isWhitespace(end));
        }

        public static Isolation of(boolean start, boolean end) {
            for (Isolation isolation : Isolation.values()) {
                if (isolation.start != start || isolation.end != end) continue;
                return isolation;
            }
            return NONE;
        }
    }
}

