/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.pattern.lexical.extractor;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.language.interpreter.pattern.lexical.extractor.processed.ProcessedValue;
import org.panda_lang.panda.utilities.commons.objects.StringUtils;

public class LexicalExtractorResult<T> {
    private final boolean matched;
    private final List<String> wildcards;
    private final List<String> identifiers;
    private final List<ProcessedValue<T>> processedValues;

    public LexicalExtractorResult(boolean matched) {
        this.matched = matched;
        this.identifiers = matched ? new ArrayList() : null;
        this.wildcards = matched ? new ArrayList() : null;
        this.processedValues = matched ? new ArrayList() : null;
    }

    public LexicalExtractorResult<T> addWildcard(@Nullable String wildcardContent) {
        if (!StringUtils.isEmpty(wildcardContent)) {
            this.wildcards.add(wildcardContent);
        }
        return this;
    }

    public LexicalExtractorResult<T> addIdentifier(@Nullable String identifier) {
        if (!StringUtils.isEmpty(identifier)) {
            this.identifiers.add(identifier);
        }
        return this;
    }

    public LexicalExtractorResult<T> addProcessedValue(@Nullable ProcessedValue<T> processedValue) {
        if (processedValue != null) {
            this.processedValues.add(processedValue);
        }
        return this;
    }

    public void merge(LexicalExtractorResult<T> result) {
        if (!result.isMatched()) {
            throw new RuntimeException("Cannot merge unmatched result");
        }
        this.processedValues.addAll(result.processedValues);
        this.identifiers.addAll(result.identifiers);
        this.wildcards.addAll(result.wildcards);
    }

    public boolean isMatched() {
        return this.matched;
    }

    @Nullable
    public List<ProcessedValue<T>> getProcessedValues() {
        return this.processedValues;
    }

    @Nullable
    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    @Nullable
    public List<String> getWildcards() {
        return this.wildcards;
    }
}

