/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.token.distributor;

import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.TokenReader;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.TokenReaderIterator;
import org.panda_lang.panda.utilities.commons.arrays.ArrayDistributor;

public class PandaTokenReaderIterator
implements TokenReaderIterator {
    private final TokenReader tokenReader;
    private ArrayDistributor<TokenRepresentation> representationsDistributor;

    public PandaTokenReaderIterator(TokenReader tokenReader) {
        this.tokenReader = tokenReader;
        this.representationsDistributor = new ArrayDistributor<TokenRepresentation>(tokenReader.getTokenizedSource().toArray());
    }

    @Override
    public void synchronize() {
        this.setIndex(this.tokenReader.getIndex());
    }

    @Override
    public TokenRepresentation next() {
        return this.representationsDistributor.next();
    }

    @Override
    public TokenRepresentation previous() {
        return this.representationsDistributor.previous();
    }

    @Override
    public boolean hasNext() {
        return this.getIndex() + 1 < this.tokenReader.getTokenizedSource().size();
    }

    @Override
    public void setIndex(int index) {
        this.representationsDistributor.setIndex(index);
    }

    public ArrayDistributor<TokenRepresentation> getRepresentationsDistributor() {
        return this.representationsDistributor;
    }

    @Override
    public int getIndex() {
        return this.representationsDistributor.getIndex();
    }
}

