/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.token.utils;

import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenType;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.utilities.commons.objects.StringUtils;

public class TokenUtils {
    public static String extractToken(TokenizedSource tokenizedSource, int i) {
        if (i >= tokenizedSource.size()) {
            return null;
        }
        Token token = tokenizedSource.getToken(0);
        return token.getName();
    }

    public static boolean contains(TokenizedSource source, Token token) {
        return TokenUtils.contains(source, token.getType(), token.getTokenValue());
    }

    public static boolean contains(TokenizedSource source, TokenType type, String value) {
        for (TokenRepresentation representation : source.getTokensRepresentations()) {
            if (!TokenUtils.equals(representation, type, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumber(Token token) {
        return StringUtils.isNumber(token.getTokenValue());
    }

    public static int getLine(TokenizedSource tokenizedSource) {
        return tokenizedSource.size() > 0 ? tokenizedSource.get(0).getLine() + 1 : -1;
    }

    public static boolean equals(TokenRepresentation tokenRepresentation, Token token) {
        return TokenUtils.equals(tokenRepresentation, token.getType(), token.getTokenValue());
    }

    public static boolean equals(TokenRepresentation tokenRepresentation, TokenType tokenType, String tokenValue) {
        return tokenRepresentation != null && TokenUtils.equals(tokenRepresentation.getToken(), tokenType, tokenValue);
    }

    public static boolean equals(Token token, Token another) {
        return TokenUtils.equals(another, token.getType(), token.getTokenValue());
    }

    public static boolean equals(Token anotherToken, TokenType tokenType, String tokenValue) {
        return anotherToken.getType() == tokenType && anotherToken.getTokenValue().equals(tokenValue);
    }
}

