/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.interpreter.token.utils.vague;

import java.util.Stack;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenRepresentation;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.TokenReader;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.token.PandaTokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.separator.Separator;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;
import org.panda_lang.panda.framework.language.interpreter.token.utils.vague.VagueElement;
import org.panda_lang.panda.framework.language.interpreter.token.utils.vague.VagueExtractor;
import org.panda_lang.panda.framework.language.interpreter.token.utils.vague.VagueResult;

public class VagueWorker {
    private final VagueExtractor extractor;
    private final VagueResult result;
    private final TokenReader source;
    private Stack<Separator> separators = new Stack();
    private PandaTokenizedSource expression = new PandaTokenizedSource();

    public VagueWorker(VagueExtractor extractor, VagueResult result, TokenReader source) {
        this.extractor = extractor;
        this.result = result;
        this.source = source;
    }

    public VagueResult extract() {
        for (TokenRepresentation representation : this.source) {
            if (this.isDivider(representation)) {
                this.pullFragment(representation);
                continue;
            }
            if (this.isSeparator(representation)) {
                Separator previousSeparator;
                Separator opposite;
                Token token = representation.getToken();
                if (!(token instanceof Separator)) {
                    throw new PandaParserException("Token is not separator");
                }
                Separator separator = (Separator)token;
                if (this.separators.size() > 0 && separator.equals(opposite = (previousSeparator = this.separators.peek()).getOpposite())) {
                    this.separators.pop();
                    if (this.pullFragment(representation, 0)) continue;
                }
                if (separator.hasOpposite()) {
                    this.separators.push(separator);
                    if (this.pullFragment(representation, 1)) continue;
                }
            }
            this.expression.addToken(representation);
        }
        if (this.expression.size() != 0) {
            this.addExpression(this.expression);
        }
        this.result.succeed();
        return this.result;
    }

    private boolean pullFragment(TokenRepresentation operatorRepresentation, int requiredSeparators) {
        if (this.separators.size() == requiredSeparators) {
            this.pullFragment(operatorRepresentation);
            return true;
        }
        return false;
    }

    private void pullFragment(TokenRepresentation operatorRepresentation) {
        if (this.expression.size() != 0) {
            this.addExpression(this.expression);
            this.expression = new PandaTokenizedSource();
        }
        this.addOperator(operatorRepresentation);
    }

    private void addExpression(TokenizedSource expressionSource) {
        VagueElement expressionElement = new VagueElement(expressionSource);
        this.result.addElement(expressionElement);
    }

    private void addOperator(TokenRepresentation operatorRepresentation) {
        VagueElement operatorElement = new VagueElement(operatorRepresentation);
        this.result.addElement(operatorElement);
    }

    private boolean isDivider(TokenRepresentation representation) {
        return this.contains(this.extractor.getDividers(), representation);
    }

    private boolean isSeparator(TokenRepresentation representation) {
        return this.contains(this.extractor.getSeparators(), representation);
    }

    private boolean contains(Token[] tokens, TokenRepresentation representation) {
        for (Token token : tokens) {
            if (!TokenUtils.equals(representation, token)) continue;
            return true;
        }
        return false;
    }
}

