/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.general.argument;

import java.util.ArrayList;
import java.util.List;
import org.panda_lang.panda.framework.design.interpreter.parser.Parser;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.TokenReader;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor.AbyssExtractor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaSourceStream;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.ExpressionParser;
import org.panda_lang.panda.language.runtime.expression.Expression;

public class ArgumentParser
implements Parser {
    private static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "+* , +*").build();

    public Expression[] parse(ParserData info, TokenizedSource tokenizedSource) {
        PandaSourceStream sourceStream = new PandaSourceStream(tokenizedSource);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        ExpressionParser expressionParser = new ExpressionParser();
        AbyssExtractor extractor = PATTERN.extractor();
        while (sourceStream.hasUnreadSource()) {
            TokenReader reader = sourceStream.toTokenReader();
            List<TokenizedSource> gaps = extractor.extract(reader);
            if (gaps == null) {
                Expression expression = this.readArgument(info, expressionParser, sourceStream.toTokenizedSource());
                expressions.add(expression);
                break;
            }
            TokenizedSource argument = gaps.get(0);
            Expression expression = this.readArgument(info, expressionParser, argument);
            expressions.add(expression);
            sourceStream.read(argument.size() + 1);
        }
        Expression[] expressionsArray = new Expression[expressions.size()];
        expressions.toArray(expressionsArray);
        return expressionsArray;
    }

    private Expression readArgument(ParserData info, ExpressionParser expressionParser, TokenizedSource argument) {
        Expression expression = expressionParser.parse(info, argument);
        if (expression == null) {
            throw new PandaParserException("Cannot parse argument " + argument + " at line " + TokenUtils.getLine(argument));
        }
        return expression;
    }
}

