/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.general.expression.callbacks.instance;

import java.util.Arrays;
import java.util.List;
import org.panda_lang.panda.framework.design.architecture.PandaScript;
import org.panda_lang.panda.framework.design.architecture.module.ModuleLoader;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.ConstructorUtils;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.PrototypeConstructor;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserFailure;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.extractor.AbyssExtractor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaTokenReader;
import org.panda_lang.panda.framework.language.parser.implementation.general.argument.ArgumentParser;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.ExpressionCallbackParser;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.callbacks.instance.InstanceExpressionCallback;
import org.panda_lang.panda.language.runtime.expression.Expression;

public class InstanceExpressionParser
implements ExpressionCallbackParser<InstanceExpressionCallback> {
    private static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "new +** ( +* )").build();
    private ClassPrototype returnType;
    private PrototypeConstructor constructor;
    private Expression[] arguments;

    @Override
    public void parse(TokenizedSource source, ParserData info) {
        PandaScript script = info.getComponent(PandaComponents.PANDA_SCRIPT);
        PandaTokenReader reader = new PandaTokenReader(source);
        AbyssExtractor extractor = PATTERN.extractor();
        List<TokenizedSource> gaps = extractor.extract(reader);
        if (gaps == null) {
            throw new PandaParserException("Cannot parse expression::instance");
        }
        String className = gaps.get(0).asString();
        ModuleLoader moduleLoader = script.getModuleLoader();
        this.returnType = moduleLoader.forClass(className);
        if (this.returnType == null) {
            throw PandaParserFailure.builder().message("Unknown return type '" + className + "'").data(info).source(source).build();
        }
        ArgumentParser argumentParser = new ArgumentParser();
        this.arguments = argumentParser.parse(info, gaps.get(1));
        this.constructor = ConstructorUtils.matchConstructor(this.returnType, this.arguments);
        if (this.constructor == null) {
            throw new PandaParserException("Cannot find constructor for the specified arguments " + Arrays.toString(this.arguments));
        }
    }

    @Override
    public InstanceExpressionCallback toCallback() {
        return new InstanceExpressionCallback(this.returnType, this.constructor, this.arguments);
    }

    public Expression[] getArguments() {
        return this.arguments;
    }

    public PrototypeConstructor getConstructor() {
        return this.constructor;
    }

    public ClassPrototype getReturnType() {
        return this.returnType;
    }
}

