/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.general.expression.callbacks.invoker;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactorHollows;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.callbacks.invoker.MethodInvokerExpressionParser;

public class MethodInvokerExpressionUtils {
    @Nullable
    public static MethodInvokerExpressionParser match(TokenizedSource source) {
        List<TokenizedSource> methodMatches = MethodInvokerExpressionParser.PATTERN.match(source);
        if (methodMatches == null || methodMatches.size() == 0) {
            return null;
        }
        AbyssRedactorHollows hollows = new AbyssRedactorHollows(methodMatches);
        AbyssRedactor redactor = new AbyssRedactor(hollows);
        redactor.map("method-call", "arguments");
        TokenizedSource methodCallSource = redactor.get("method-call");
        List<TokenizedSource> methodCallMatches = MethodInvokerExpressionParser.CALL_PATTERN.match(methodCallSource);
        TokenizedSource argumentsSource = redactor.get("arguments");
        TokenizedSource methodNameSource = methodCallSource;
        TokenizedSource instanceSource = null;
        if (methodCallMatches != null && methodCallMatches.size() > 0) {
            AbyssRedactorHollows methodCallHollows = new AbyssRedactorHollows(methodCallMatches);
            AbyssRedactor methodCallRedactor = new AbyssRedactor(methodCallHollows);
            methodCallRedactor.map("instance", "method-name");
            instanceSource = methodCallRedactor.get("instance");
            methodNameSource = methodCallRedactor.get("method-name");
        } else if (methodCallSource == null || methodCallSource.size() > 1) {
            return null;
        }
        return new MethodInvokerExpressionParser(instanceSource, methodNameSource, argumentsSource);
    }
}

