/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.general.expression.callbacks.math;

import java.util.Stack;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.module.PrimitivePrototypeLiquid;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.language.architecture.value.PandaValue;
import org.panda_lang.panda.framework.language.runtime.PandaRuntimeException;
import org.panda_lang.panda.language.runtime.ExecutableBranch;
import org.panda_lang.panda.language.runtime.expression.Expression;
import org.panda_lang.panda.language.runtime.expression.ExpressionCallback;

public class MathExpressionCallback
implements ExpressionCallback {
    private final ModulePath modulePath;
    private final Stack<Object> mathStack;

    public MathExpressionCallback(ModulePath modulePath, Stack<Object> mathStack) {
        this.mathStack = mathStack;
        this.modulePath = modulePath;
    }

    @Override
    public Value call(Expression expression, ExecutableBranch branch) {
        Stack<Value> values = new Stack<Value>();
        for (Object e : this.mathStack) {
            if (e instanceof Token) {
                int cValue;
                Token operator = (Token)e;
                Value a = (Value)values.pop();
                Value b = (Value)values.pop();
                int aValue = (Integer)a.getValue();
                int bValue = (Integer)b.getValue();
                switch (operator.getTokenValue()) {
                    case "+": {
                        cValue = aValue + bValue;
                        break;
                    }
                    case "-": {
                        cValue = aValue - bValue;
                        break;
                    }
                    case "*": {
                        cValue = aValue * bValue;
                        break;
                    }
                    case "/": {
                        cValue = aValue / bValue;
                        break;
                    }
                    default: {
                        throw new PandaRuntimeException("Unknown operator");
                    }
                }
                PandaValue c = new PandaValue(PrimitivePrototypeLiquid.INT, cValue);
                values.push(c);
                continue;
            }
            Expression mathExpression = (Expression)e;
            values.push(mathExpression.getExpressionValue(branch));
        }
        return (Value)values.pop();
    }

    public ClassPrototype getReturnType() {
        return PrimitivePrototypeLiquid.INT;
    }
}

