/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.general.expression.callbacks.math;

import java.util.Stack;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.Parser;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.token.Token;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.operator.Operators;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.separator.Separator;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.separator.Separators;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaTokenReader;
import org.panda_lang.panda.framework.language.interpreter.token.utils.vague.VagueElement;
import org.panda_lang.panda.framework.language.interpreter.token.utils.vague.VagueExtractor;
import org.panda_lang.panda.framework.language.interpreter.token.utils.vague.VagueResult;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.ExpressionParser;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.callbacks.math.MathExpressionCallback;
import org.panda_lang.panda.language.runtime.expression.Expression;

public class MathParser
implements Parser {
    protected static final VagueExtractor EXTRACTOR = new VagueExtractor(new Separator[]{Separators.LEFT_PARENTHESIS_DELIMITER, Separators.RIGHT_PARENTHESIS_DELIMITER}, new Token[]{Operators.ADDITION, Operators.SUBTRACTION, Operators.DIVISION, Operators.MULTIPLICATION});

    public MathExpressionCallback parse(TokenizedSource source, ParserData data) {
        PandaTokenReader reader = new PandaTokenReader(source);
        VagueResult result = EXTRACTOR.extract(reader);
        Stack<Object> math = new Stack<Object>();
        Stack<Token> operators = new Stack<Token>();
        ExpressionParser expressionParser = new ExpressionParser();
        block13: for (VagueElement element : result.getElements()) {
            if (element.isExpression()) {
                Expression expression = expressionParser.parse(data, element.getExpression());
                math.push(expression);
                continue;
            }
            Token operator = element.getOperator().getToken();
            switch (operator.getTokenValue()) {
                case "+": 
                case "-": 
                case "*": 
                case "/": {
                    if (operators.size() != 0 && this.compare((Token)operators.peek(), operator)) {
                        math.push(operators.pop());
                    }
                    operators.push(operator);
                    continue block13;
                }
                case "(": {
                    operators.push(operator);
                    continue block13;
                }
                case ")": {
                    while (!((Token)operators.peek()).getTokenValue().equals("(")) {
                        math.push(operators.pop());
                    }
                    operators.pop();
                    continue block13;
                }
            }
            throw new PandaParserException("Unexpected operator " + operator);
        }
        while (operators.size() != 0) {
            math.push(operators.pop());
        }
        ModulePath registry = data.getComponent(PandaComponents.MODULE_REGISTRY);
        return new MathExpressionCallback(registry, math);
    }

    public boolean compare(Token prev, Token current) {
        return this.getOrder(prev.getTokenValue()) >= this.getOrder(current.getTokenValue());
    }

    public int getOrder(String tokenValue) {
        switch (tokenValue) {
            case "*": 
            case "/": {
                return 2;
            }
            case "+": 
            case "-": {
                return 1;
            }
        }
        return 0;
    }
}

