/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.general.expression.callbacks.memory;

import org.panda_lang.panda.framework.design.architecture.prototype.ClassScopeInstance;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PrototypeField;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.language.runtime.PandaRuntimeException;
import org.panda_lang.panda.language.runtime.ExecutableBranch;
import org.panda_lang.panda.language.runtime.expression.Expression;
import org.panda_lang.panda.language.runtime.expression.ExpressionCallback;

public class FieldExpressionCallback
implements ExpressionCallback {
    private final Expression instanceExpression;
    private final PrototypeField field;
    private final int internalPointer;

    public FieldExpressionCallback(Expression instanceExpression, PrototypeField field, int internalPointer) {
        this.instanceExpression = instanceExpression;
        this.field = field;
        this.internalPointer = internalPointer;
    }

    @Override
    public Value call(Expression expression, ExecutableBranch branch) {
        if (this.field.isStatic()) {
            return this.field.getStaticValue().getValue();
        }
        Value instance = this.instanceExpression.getExpressionValue(branch);
        if (instance == null) {
            throw new PandaRuntimeException("Instance is not defined");
        }
        branch.instance(instance);
        if (this.field.isNative()) {
            return this.field.getDefaultValue().getExpressionValue(branch);
        }
        if (!(instance.getObject() instanceof ClassScopeInstance)) {
            throw new PandaRuntimeException("Cannot get field value of external object");
        }
        ClassScopeInstance pandaInstance = (ClassScopeInstance)instance.getObject();
        Value value = pandaInstance.get(this.internalPointer);
        if (value == null) {
            throw new PandaRuntimeException("Field '" + this.field.getName() + "' have not been initialized");
        }
        return value;
    }
}

