/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.general.number;

import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.utilities.commons.objects.CharacterUtils;

public class NumberUtils {
    protected static final char[] NUMBER_EXTENSIONS = new char[]{'b', 'B', 's', 'S', 'i', 'I', 'l', 'L', 'd', 'D', 'f', 'F'};

    public static boolean startsWithNumber(TokenizedSource source) {
        String str = source.asString();
        return NumberUtils.isNumber(str.substring(0, 1));
    }

    public static boolean isNumeric(TokenizedSource source) {
        return NumberUtils.isNumber(source.asString());
    }

    public static boolean isNumber(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        boolean digit = false;
        for (char c : s.toCharArray()) {
            if (Character.isDigit(c)) {
                digit = true;
                continue;
            }
            if (c == '.' || c == '_' || c == 'x' || CharacterUtils.belongsTo(c, NUMBER_EXTENSIONS)) continue;
            return false;
        }
        return digit;
    }
}

