/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.prototype;

import org.panda_lang.panda.framework.design.architecture.PandaScript;
import org.panda_lang.panda.framework.design.architecture.module.Module;
import org.panda_lang.panda.framework.design.architecture.module.ModulePath;
import org.panda_lang.panda.framework.design.architecture.module.PrimitivePrototypeLiquid;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassReference;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassScope;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassScopeInstance;
import org.panda_lang.panda.framework.design.architecture.prototype.PandaClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.ConstructorUtils;
import org.panda_lang.panda.framework.design.architecture.prototype.constructor.PrototypeConstructor;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PrototypeField;
import org.panda_lang.panda.framework.design.architecture.value.Value;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGeneration;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationCallback;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationLayer;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserPipeline;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserRegistration;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.registry.PipelineRegistry;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.parser.generation.casual.CasualParserGenerationAssistant;
import org.panda_lang.panda.framework.language.interpreter.parser.linker.PandaScopeLinker;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaSourceStream;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;
import org.panda_lang.panda.framework.language.parser.implementation.prototype.ClassPrototypeComponents;
import org.panda_lang.panda.framework.language.parser.implementation.prototype.ClassPrototypeParserHandler;
import org.panda_lang.panda.framework.language.parser.implementation.prototype.ClassPrototypeParserUtils;
import org.panda_lang.panda.language.runtime.ExecutableBranch;

@ParserRegistration(target={"overall"}, parserClass=ClassPrototypeParser.class, handlerClass=ClassPrototypeParserHandler.class)
public class ClassPrototypeParser
implements UnifiedParser {
    protected static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "class +** { +* }").build();

    @Override
    public void parse(ParserData data) {
        CasualParserGenerationAssistant.delegateImmediately(data, new ClassPrototypeExtractorCasualCallback());
    }

    private static class ClassPrototypeAfterCasualCallback
    implements CasualParserGenerationCallback {
        private ClassPrototypeAfterCasualCallback() {
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            ClassPrototype prototype = delegatedData.getComponent(ClassPrototypeComponents.CLASS_PROTOTYPE);
            final ClassScope scope = delegatedData.getComponent(ClassPrototypeComponents.CLASS_SCOPE);
            if (prototype.getConstructors().getAmountOfConstructors() > 0) {
                return;
            }
            for (PrototypeField prototypeField : prototype.getFields().getListOfFields()) {
                if (prototypeField.hasDefaultValue()) continue;
            }
            PrototypeConstructor defaultConstructor = new PrototypeConstructor(){

                @Override
                public ClassScopeInstance createInstance(ExecutableBranch branch, Value ... values) {
                    return scope.createInstance(branch);
                }

                @Override
                public ClassPrototype[] getParameterTypes() {
                    return ConstructorUtils.PARAMETERLESS;
                }
            };
            prototype.getConstructors().addConstructor(defaultConstructor);
        }
    }

    private static class ClassPrototypeBodyCasualParserCallback
    implements CasualParserGenerationCallback {
        private final AbyssRedactor redactor;

        private ClassPrototypeBodyCasualParserCallback(AbyssRedactor redactor) {
            this.redactor = redactor;
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            PipelineRegistry pipelineRegistry = delegatedData.getComponent(UniversalComponents.PIPELINE);
            ParserPipeline pipeline = pipelineRegistry.getPipeline("prototype");
            TokenizedSource bodySource = this.redactor.get("class-body");
            PandaSourceStream stream = new PandaSourceStream(bodySource);
            CasualParserGeneration generation = delegatedData.getComponent(UniversalComponents.GENERATION);
            ParserData bodyInfo = delegatedData.fork();
            bodyInfo.setComponent(UniversalComponents.SOURCE_STREAM, stream);
            while (stream.hasUnreadSource()) {
                UnifiedParser parser = pipeline.handle(stream);
                if (parser == null) {
                    throw new PandaParserException("Cannot parse the element of the prototype at line " + TokenUtils.getLine(stream.toTokenizedSource()));
                }
                parser.parse(bodyInfo);
                generation.executeImmediately(delegatedData);
            }
        }
    }

    private static class ClassPrototypeDeclarationCasualParserCallback
    implements CasualParserGenerationCallback {
        private ClassPrototypeDeclarationCasualParserCallback() {
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            ClassPrototypeParserUtils.readDeclaration(delegatedData);
        }
    }

    private static class ClassPrototypeExtractorCasualCallback
    implements CasualParserGenerationCallback {
        private ClassPrototypeExtractorCasualCallback() {
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            PandaScript script = delegatedData.getComponent(PandaComponents.PANDA_SCRIPT);
            Module module = script.getModule();
            AbyssRedactor redactor = AbyssPatternAssistant.traditionalMapping(PATTERN, delegatedData, "class-declaration", "class-body");
            delegatedData.setComponent(PandaComponents.REDACTOR, redactor);
            TokenizedSource classDeclaration = redactor.get("class-declaration");
            String className = classDeclaration.getTokenValue(0);
            if (className == null) {
                throw new PandaParserException("Class name cannot be null");
            }
            PandaClassPrototype classPrototype = new PandaClassPrototype(className, Object.class, new String[0]);
            delegatedData.setComponent(ClassPrototypeComponents.CLASS_PROTOTYPE, classPrototype);
            module.add(classPrototype);
            ModulePath registry = delegatedData.getComponent(PandaComponents.MODULE_REGISTRY);
            classPrototype.getExtended().add(PrimitivePrototypeLiquid.OBJECT);
            delegatedData.setComponent(ClassPrototypeComponents.CLASS_PROTOTYPE, classPrototype);
            ClassScope classScope = new ClassScope(classPrototype);
            delegatedData.setComponent(ClassPrototypeComponents.CLASS_SCOPE, classScope);
            ClassReference classReference = new ClassReference(classPrototype, classScope);
            script.getStatements().add(classReference);
            PandaScopeLinker classScopeLinker = new PandaScopeLinker(classScope);
            delegatedData.setComponent(PandaComponents.SCOPE_LINKER, classScopeLinker);
            if (classDeclaration.size() > 1) {
                nextLayer.delegate(new ClassPrototypeDeclarationCasualParserCallback(), delegatedData);
            }
            nextLayer.delegate(new ClassPrototypeBodyCasualParserCallback(redactor), delegatedData);
            nextLayer.delegateAfter(new ClassPrototypeAfterCasualCallback(), delegatedData);
        }
    }
}

