/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.statement.scope.block;

import org.panda_lang.panda.framework.design.architecture.dynamic.Block;
import org.panda_lang.panda.framework.design.architecture.statement.Container;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.UnifiedParser;
import org.panda_lang.panda.framework.design.interpreter.parser.component.UniversalComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationCallback;
import org.panda_lang.panda.framework.design.interpreter.parser.generation.casual.CasualParserGenerationLayer;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserPipeline;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.ParserRegistration;
import org.panda_lang.panda.framework.design.interpreter.parser.pipeline.registry.PipelineRegistry;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.parser.generation.casual.CasualParserGenerationAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.redactor.AbyssRedactor;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternAssistant;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaSourceStream;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;
import org.panda_lang.panda.framework.language.parser.implementation.ContainerParser;
import org.panda_lang.panda.framework.language.parser.implementation.statement.scope.block.BlockComponents;
import org.panda_lang.panda.framework.language.parser.implementation.statement.scope.block.BlockParserHandler;

@ParserRegistration(target={"scope"}, parserClass=BlockParser.class, handlerClass=BlockParserHandler.class, priority=1)
public class BlockParser
implements UnifiedParser {
    protected static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "+** { +* }").build();

    @Override
    public void parse(ParserData data) {
        CasualParserGenerationAssistant.delegateImmediately(data, new BlockDeclarationCasualParserCallback());
    }

    private static class BlockBodyCasualParserCallback
    implements CasualParserGenerationCallback {
        private final AbyssRedactor redactor;

        public BlockBodyCasualParserCallback(AbyssRedactor redactor) {
            this.redactor = redactor;
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            Container container = delegatedData.getComponent(BlockComponents.BLOCK);
            TokenizedSource body = this.redactor.get("block-body");
            ContainerParser containerParser = new ContainerParser(container);
            containerParser.parse(delegatedData, body);
        }
    }

    private static class BlockDeclarationCasualParserCallback
    implements CasualParserGenerationCallback {
        private BlockDeclarationCasualParserCallback() {
        }

        @Override
        public void call(ParserData delegatedData, CasualParserGenerationLayer nextLayer) {
            boolean unlisted;
            TokenizedSource blockDeclaration;
            PandaSourceStream declarationStream;
            AbyssRedactor redactor = AbyssPatternAssistant.traditionalMapping(PATTERN, delegatedData, "block-declaration", "block-body");
            PipelineRegistry pipelineRegistry = delegatedData.getComponent(UniversalComponents.PIPELINE);
            ParserPipeline pipeline = pipelineRegistry.getPipeline("block");
            UnifiedParser blockParser = pipeline.handle(declarationStream = new PandaSourceStream(blockDeclaration = redactor.get("block-declaration")));
            if (blockParser == null) {
                throw new PandaParserException("Cannot recognize block at line " + TokenUtils.getLine(blockDeclaration));
            }
            ParserData blockParserData = delegatedData.fork();
            blockParserData.setComponent(UniversalComponents.SOURCE_STREAM, declarationStream);
            blockParser.parse(blockParserData);
            Block block = blockParserData.getComponent(BlockComponents.BLOCK);
            Boolean unlistedBlock = blockParserData.getComponent(BlockComponents.UNLISTED_BLOCK);
            boolean bl = unlisted = unlistedBlock != null && unlistedBlock != false;
            if (block == null) {
                throw new PandaParserException("Cannot find the result of block implementation (" + blockParser.getClass() + ")");
            }
            if (!unlisted) {
                Container container = delegatedData.getComponent(PandaComponents.CONTAINER);
                container.addStatement(block);
            }
            ParserData parentInfo = delegatedData.getComponent(UniversalComponents.PARENT_DATA);
            parentInfo.setComponent(BlockComponents.PREVIOUS_BLOCK, block);
            delegatedData.setComponent(BlockComponents.BLOCK, block);
            nextLayer.delegate(new BlockBodyCasualParserCallback(redactor), delegatedData);
        }
    }
}

