/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.framework.language.parser.implementation.statement.variable.parser;

import java.util.List;
import org.panda_lang.panda.framework.design.architecture.PandaScript;
import org.panda_lang.panda.framework.design.architecture.dynamic.ExecutableStatement;
import org.panda_lang.panda.framework.design.architecture.dynamic.accessor.FieldAccessor;
import org.panda_lang.panda.framework.design.architecture.dynamic.accessor.VariableAccessor;
import org.panda_lang.panda.framework.design.architecture.module.ModuleLoader;
import org.panda_lang.panda.framework.design.architecture.prototype.ClassPrototype;
import org.panda_lang.panda.framework.design.architecture.prototype.field.PrototypeField;
import org.panda_lang.panda.framework.design.architecture.statement.Container;
import org.panda_lang.panda.framework.design.architecture.statement.Scope;
import org.panda_lang.panda.framework.design.architecture.statement.StatementCell;
import org.panda_lang.panda.framework.design.architecture.value.Variable;
import org.panda_lang.panda.framework.design.interpreter.parser.PandaComponents;
import org.panda_lang.panda.framework.design.interpreter.parser.ParserData;
import org.panda_lang.panda.framework.design.interpreter.parser.linker.ScopeLinker;
import org.panda_lang.panda.framework.design.interpreter.token.TokenizedSource;
import org.panda_lang.panda.framework.design.interpreter.token.distributor.SourceStream;
import org.panda_lang.panda.framework.language.architecture.value.PandaVariable;
import org.panda_lang.panda.framework.language.interpreter.parser.PandaParserException;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPattern;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.AbyssPatternUtils;
import org.panda_lang.panda.framework.language.interpreter.pattern.abyss.utils.AbyssPatternBuilder;
import org.panda_lang.panda.framework.language.interpreter.token.PandaSyntax;
import org.panda_lang.panda.framework.language.interpreter.token.defaults.keyword.Keywords;
import org.panda_lang.panda.framework.language.interpreter.token.distributor.PandaSourceStream;
import org.panda_lang.panda.framework.language.interpreter.token.utils.TokenUtils;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.ExpressionParser;
import org.panda_lang.panda.framework.language.parser.implementation.general.expression.callbacks.instance.ThisExpressionCallback;
import org.panda_lang.panda.framework.language.parser.implementation.prototype.ClassPrototypeComponents;
import org.panda_lang.panda.framework.language.parser.implementation.statement.variable.VariableParserUtils;
import org.panda_lang.panda.framework.language.parser.implementation.statement.variable.parser.VarParserData;
import org.panda_lang.panda.framework.language.parser.implementation.statement.variable.parser.VarParserResult;
import org.panda_lang.panda.framework.language.runtime.expression.PandaExpression;
import org.panda_lang.panda.language.runtime.expression.Expression;

public class VarParser {
    public static final AbyssPattern PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "+**").build();
    public static final AbyssPattern ASSIGNATION_PATTERN = new AbyssPatternBuilder().compile(PandaSyntax.getInstance(), "+** = +*").build();

    public VarParserData toVarParserData(ParserData delegatedData, TokenizedSource source) {
        return this.toVarParserData(delegatedData, new PandaSourceStream(source));
    }

    public VarParserData toVarParserData(ParserData delegatedData, SourceStream sourceStream) {
        List<TokenizedSource> hollows = ASSIGNATION_PATTERN.extractor().extract(sourceStream.toTokenReader());
        boolean assignation = hollows != null && hollows.size() == 2;
        hollows = assignation ? AbyssPatternUtils.extract(ASSIGNATION_PATTERN, sourceStream).getGaps() : AbyssPatternUtils.extract(PATTERN, sourceStream).getGaps();
        Container container = delegatedData.getComponent(PandaComponents.CONTAINER);
        StatementCell cell = container.reserveCell();
        return new VarParserData(cell, hollows, assignation);
    }

    public VarParserResult parseVariable(VarParserData data, ParserData delegatedData) {
        ClassPrototype prototype;
        PrototypeField field;
        ExpressionParser expressionParser;
        Expression instanceExpression;
        TokenizedSource left = data.getHollows().get(0);
        ScopeLinker linker = delegatedData.getComponent(PandaComponents.SCOPE_LINKER);
        Scope scope = linker.getCurrentScope();
        if (left.size() > 2 && (instanceExpression = (expressionParser = new ExpressionParser()).parse(delegatedData, left.subSource(0, left.size() - 2), true)) != null && (field = (prototype = instanceExpression.getReturnType()).getFields().getField(left.getLast().getTokenValue())) != null) {
            return new VarParserResult(instanceExpression, field, false, scope, false);
        }
        if (left.size() >= 2) {
            String variableName = left.getLast().getTokenValue();
            String variableType = left.getLast(1).getTokenValue();
            PandaScript script = delegatedData.getComponent(PandaComponents.PANDA_SCRIPT);
            ModuleLoader moduleLoader = script.getModuleLoader();
            ClassPrototype type = moduleLoader.forClass(variableType);
            boolean mutable = TokenUtils.contains(left, Keywords.MUTABLE);
            boolean nullable = TokenUtils.contains(left, Keywords.NULLABLE);
            if (type == null) {
                throw new PandaParserException("Unknown type '" + variableType + "'");
            }
            PandaVariable variable = new PandaVariable(type, variableName, 0, mutable, nullable);
            return new VarParserResult(null, variable, true, scope, true);
        }
        if (left.size() == 1) {
            Variable variable = VariableParserUtils.getVariable(scope, left.getLast().getToken().getTokenValue());
            if (variable == null) {
                ClassPrototype prototype2 = delegatedData.getComponent(ClassPrototypeComponents.CLASS_PROTOTYPE);
                if (prototype2 == null) {
                    throw new PandaParserException("Cannot get field from non-prototype scope at line " + TokenUtils.getLine(left));
                }
                PandaExpression instanceExpression2 = new PandaExpression(prototype2, new ThisExpressionCallback());
                field = prototype2.getFields().getField(left.getLast().getTokenValue());
                return new VarParserResult(instanceExpression2, field, false, scope, false);
            }
            return new VarParserResult(null, variable, false, scope, true);
        }
        throw new PandaParserException("Cannot parse variable declaration: " + left);
    }

    public void parseAssignation(VarParserData data, VarParserResult result, ParserData delegatedData) {
        ExecutableStatement assigner;
        Variable variable = result.getVariable();
        ExpressionParser expressionParser = new ExpressionParser();
        TokenizedSource right = data.getHollows().get(1);
        Expression expressionValue = expressionParser.parse(delegatedData, right);
        if (expressionValue == null) {
            throw new PandaParserException("Cannot parse expression '" + right + "'");
        }
        if (result.isLocal()) {
            if (!expressionValue.isNull() && !expressionValue.getReturnType().isAssociatedWith(variable.getType())) {
                throw new PandaParserException("Return type is incompatible with the type of variable at line " + TokenUtils.getLine(right) + " (var: " + variable.getType().getClassName() + "; expr: " + expressionValue.getReturnType().getClassName() + ")");
            }
            assigner = new VariableAccessor(variable, VariableParserUtils.indexOf(result.getScope(), variable), expressionValue);
        } else {
            Expression instanceExpression = result.getInstanceExpression();
            String fieldName = result.getVariable().getName();
            ClassPrototype type = instanceExpression.getReturnType();
            PrototypeField field = type.getFields().getField(fieldName);
            if (field == null) {
                throw new PandaParserException("Field '" + fieldName + "' does not belong to " + type.getClassName());
            }
            if (!field.getType().equals(expressionValue.getReturnType())) {
                throw new PandaParserException("Return type is incompatible with the type of variable at line " + TokenUtils.getLine(right));
            }
            assigner = new FieldAccessor(instanceExpression, field, expressionValue);
        }
        data.getCell().setStatement(assigner);
    }
}

