/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.utilities.annotations.AnnotationsScanner;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerLogger;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerResource;
import org.panda_lang.panda.utilities.annotations.adapter.JavassistAdapter;
import org.panda_lang.panda.utilities.annotations.adapter.MetadataAdapter;
import org.panda_lang.panda.utilities.annotations.resource.AnnotationsScannerResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationsScannerConfiguration {
    private final Set<ClassLoader> classLoaders = new HashSet<ClassLoader>(2);
    private final Set<AnnotationsScannerResource<?>> resources = new HashSet(2);
    private final AnnotationsScannerResourceFactory resourceFactory = new AnnotationsScannerResourceFactory();
    private MetadataAdapter<ClassFile, FieldInfo, MethodInfo> metadataAdapter = new JavassistAdapter();
    private AnnotationsScannerLogger logger = new AnnotationsScannerLogger(LoggerFactory.getLogger(AnnotationsScanner.class));

    AnnotationsScannerConfiguration() {
    }

    public AnnotationsScanner build() {
        if (this.classLoaders.isEmpty()) {
            this.classLoaders.add(this.getClass().getClassLoader());
        }
        return new AnnotationsScanner(this);
    }

    public AnnotationsScannerConfiguration prepareDefaults() {
        return this.includeDefaultClassLoaders();
    }

    public AnnotationsScannerConfiguration logger(@Nullable Logger logger) {
        this.logger = new AnnotationsScannerLogger(logger);
        return this;
    }

    public AnnotationsScannerConfiguration metadataAdapter(MetadataAdapter<ClassFile, FieldInfo, MethodInfo> adapter) {
        this.metadataAdapter = adapter;
        return this;
    }

    public AnnotationsScannerConfiguration includeDefaultClassLoaders() {
        return this.includeClassLoaders(true, this.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader());
    }

    public AnnotationsScannerConfiguration includeClassLoaders(boolean includeParents, ClassLoader ... classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            this.includeClassLoader(includeParents, classLoader);
        }
        return this;
    }

    private void includeClassLoader(boolean includeParents, @Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        ClassLoader currentClassLoader = classLoader;
        while (currentClassLoader != null) {
            if (currentClassLoader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)currentClassLoader).getURLs();
                this.includeResources(urls);
            }
            currentClassLoader = includeParents ? currentClassLoader.getParent() : null;
        }
    }

    public AnnotationsScannerConfiguration includeJavaClassPath() {
        String javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath != null) {
            String[] paths;
            for (String path : paths = javaClassPath.split(File.pathSeparator)) {
                this.includePath(path);
            }
        }
        return this;
    }

    public AnnotationsScannerConfiguration includeSources(Class<?> clazz) {
        this.includeResources(clazz.getProtectionDomain().getCodeSource().getLocation());
        return this;
    }

    public AnnotationsScannerConfiguration includePath(String path) {
        try {
            URL url = new File(path).toURI().toURL();
            this.includeResources(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void includeResources(URL ... urls) {
        if (urls == null) {
            return;
        }
        HashSet currentResources = new HashSet(urls.length);
        for (URL url : urls) {
            AnnotationsScannerResource<?> resource = this.resourceFactory.createTypedResource(url);
            if (resource == null) {
                this.logger.warn("Unknown resource: " + url);
                continue;
            }
            currentResources.add(resource);
        }
        this.resources.addAll(currentResources);
    }

    public AnnotationsScannerConfiguration addClassLoader(ClassLoader ... classLoaders) {
        this.classLoaders.addAll(Arrays.asList(classLoaders));
        return this;
    }

    protected Set<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    protected MetadataAdapter<ClassFile, FieldInfo, MethodInfo> getMetadataAdapter() {
        return this.metadataAdapter;
    }

    protected Set<AnnotationsScannerResource<?>> getResources() {
        return this.resources;
    }

    protected AnnotationsScannerLogger getLogger() {
        return this.logger;
    }
}

