/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations.resource;

import java.io.File;
import java.net.URL;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerResource;
import org.panda_lang.panda.utilities.annotations.resource.AnnotationsScannerResourceURLType;
import org.panda_lang.panda.utilities.annotations.resource.JarAnnotationsScannerResource;
import org.panda_lang.panda.utilities.annotations.resource.SystemAnnotationScannerResource;

enum AnnotationsScannerResourceType implements AnnotationsScannerResourceURLType
{
    JAR_FILE{

        @Override
        public boolean matches(URL url) {
            return url.getProtocol().equals("file") && url.toExternalForm().contains(".jar");
        }

        @Override
        public AnnotationsScannerResource createResource(URL url) throws Exception {
            return new JarAnnotationsScannerResource(url);
        }
    }
    ,
    DIRECTORY{

        @Override
        public boolean matches(URL url) throws Exception {
            return url.getProtocol().equals("file") && !url.toExternalForm().contains(".jar") && new File(url.toURI()).isDirectory();
        }

        @Override
        public AnnotationsScannerResource createResource(URL url) throws Exception {
            return new SystemAnnotationScannerResource(url);
        }
    };


    @Nullable
    static AnnotationsScannerResourceType detect(URL url) {
        for (AnnotationsScannerResourceType type : AnnotationsScannerResourceType.values()) {
            try {
                if (!type.matches(url)) continue;
                return type;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    static AnnotationsScannerResource<?> createResource(AnnotationsScannerResourceType type, URL url) {
        try {
            return type.createResource(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    static AnnotationsScannerResource<?> createTypedResource(URL url) {
        AnnotationsScannerResourceType type = AnnotationsScannerResourceType.detect(url);
        return type != null ? AnnotationsScannerResourceType.createResource(type, url) : null;
    }
}

