/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.panda.utilities.annotations.resource;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.panda_lang.panda.utilities.annotations.AnnotationsScannerResource;
import org.panda_lang.panda.utilities.annotations.resource.SystemAnnotationScannerFile;

class SystemAnnotationScannerResource
extends AnnotationsScannerResource<SystemAnnotationScannerFile> {
    private final File file;

    SystemAnnotationScannerResource(URL url) throws URISyntaxException {
        super(url);
        this.file = new File(url.toURI());
        if (!this.file.isDirectory() || !this.file.canRead()) {
            throw new RuntimeException("Cannot use dir " + this.file);
        }
    }

    @Override
    public Iterator<SystemAnnotationScannerFile> iterator() {
        return new Iterator<SystemAnnotationScannerFile>(){
            Stack<File> stack = new Stack();
            {
                this.stack.addAll(SystemAnnotationScannerResource.this.listFiles(SystemAnnotationScannerResource.this.file));
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public SystemAnnotationScannerFile next() {
                File file = this.stack.pop();
                if (file.isDirectory()) {
                    this.stack.addAll(SystemAnnotationScannerResource.this.listFiles(file));
                    return this.next();
                }
                return new SystemAnnotationScannerFile(SystemAnnotationScannerResource.this, file);
            }
        };
    }

    @Override
    public Iterable<SystemAnnotationScannerFile> getFiles() {
        if (this.file == null || !this.file.exists()) {
            return Collections.emptyList();
        }
        return this;
    }

    @Override
    public String getPath() {
        if (this.file == null) {
            return "/NO-SUCH-DIRECTORY/";
        }
        return this.file.getPath().replace("\\", "/");
    }

    private List<File> listFiles(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            return Arrays.asList(files);
        }
        return new ArrayList<File>(0);
    }
}

